<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListEDocsByDocIds StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBListEDocsByDocIds extends AbstractStructBase
{
    /**
     * The authTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authTicket;
    /**
     * The secretKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secretKey;
    /**
     * The documentIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \LendingQB\ArrayType\LendingQBArrayOfGuid
     */
    public $documentIds;
    /**
     * The fieldsToRetrieve
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \LendingQB\ArrayType\LendingQBArrayOfEDocsFieldId
     */
    public $fieldsToRetrieve;
    /**
     * Constructor method for ListEDocsByDocIds
     * @uses LendingQBListEDocsByDocIds::setAuthTicket()
     * @uses LendingQBListEDocsByDocIds::setSecretKey()
     * @uses LendingQBListEDocsByDocIds::setDocumentIds()
     * @uses LendingQBListEDocsByDocIds::setFieldsToRetrieve()
     * @param string $authTicket
     * @param string $secretKey
     * @param \LendingQB\ArrayType\LendingQBArrayOfGuid $documentIds
     * @param \LendingQB\ArrayType\LendingQBArrayOfEDocsFieldId $fieldsToRetrieve
     */
    public function __construct($authTicket = null, $secretKey = null, \LendingQB\ArrayType\LendingQBArrayOfGuid $documentIds = null, \LendingQB\ArrayType\LendingQBArrayOfEDocsFieldId $fieldsToRetrieve = null)
    {
        $this
            ->setAuthTicket($authTicket)
            ->setSecretKey($secretKey)
            ->setDocumentIds($documentIds)
            ->setFieldsToRetrieve($fieldsToRetrieve);
    }
    /**
     * Get authTicket value
     * @return string|null
     */
    public function getAuthTicket()
    {
        return $this->authTicket;
    }
    /**
     * Set authTicket value
     * @param string $authTicket
     * @return \LendingQB\StructType\LendingQBListEDocsByDocIds
     */
    public function setAuthTicket($authTicket = null)
    {
        // validation for constraint: string
        if (!is_null($authTicket) && !is_string($authTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTicket, true), gettype($authTicket)), __LINE__);
        }
        $this->authTicket = $authTicket;
        return $this;
    }
    /**
     * Get secretKey value
     * @return string|null
     */
    public function getSecretKey()
    {
        return $this->secretKey;
    }
    /**
     * Set secretKey value
     * @param string $secretKey
     * @return \LendingQB\StructType\LendingQBListEDocsByDocIds
     */
    public function setSecretKey($secretKey = null)
    {
        // validation for constraint: string
        if (!is_null($secretKey) && !is_string($secretKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secretKey, true), gettype($secretKey)), __LINE__);
        }
        $this->secretKey = $secretKey;
        return $this;
    }
    /**
     * Get documentIds value
     * @return \LendingQB\ArrayType\LendingQBArrayOfGuid|null
     */
    public function getDocumentIds()
    {
        return $this->documentIds;
    }
    /**
     * Set documentIds value
     * @param \LendingQB\ArrayType\LendingQBArrayOfGuid $documentIds
     * @return \LendingQB\StructType\LendingQBListEDocsByDocIds
     */
    public function setDocumentIds(\LendingQB\ArrayType\LendingQBArrayOfGuid $documentIds = null)
    {
        $this->documentIds = $documentIds;
        return $this;
    }
    /**
     * Get fieldsToRetrieve value
     * @return \LendingQB\ArrayType\LendingQBArrayOfEDocsFieldId|null
     */
    public function getFieldsToRetrieve()
    {
        return $this->fieldsToRetrieve;
    }
    /**
     * Set fieldsToRetrieve value
     * @param \LendingQB\ArrayType\LendingQBArrayOfEDocsFieldId $fieldsToRetrieve
     * @return \LendingQB\StructType\LendingQBListEDocsByDocIds
     */
    public function setFieldsToRetrieve(\LendingQB\ArrayType\LendingQBArrayOfEDocsFieldId $fieldsToRetrieve = null)
    {
        $this->fieldsToRetrieve = $fieldsToRetrieve;
        return $this;
    }
}
