<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DownloadDocumentNonPdfBytesById StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBDownloadDocumentNonPdfBytesById extends AbstractStructBase
{
    /**
     * The docId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $docId;
    /**
     * The ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ticket;
    /**
     * Constructor method for DownloadDocumentNonPdfBytesById
     * @uses LendingQBDownloadDocumentNonPdfBytesById::setDocId()
     * @uses LendingQBDownloadDocumentNonPdfBytesById::setTicket()
     * @param string $docId
     * @param string $ticket
     */
    public function __construct($docId = null, $ticket = null)
    {
        $this
            ->setDocId($docId)
            ->setTicket($ticket);
    }
    /**
     * Get docId value
     * @return string
     */
    public function getDocId()
    {
        return $this->docId;
    }
    /**
     * Set docId value
     * @param string $docId
     * @return \LendingQB\StructType\LendingQBDownloadDocumentNonPdfBytesById
     */
    public function setDocId($docId = null)
    {
        // validation for constraint: string
        if (!is_null($docId) && !is_string($docId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docId, true), gettype($docId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($docId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $docId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($docId, true)), __LINE__);
        }
        $this->docId = $docId;
        return $this;
    }
    /**
     * Get ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->ticket;
    }
    /**
     * Set ticket value
     * @param string $ticket
     * @return \LendingQB\StructType\LendingQBDownloadDocumentNonPdfBytesById
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->ticket = $ticket;
        return $this;
    }
}
