<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteEdocs StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBDeleteEdocs extends AbstractStructBase
{
    /**
     * The authTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authTicket;
    /**
     * The edocLoXml
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $edocLoXml;
    /**
     * Constructor method for DeleteEdocs
     * @uses LendingQBDeleteEdocs::setAuthTicket()
     * @uses LendingQBDeleteEdocs::setEdocLoXml()
     * @param string $authTicket
     * @param string $edocLoXml
     */
    public function __construct($authTicket = null, $edocLoXml = null)
    {
        $this
            ->setAuthTicket($authTicket)
            ->setEdocLoXml($edocLoXml);
    }
    /**
     * Get authTicket value
     * @return string|null
     */
    public function getAuthTicket()
    {
        return $this->authTicket;
    }
    /**
     * Set authTicket value
     * @param string $authTicket
     * @return \LendingQB\StructType\LendingQBDeleteEdocs
     */
    public function setAuthTicket($authTicket = null)
    {
        // validation for constraint: string
        if (!is_null($authTicket) && !is_string($authTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTicket, true), gettype($authTicket)), __LINE__);
        }
        $this->authTicket = $authTicket;
        return $this;
    }
    /**
     * Get edocLoXml value
     * @return string|null
     */
    public function getEdocLoXml()
    {
        return $this->edocLoXml;
    }
    /**
     * Set edocLoXml value
     * @param string $edocLoXml
     * @return \LendingQB\StructType\LendingQBDeleteEdocs
     */
    public function setEdocLoXml($edocLoXml = null)
    {
        // validation for constraint: string
        if (!is_null($edocLoXml) && !is_string($edocLoXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($edocLoXml, true), gettype($edocLoXml)), __LINE__);
        }
        $this->edocLoXml = $edocLoXml;
        return $this;
    }
}
