<?php

namespace LendingQB\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TypeOfService EnumType
 * @package LendingQB
 * @subpackage Enumerations
 */
class LendingQBTypeOfService extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Multiple'
     * @return string 'Multiple'
     */
    const VALUE_MULTIPLE = 'Multiple';
    /**
     * Constant for value 'Appraisal'
     * @return string 'Appraisal'
     */
    const VALUE_APPRAISAL = 'Appraisal';
    /**
     * Constant for value 'AVM'
     * @return string 'AVM'
     */
    const VALUE_AVM = 'AVM';
    /**
     * Constant for value 'Compliance'
     * @return string 'Compliance'
     */
    const VALUE_COMPLIANCE = 'Compliance';
    /**
     * Constant for value 'Credit'
     * @return string 'Credit'
     */
    const VALUE_CREDIT = 'Credit';
    /**
     * Constant for value 'Business Credit Report'
     * @return string 'Business Credit Report'
     */
    const VALUE_BUSINESS_CREDIT_REPORT = 'Business Credit Report';
    /**
     * Constant for value 'Credit Analyzer'
     * @return string 'Credit Analyzer'
     */
    const VALUE_CREDIT_ANALYZER = 'Credit Analyzer';
    /**
     * Constant for value 'Credit Assure'
     * @return string 'Credit Assure'
     */
    const VALUE_CREDIT_ASSURE = 'Credit Assure';
    /**
     * Constant for value 'Credit Supplements'
     * @return string 'Credit Supplements'
     */
    const VALUE_CREDIT_SUPPLEMENTS = 'Credit Supplements';
    /**
     * Constant for value 'Criminal Record Reports'
     * @return string 'Criminal Record Reports'
     */
    const VALUE_CRIMINAL_RECORD_REPORTS = 'Criminal Record Reports';
    /**
     * Constant for value 'Eviction Reports'
     * @return string 'Eviction Reports'
     */
    const VALUE_EVICTION_REPORTS = 'Eviction Reports';
    /**
     * Constant for value 'Flood'
     * @return string 'Flood'
     */
    const VALUE_FLOOD = 'Flood';
    /**
     * Constant for value 'Fraud'
     * @return string 'Fraud'
     */
    const VALUE_FRAUD = 'Fraud';
    /**
     * Constant for value 'HMDA'
     * @return string 'HMDA'
     */
    const VALUE_HMDA = 'HMDA';
    /**
     * Constant for value 'LDP and GSA Reports'
     * @return string 'LDP and GSA Reports'
     */
    const VALUE_LDP_AND_GSA_REPORTS = 'LDP and GSA Reports';
    /**
     * Constant for value 'MERS Report'
     * @return string 'MERS Report'
     */
    const VALUE_MERS_REPORT = 'MERS Report';
    /**
     * Constant for value 'Mortgage Insurance'
     * @return string 'Mortgage Insurance'
     */
    const VALUE_MORTGAGE_INSURANCE = 'Mortgage Insurance';
    /**
     * Constant for value 'Mortgage Participants Report'
     * @return string 'Mortgage Participants Report'
     */
    const VALUE_MORTGAGE_PARTICIPANTS_REPORT = 'Mortgage Participants Report';
    /**
     * Constant for value 'SSA-89'
     * @return string 'SSA-89'
     */
    const VALUE_SSA_89 = 'SSA-89';
    /**
     * Constant for value 'Title'
     * @return string 'Title'
     */
    const VALUE_TITLE = 'Title';
    /**
     * Constant for value 'Verification Of Deposits (assets)'
     * @return string 'Verification Of Deposits (assets)'
     */
    const VALUE_VERIFICATION_OF_DEPOSITS_ASSETS = 'Verification Of Deposits (assets)';
    /**
     * Constant for value 'Verification Of Employment'
     * @return string 'Verification Of Employment'
     */
    const VALUE_VERIFICATION_OF_EMPLOYMENT = 'Verification Of Employment';
    /**
     * Constant for value 'Tax Return Verification (4506-T)'
     * @return string 'Tax Return Verification (4506-T)'
     */
    const VALUE_TAX_RETURN_VERIFICATION_4506_T = 'Tax Return Verification (4506-T)';
    /**
     * Constant for value 'Trailing Docs'
     * @return string 'Trailing Docs'
     */
    const VALUE_TRAILING_DOCS = 'Trailing Docs';
    /**
     * Constant for value 'Undisclosed Debt Notification'
     * @return string 'Undisclosed Debt Notification'
     */
    const VALUE_UNDISCLOSED_DEBT_NOTIFICATION = 'Undisclosed Debt Notification';
    /**
     * Constant for value 'USPS Check'
     * @return string 'USPS Check'
     */
    const VALUE_USPS_CHECK = 'USPS Check';
    /**
     * Constant for value 'What If Simulator'
     * @return string 'What If Simulator'
     */
    const VALUE_WHAT_IF_SIMULATOR = 'What If Simulator';
    /**
     * Constant for value 'Optical Character Recognition'
     * @return string 'Optical Character Recognition'
     */
    const VALUE_OPTICAL_CHARACTER_RECOGNITION = 'Optical Character Recognition';
    /**
     * Constant for value 'Income Analyzer'
     * @return string 'Income Analyzer'
     */
    const VALUE_INCOME_ANALYZER = 'Income Analyzer';
    /**
     * Constant for value 'Homeowner Insurance'
     * @return string 'Homeowner Insurance'
     */
    const VALUE_HOMEOWNER_INSURANCE = 'Homeowner Insurance';
    /**
     * Return allowed values
     * @uses self::VALUE_MULTIPLE
     * @uses self::VALUE_APPRAISAL
     * @uses self::VALUE_AVM
     * @uses self::VALUE_COMPLIANCE
     * @uses self::VALUE_CREDIT
     * @uses self::VALUE_BUSINESS_CREDIT_REPORT
     * @uses self::VALUE_CREDIT_ANALYZER
     * @uses self::VALUE_CREDIT_ASSURE
     * @uses self::VALUE_CREDIT_SUPPLEMENTS
     * @uses self::VALUE_CRIMINAL_RECORD_REPORTS
     * @uses self::VALUE_EVICTION_REPORTS
     * @uses self::VALUE_FLOOD
     * @uses self::VALUE_FRAUD
     * @uses self::VALUE_HMDA
     * @uses self::VALUE_LDP_AND_GSA_REPORTS
     * @uses self::VALUE_MERS_REPORT
     * @uses self::VALUE_MORTGAGE_INSURANCE
     * @uses self::VALUE_MORTGAGE_PARTICIPANTS_REPORT
     * @uses self::VALUE_SSA_89
     * @uses self::VALUE_TITLE
     * @uses self::VALUE_VERIFICATION_OF_DEPOSITS_ASSETS
     * @uses self::VALUE_VERIFICATION_OF_EMPLOYMENT
     * @uses self::VALUE_TAX_RETURN_VERIFICATION_4506_T
     * @uses self::VALUE_TRAILING_DOCS
     * @uses self::VALUE_UNDISCLOSED_DEBT_NOTIFICATION
     * @uses self::VALUE_USPS_CHECK
     * @uses self::VALUE_WHAT_IF_SIMULATOR
     * @uses self::VALUE_OPTICAL_CHARACTER_RECOGNITION
     * @uses self::VALUE_INCOME_ANALYZER
     * @uses self::VALUE_HOMEOWNER_INSURANCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MULTIPLE,
            self::VALUE_APPRAISAL,
            self::VALUE_AVM,
            self::VALUE_COMPLIANCE,
            self::VALUE_CREDIT,
            self::VALUE_BUSINESS_CREDIT_REPORT,
            self::VALUE_CREDIT_ANALYZER,
            self::VALUE_CREDIT_ASSURE,
            self::VALUE_CREDIT_SUPPLEMENTS,
            self::VALUE_CRIMINAL_RECORD_REPORTS,
            self::VALUE_EVICTION_REPORTS,
            self::VALUE_FLOOD,
            self::VALUE_FRAUD,
            self::VALUE_HMDA,
            self::VALUE_LDP_AND_GSA_REPORTS,
            self::VALUE_MERS_REPORT,
            self::VALUE_MORTGAGE_INSURANCE,
            self::VALUE_MORTGAGE_PARTICIPANTS_REPORT,
            self::VALUE_SSA_89,
            self::VALUE_TITLE,
            self::VALUE_VERIFICATION_OF_DEPOSITS_ASSETS,
            self::VALUE_VERIFICATION_OF_EMPLOYMENT,
            self::VALUE_TAX_RETURN_VERIFICATION_4506_T,
            self::VALUE_TRAILING_DOCS,
            self::VALUE_UNDISCLOSED_DEBT_NOTIFICATION,
            self::VALUE_USPS_CHECK,
            self::VALUE_WHAT_IF_SIMULATOR,
            self::VALUE_OPTICAL_CHARACTER_RECOGNITION,
            self::VALUE_INCOME_ANALYZER,
            self::VALUE_HOMEOWNER_INSURANCE,
        );
    }
}
