<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://portal.protecdentalonline.com/API/DLCPMAPIServer.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://portal.protecdentalonline.com/API/DLCPMAPIServer.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \protec\ClassMap::get(),
);
/**
 * Samples for Add ServiceType
 */
$add = new \protec\ServiceType\Add($options);
/**
 * Sample call for AddCase operation/method
 */
if ($add->AddCase(new \protec\StructType\AddCase()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddCaseDocument operation/method
 */
if ($add->AddCaseDocument(new \protec\StructType\AddCaseDocument()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddCallNote operation/method
 */
if ($add->AddCallNote(new \protec\StructType\AddCallNote()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddCaseLog operation/method
 */
if ($add->AddCaseLog(new \protec\StructType\AddCaseLog()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \protec\ServiceType\Modify($options);
/**
 * Sample call for ModifyCase operation/method
 */
if ($modify->ModifyCase(new \protec\StructType\ModifyCase()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \protec\ServiceType\Delete($options);
/**
 * Sample call for DeleteCase operation/method
 */
if ($delete->DeleteCase(new \protec\StructType\DeleteCase()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteCaseDocument operation/method
 */
if ($delete->DeleteCaseDocument(new \protec\StructType\DeleteCaseDocument()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Submit ServiceType
 */
$submit = new \protec\ServiceType\Submit($options);
/**
 * Sample call for SubmitCustomer operation/method
 */
if ($submit->SubmitCustomer(new \protec\StructType\SubmitCustomer()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitPracticeDoctor operation/method
 */
if ($submit->SubmitPracticeDoctor(new \protec\StructType\SubmitPracticeDoctor()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Samples for Query ServiceType
 */
$query = new \protec\ServiceType\Query($options);
/**
 * Sample call for QueryCustomer operation/method
 */
if ($query->QueryCustomer(new \protec\StructType\QueryCustomer()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Samples for Noop ServiceType
 */
$noop = new \protec\ServiceType\Noop($options);
/**
 * Sample call for Noop1 operation/method
 */
if ($noop->Noop1(new \protec\StructType\Noop1()) !== false) {
    print_r($noop->getResult());
} else {
    print_r($noop->getLastError());
}
/**
 * Sample call for Noop2 operation/method
 */
if ($noop->Noop2(new \protec\StructType\Noop2()) !== false) {
    print_r($noop->getResult());
} else {
    print_r($noop->getLastError());
}
/**
 * Sample call for Noop3 operation/method
 */
if ($noop->Noop3(new \protec\StructType\Noop3()) !== false) {
    print_r($noop->getResult());
} else {
    print_r($noop->getLastError());
}
/**
 * Samples for Test ServiceType
 */
$test = new \protec\ServiceType\Test($options);
/**
 * Sample call for Test operation/method
 */
if ($test->Test(new \protec\StructType\Test()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
