<?php

namespace protec\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Test StructType
 * @subpackage Structs
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class Test extends AbstractStructBase
{
    /**
     * The lab
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lab;
    /**
     * Constructor method for Test
     * @uses Test::setLab()
     * @param string $lab
     */
    public function __construct($lab = null)
    {
        $this
            ->setLab($lab);
    }
    /**
     * Get lab value
     * @return string|null
     */
    public function getLab()
    {
        return $this->lab;
    }
    /**
     * Set lab value
     * @param string $lab
     * @return \protec\StructType\Test
     */
    public function setLab($lab = null)
    {
        // validation for constraint: string
        if (!is_null($lab) && !is_string($lab)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lab, true), gettype($lab)), __LINE__);
        }
        $this->lab = $lab;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \protec\StructType\Test
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
