<?php

namespace protec\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DLCPMModifyCase StructType
 * @subpackage Structs
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class DLCPMModifyCase extends AbstractStructBase
{
    /**
     * The ShipDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ShipDate;
    /**
     * The DateIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateIn;
    /**
     * The DueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DueDate;
    /**
     * The RemoteCaseNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RemoteCaseNumber;
    /**
     * The OverrideProducts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OverrideProducts;
    /**
     * The ModifyPatientFirst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyPatientFirst;
    /**
     * The ModifyPatientLast
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyPatientLast;
    /**
     * The ModifyLabName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyLabName;
    /**
     * The ModifyShade
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyShade;
    /**
     * The ModifyRxNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyRxNumber;
    /**
     * The ModifyShipDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyShipDate;
    /**
     * The ModifyDateIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyDateIn;
    /**
     * The ModifyDueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyDueDate;
    /**
     * The ModifyDoctorName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyDoctorName;
    /**
     * The ModifyPracticeDoctorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyPracticeDoctorID;
    /**
     * The ModifyPanNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyPanNumber;
    /**
     * The ModifyCarrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyCarrier;
    /**
     * The ModifyCarrierServiceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyCarrierServiceType;
    /**
     * The ModifyWebComments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyWebComments;
    /**
     * The ModifyWorkorderNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyWorkorderNotes;
    /**
     * The ModifyRemakeCaseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyRemakeCaseID;
    /**
     * The ModifyLinkedToCaseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyLinkedToCaseID;
    /**
     * The ModifyRemoteCaseNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyRemoteCaseNumber;
    /**
     * The ModifyDeliveryNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyDeliveryNotes;
    /**
     * The ModifyShipCustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyShipCustomerID;
    /**
     * The ModifyRXPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ModifyRXPreferences;
    /**
     * The CaseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CaseID;
    /**
     * The PatientFirst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PatientFirst;
    /**
     * The PatientLast
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PatientLast;
    /**
     * The LabName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LabName;
    /**
     * The Shade
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shade;
    /**
     * The RxNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RxNumber;
    /**
     * The DoctorName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DoctorName;
    /**
     * The PracticeDoctorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PracticeDoctorID;
    /**
     * The PanNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PanNumber;
    /**
     * The Carrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Carrier;
    /**
     * The CarrierServiceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierServiceType;
    /**
     * The WebComments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebComments;
    /**
     * The WorkorderNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkorderNotes;
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \protec\ArrayType\ArrayOfDLCPMCaseProduct
     */
    public $Products;
    /**
     * The RemakeCaseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RemakeCaseID;
    /**
     * The LinkedToCaseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LinkedToCaseID;
    /**
     * The DeliveryNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryNotes;
    /**
     * The ShipCustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipCustomerID;
    /**
     * The RxPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RxPreferences;
    /**
     * Constructor method for DLCPMModifyCase
     * @uses DLCPMModifyCase::setShipDate()
     * @uses DLCPMModifyCase::setDateIn()
     * @uses DLCPMModifyCase::setDueDate()
     * @uses DLCPMModifyCase::setRemoteCaseNumber()
     * @uses DLCPMModifyCase::setOverrideProducts()
     * @uses DLCPMModifyCase::setModifyPatientFirst()
     * @uses DLCPMModifyCase::setModifyPatientLast()
     * @uses DLCPMModifyCase::setModifyLabName()
     * @uses DLCPMModifyCase::setModifyShade()
     * @uses DLCPMModifyCase::setModifyRxNumber()
     * @uses DLCPMModifyCase::setModifyShipDate()
     * @uses DLCPMModifyCase::setModifyDateIn()
     * @uses DLCPMModifyCase::setModifyDueDate()
     * @uses DLCPMModifyCase::setModifyDoctorName()
     * @uses DLCPMModifyCase::setModifyPracticeDoctorID()
     * @uses DLCPMModifyCase::setModifyPanNumber()
     * @uses DLCPMModifyCase::setModifyCarrier()
     * @uses DLCPMModifyCase::setModifyCarrierServiceType()
     * @uses DLCPMModifyCase::setModifyWebComments()
     * @uses DLCPMModifyCase::setModifyWorkorderNotes()
     * @uses DLCPMModifyCase::setModifyRemakeCaseID()
     * @uses DLCPMModifyCase::setModifyLinkedToCaseID()
     * @uses DLCPMModifyCase::setModifyRemoteCaseNumber()
     * @uses DLCPMModifyCase::setModifyDeliveryNotes()
     * @uses DLCPMModifyCase::setModifyShipCustomerID()
     * @uses DLCPMModifyCase::setModifyRXPreferences()
     * @uses DLCPMModifyCase::setCaseID()
     * @uses DLCPMModifyCase::setPatientFirst()
     * @uses DLCPMModifyCase::setPatientLast()
     * @uses DLCPMModifyCase::setLabName()
     * @uses DLCPMModifyCase::setShade()
     * @uses DLCPMModifyCase::setRxNumber()
     * @uses DLCPMModifyCase::setDoctorName()
     * @uses DLCPMModifyCase::setPracticeDoctorID()
     * @uses DLCPMModifyCase::setPanNumber()
     * @uses DLCPMModifyCase::setCarrier()
     * @uses DLCPMModifyCase::setCarrierServiceType()
     * @uses DLCPMModifyCase::setWebComments()
     * @uses DLCPMModifyCase::setWorkorderNotes()
     * @uses DLCPMModifyCase::setProducts()
     * @uses DLCPMModifyCase::setRemakeCaseID()
     * @uses DLCPMModifyCase::setLinkedToCaseID()
     * @uses DLCPMModifyCase::setDeliveryNotes()
     * @uses DLCPMModifyCase::setShipCustomerID()
     * @uses DLCPMModifyCase::setRxPreferences()
     * @param string $shipDate
     * @param string $dateIn
     * @param string $dueDate
     * @param int $remoteCaseNumber
     * @param bool $overrideProducts
     * @param bool $modifyPatientFirst
     * @param bool $modifyPatientLast
     * @param bool $modifyLabName
     * @param bool $modifyShade
     * @param bool $modifyRxNumber
     * @param bool $modifyShipDate
     * @param bool $modifyDateIn
     * @param bool $modifyDueDate
     * @param bool $modifyDoctorName
     * @param bool $modifyPracticeDoctorID
     * @param bool $modifyPanNumber
     * @param bool $modifyCarrier
     * @param bool $modifyCarrierServiceType
     * @param bool $modifyWebComments
     * @param bool $modifyWorkorderNotes
     * @param bool $modifyRemakeCaseID
     * @param bool $modifyLinkedToCaseID
     * @param bool $modifyRemoteCaseNumber
     * @param bool $modifyDeliveryNotes
     * @param bool $modifyShipCustomerID
     * @param bool $modifyRXPreferences
     * @param string $caseID
     * @param string $patientFirst
     * @param string $patientLast
     * @param string $labName
     * @param string $shade
     * @param string $rxNumber
     * @param string $doctorName
     * @param string $practiceDoctorID
     * @param string $panNumber
     * @param string $carrier
     * @param string $carrierServiceType
     * @param string $webComments
     * @param string $workorderNotes
     * @param \protec\ArrayType\ArrayOfDLCPMCaseProduct $products
     * @param string $remakeCaseID
     * @param string $linkedToCaseID
     * @param string $deliveryNotes
     * @param string $shipCustomerID
     * @param string $rxPreferences
     */
    public function __construct($shipDate = null, $dateIn = null, $dueDate = null, $remoteCaseNumber = null, $overrideProducts = null, $modifyPatientFirst = null, $modifyPatientLast = null, $modifyLabName = null, $modifyShade = null, $modifyRxNumber = null, $modifyShipDate = null, $modifyDateIn = null, $modifyDueDate = null, $modifyDoctorName = null, $modifyPracticeDoctorID = null, $modifyPanNumber = null, $modifyCarrier = null, $modifyCarrierServiceType = null, $modifyWebComments = null, $modifyWorkorderNotes = null, $modifyRemakeCaseID = null, $modifyLinkedToCaseID = null, $modifyRemoteCaseNumber = null, $modifyDeliveryNotes = null, $modifyShipCustomerID = null, $modifyRXPreferences = null, $caseID = null, $patientFirst = null, $patientLast = null, $labName = null, $shade = null, $rxNumber = null, $doctorName = null, $practiceDoctorID = null, $panNumber = null, $carrier = null, $carrierServiceType = null, $webComments = null, $workorderNotes = null, \protec\ArrayType\ArrayOfDLCPMCaseProduct $products = null, $remakeCaseID = null, $linkedToCaseID = null, $deliveryNotes = null, $shipCustomerID = null, $rxPreferences = null)
    {
        $this
            ->setShipDate($shipDate)
            ->setDateIn($dateIn)
            ->setDueDate($dueDate)
            ->setRemoteCaseNumber($remoteCaseNumber)
            ->setOverrideProducts($overrideProducts)
            ->setModifyPatientFirst($modifyPatientFirst)
            ->setModifyPatientLast($modifyPatientLast)
            ->setModifyLabName($modifyLabName)
            ->setModifyShade($modifyShade)
            ->setModifyRxNumber($modifyRxNumber)
            ->setModifyShipDate($modifyShipDate)
            ->setModifyDateIn($modifyDateIn)
            ->setModifyDueDate($modifyDueDate)
            ->setModifyDoctorName($modifyDoctorName)
            ->setModifyPracticeDoctorID($modifyPracticeDoctorID)
            ->setModifyPanNumber($modifyPanNumber)
            ->setModifyCarrier($modifyCarrier)
            ->setModifyCarrierServiceType($modifyCarrierServiceType)
            ->setModifyWebComments($modifyWebComments)
            ->setModifyWorkorderNotes($modifyWorkorderNotes)
            ->setModifyRemakeCaseID($modifyRemakeCaseID)
            ->setModifyLinkedToCaseID($modifyLinkedToCaseID)
            ->setModifyRemoteCaseNumber($modifyRemoteCaseNumber)
            ->setModifyDeliveryNotes($modifyDeliveryNotes)
            ->setModifyShipCustomerID($modifyShipCustomerID)
            ->setModifyRXPreferences($modifyRXPreferences)
            ->setCaseID($caseID)
            ->setPatientFirst($patientFirst)
            ->setPatientLast($patientLast)
            ->setLabName($labName)
            ->setShade($shade)
            ->setRxNumber($rxNumber)
            ->setDoctorName($doctorName)
            ->setPracticeDoctorID($practiceDoctorID)
            ->setPanNumber($panNumber)
            ->setCarrier($carrier)
            ->setCarrierServiceType($carrierServiceType)
            ->setWebComments($webComments)
            ->setWorkorderNotes($workorderNotes)
            ->setProducts($products)
            ->setRemakeCaseID($remakeCaseID)
            ->setLinkedToCaseID($linkedToCaseID)
            ->setDeliveryNotes($deliveryNotes)
            ->setShipCustomerID($shipCustomerID)
            ->setRxPreferences($rxPreferences);
    }
    /**
     * Get ShipDate value
     * @return string
     */
    public function getShipDate()
    {
        return $this->ShipDate;
    }
    /**
     * Set ShipDate value
     * @param string $shipDate
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setShipDate($shipDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipDate) && !is_string($shipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDate, true), gettype($shipDate)), __LINE__);
        }
        $this->ShipDate = $shipDate;
        return $this;
    }
    /**
     * Get DateIn value
     * @return string
     */
    public function getDateIn()
    {
        return $this->DateIn;
    }
    /**
     * Set DateIn value
     * @param string $dateIn
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setDateIn($dateIn = null)
    {
        // validation for constraint: string
        if (!is_null($dateIn) && !is_string($dateIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateIn, true), gettype($dateIn)), __LINE__);
        }
        $this->DateIn = $dateIn;
        return $this;
    }
    /**
     * Get DueDate value
     * @return string
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get RemoteCaseNumber value
     * @return int
     */
    public function getRemoteCaseNumber()
    {
        return $this->RemoteCaseNumber;
    }
    /**
     * Set RemoteCaseNumber value
     * @param int $remoteCaseNumber
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setRemoteCaseNumber($remoteCaseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($remoteCaseNumber) && !(is_int($remoteCaseNumber) || ctype_digit($remoteCaseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($remoteCaseNumber, true), gettype($remoteCaseNumber)), __LINE__);
        }
        $this->RemoteCaseNumber = $remoteCaseNumber;
        return $this;
    }
    /**
     * Get OverrideProducts value
     * @return bool
     */
    public function getOverrideProducts()
    {
        return $this->OverrideProducts;
    }
    /**
     * Set OverrideProducts value
     * @param bool $overrideProducts
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setOverrideProducts($overrideProducts = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideProducts) && !is_bool($overrideProducts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideProducts, true), gettype($overrideProducts)), __LINE__);
        }
        $this->OverrideProducts = $overrideProducts;
        return $this;
    }
    /**
     * Get ModifyPatientFirst value
     * @return bool
     */
    public function getModifyPatientFirst()
    {
        return $this->ModifyPatientFirst;
    }
    /**
     * Set ModifyPatientFirst value
     * @param bool $modifyPatientFirst
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyPatientFirst($modifyPatientFirst = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyPatientFirst) && !is_bool($modifyPatientFirst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyPatientFirst, true), gettype($modifyPatientFirst)), __LINE__);
        }
        $this->ModifyPatientFirst = $modifyPatientFirst;
        return $this;
    }
    /**
     * Get ModifyPatientLast value
     * @return bool
     */
    public function getModifyPatientLast()
    {
        return $this->ModifyPatientLast;
    }
    /**
     * Set ModifyPatientLast value
     * @param bool $modifyPatientLast
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyPatientLast($modifyPatientLast = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyPatientLast) && !is_bool($modifyPatientLast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyPatientLast, true), gettype($modifyPatientLast)), __LINE__);
        }
        $this->ModifyPatientLast = $modifyPatientLast;
        return $this;
    }
    /**
     * Get ModifyLabName value
     * @return bool
     */
    public function getModifyLabName()
    {
        return $this->ModifyLabName;
    }
    /**
     * Set ModifyLabName value
     * @param bool $modifyLabName
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyLabName($modifyLabName = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyLabName) && !is_bool($modifyLabName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyLabName, true), gettype($modifyLabName)), __LINE__);
        }
        $this->ModifyLabName = $modifyLabName;
        return $this;
    }
    /**
     * Get ModifyShade value
     * @return bool
     */
    public function getModifyShade()
    {
        return $this->ModifyShade;
    }
    /**
     * Set ModifyShade value
     * @param bool $modifyShade
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyShade($modifyShade = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyShade) && !is_bool($modifyShade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyShade, true), gettype($modifyShade)), __LINE__);
        }
        $this->ModifyShade = $modifyShade;
        return $this;
    }
    /**
     * Get ModifyRxNumber value
     * @return bool
     */
    public function getModifyRxNumber()
    {
        return $this->ModifyRxNumber;
    }
    /**
     * Set ModifyRxNumber value
     * @param bool $modifyRxNumber
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyRxNumber($modifyRxNumber = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyRxNumber) && !is_bool($modifyRxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyRxNumber, true), gettype($modifyRxNumber)), __LINE__);
        }
        $this->ModifyRxNumber = $modifyRxNumber;
        return $this;
    }
    /**
     * Get ModifyShipDate value
     * @return bool
     */
    public function getModifyShipDate()
    {
        return $this->ModifyShipDate;
    }
    /**
     * Set ModifyShipDate value
     * @param bool $modifyShipDate
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyShipDate($modifyShipDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyShipDate) && !is_bool($modifyShipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyShipDate, true), gettype($modifyShipDate)), __LINE__);
        }
        $this->ModifyShipDate = $modifyShipDate;
        return $this;
    }
    /**
     * Get ModifyDateIn value
     * @return bool
     */
    public function getModifyDateIn()
    {
        return $this->ModifyDateIn;
    }
    /**
     * Set ModifyDateIn value
     * @param bool $modifyDateIn
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyDateIn($modifyDateIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyDateIn) && !is_bool($modifyDateIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyDateIn, true), gettype($modifyDateIn)), __LINE__);
        }
        $this->ModifyDateIn = $modifyDateIn;
        return $this;
    }
    /**
     * Get ModifyDueDate value
     * @return bool
     */
    public function getModifyDueDate()
    {
        return $this->ModifyDueDate;
    }
    /**
     * Set ModifyDueDate value
     * @param bool $modifyDueDate
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyDueDate($modifyDueDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyDueDate) && !is_bool($modifyDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyDueDate, true), gettype($modifyDueDate)), __LINE__);
        }
        $this->ModifyDueDate = $modifyDueDate;
        return $this;
    }
    /**
     * Get ModifyDoctorName value
     * @return bool
     */
    public function getModifyDoctorName()
    {
        return $this->ModifyDoctorName;
    }
    /**
     * Set ModifyDoctorName value
     * @param bool $modifyDoctorName
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyDoctorName($modifyDoctorName = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyDoctorName) && !is_bool($modifyDoctorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyDoctorName, true), gettype($modifyDoctorName)), __LINE__);
        }
        $this->ModifyDoctorName = $modifyDoctorName;
        return $this;
    }
    /**
     * Get ModifyPracticeDoctorID value
     * @return bool
     */
    public function getModifyPracticeDoctorID()
    {
        return $this->ModifyPracticeDoctorID;
    }
    /**
     * Set ModifyPracticeDoctorID value
     * @param bool $modifyPracticeDoctorID
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyPracticeDoctorID($modifyPracticeDoctorID = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyPracticeDoctorID) && !is_bool($modifyPracticeDoctorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyPracticeDoctorID, true), gettype($modifyPracticeDoctorID)), __LINE__);
        }
        $this->ModifyPracticeDoctorID = $modifyPracticeDoctorID;
        return $this;
    }
    /**
     * Get ModifyPanNumber value
     * @return bool
     */
    public function getModifyPanNumber()
    {
        return $this->ModifyPanNumber;
    }
    /**
     * Set ModifyPanNumber value
     * @param bool $modifyPanNumber
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyPanNumber($modifyPanNumber = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyPanNumber) && !is_bool($modifyPanNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyPanNumber, true), gettype($modifyPanNumber)), __LINE__);
        }
        $this->ModifyPanNumber = $modifyPanNumber;
        return $this;
    }
    /**
     * Get ModifyCarrier value
     * @return bool
     */
    public function getModifyCarrier()
    {
        return $this->ModifyCarrier;
    }
    /**
     * Set ModifyCarrier value
     * @param bool $modifyCarrier
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyCarrier($modifyCarrier = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyCarrier) && !is_bool($modifyCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyCarrier, true), gettype($modifyCarrier)), __LINE__);
        }
        $this->ModifyCarrier = $modifyCarrier;
        return $this;
    }
    /**
     * Get ModifyCarrierServiceType value
     * @return bool
     */
    public function getModifyCarrierServiceType()
    {
        return $this->ModifyCarrierServiceType;
    }
    /**
     * Set ModifyCarrierServiceType value
     * @param bool $modifyCarrierServiceType
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyCarrierServiceType($modifyCarrierServiceType = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyCarrierServiceType) && !is_bool($modifyCarrierServiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyCarrierServiceType, true), gettype($modifyCarrierServiceType)), __LINE__);
        }
        $this->ModifyCarrierServiceType = $modifyCarrierServiceType;
        return $this;
    }
    /**
     * Get ModifyWebComments value
     * @return bool
     */
    public function getModifyWebComments()
    {
        return $this->ModifyWebComments;
    }
    /**
     * Set ModifyWebComments value
     * @param bool $modifyWebComments
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyWebComments($modifyWebComments = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyWebComments) && !is_bool($modifyWebComments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyWebComments, true), gettype($modifyWebComments)), __LINE__);
        }
        $this->ModifyWebComments = $modifyWebComments;
        return $this;
    }
    /**
     * Get ModifyWorkorderNotes value
     * @return bool
     */
    public function getModifyWorkorderNotes()
    {
        return $this->ModifyWorkorderNotes;
    }
    /**
     * Set ModifyWorkorderNotes value
     * @param bool $modifyWorkorderNotes
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyWorkorderNotes($modifyWorkorderNotes = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyWorkorderNotes) && !is_bool($modifyWorkorderNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyWorkorderNotes, true), gettype($modifyWorkorderNotes)), __LINE__);
        }
        $this->ModifyWorkorderNotes = $modifyWorkorderNotes;
        return $this;
    }
    /**
     * Get ModifyRemakeCaseID value
     * @return bool
     */
    public function getModifyRemakeCaseID()
    {
        return $this->ModifyRemakeCaseID;
    }
    /**
     * Set ModifyRemakeCaseID value
     * @param bool $modifyRemakeCaseID
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyRemakeCaseID($modifyRemakeCaseID = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyRemakeCaseID) && !is_bool($modifyRemakeCaseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyRemakeCaseID, true), gettype($modifyRemakeCaseID)), __LINE__);
        }
        $this->ModifyRemakeCaseID = $modifyRemakeCaseID;
        return $this;
    }
    /**
     * Get ModifyLinkedToCaseID value
     * @return bool
     */
    public function getModifyLinkedToCaseID()
    {
        return $this->ModifyLinkedToCaseID;
    }
    /**
     * Set ModifyLinkedToCaseID value
     * @param bool $modifyLinkedToCaseID
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyLinkedToCaseID($modifyLinkedToCaseID = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyLinkedToCaseID) && !is_bool($modifyLinkedToCaseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyLinkedToCaseID, true), gettype($modifyLinkedToCaseID)), __LINE__);
        }
        $this->ModifyLinkedToCaseID = $modifyLinkedToCaseID;
        return $this;
    }
    /**
     * Get ModifyRemoteCaseNumber value
     * @return bool
     */
    public function getModifyRemoteCaseNumber()
    {
        return $this->ModifyRemoteCaseNumber;
    }
    /**
     * Set ModifyRemoteCaseNumber value
     * @param bool $modifyRemoteCaseNumber
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyRemoteCaseNumber($modifyRemoteCaseNumber = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyRemoteCaseNumber) && !is_bool($modifyRemoteCaseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyRemoteCaseNumber, true), gettype($modifyRemoteCaseNumber)), __LINE__);
        }
        $this->ModifyRemoteCaseNumber = $modifyRemoteCaseNumber;
        return $this;
    }
    /**
     * Get ModifyDeliveryNotes value
     * @return bool
     */
    public function getModifyDeliveryNotes()
    {
        return $this->ModifyDeliveryNotes;
    }
    /**
     * Set ModifyDeliveryNotes value
     * @param bool $modifyDeliveryNotes
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyDeliveryNotes($modifyDeliveryNotes = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyDeliveryNotes) && !is_bool($modifyDeliveryNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyDeliveryNotes, true), gettype($modifyDeliveryNotes)), __LINE__);
        }
        $this->ModifyDeliveryNotes = $modifyDeliveryNotes;
        return $this;
    }
    /**
     * Get ModifyShipCustomerID value
     * @return bool
     */
    public function getModifyShipCustomerID()
    {
        return $this->ModifyShipCustomerID;
    }
    /**
     * Set ModifyShipCustomerID value
     * @param bool $modifyShipCustomerID
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyShipCustomerID($modifyShipCustomerID = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyShipCustomerID) && !is_bool($modifyShipCustomerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyShipCustomerID, true), gettype($modifyShipCustomerID)), __LINE__);
        }
        $this->ModifyShipCustomerID = $modifyShipCustomerID;
        return $this;
    }
    /**
     * Get ModifyRXPreferences value
     * @return bool
     */
    public function getModifyRXPreferences()
    {
        return $this->ModifyRXPreferences;
    }
    /**
     * Set ModifyRXPreferences value
     * @param bool $modifyRXPreferences
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setModifyRXPreferences($modifyRXPreferences = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyRXPreferences) && !is_bool($modifyRXPreferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyRXPreferences, true), gettype($modifyRXPreferences)), __LINE__);
        }
        $this->ModifyRXPreferences = $modifyRXPreferences;
        return $this;
    }
    /**
     * Get CaseID value
     * @return string|null
     */
    public function getCaseID()
    {
        return $this->CaseID;
    }
    /**
     * Set CaseID value
     * @param string $caseID
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setCaseID($caseID = null)
    {
        // validation for constraint: string
        if (!is_null($caseID) && !is_string($caseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caseID, true), gettype($caseID)), __LINE__);
        }
        $this->CaseID = $caseID;
        return $this;
    }
    /**
     * Get PatientFirst value
     * @return string|null
     */
    public function getPatientFirst()
    {
        return $this->PatientFirst;
    }
    /**
     * Set PatientFirst value
     * @param string $patientFirst
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setPatientFirst($patientFirst = null)
    {
        // validation for constraint: string
        if (!is_null($patientFirst) && !is_string($patientFirst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patientFirst, true), gettype($patientFirst)), __LINE__);
        }
        $this->PatientFirst = $patientFirst;
        return $this;
    }
    /**
     * Get PatientLast value
     * @return string|null
     */
    public function getPatientLast()
    {
        return $this->PatientLast;
    }
    /**
     * Set PatientLast value
     * @param string $patientLast
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setPatientLast($patientLast = null)
    {
        // validation for constraint: string
        if (!is_null($patientLast) && !is_string($patientLast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patientLast, true), gettype($patientLast)), __LINE__);
        }
        $this->PatientLast = $patientLast;
        return $this;
    }
    /**
     * Get LabName value
     * @return string|null
     */
    public function getLabName()
    {
        return $this->LabName;
    }
    /**
     * Set LabName value
     * @param string $labName
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setLabName($labName = null)
    {
        // validation for constraint: string
        if (!is_null($labName) && !is_string($labName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labName, true), gettype($labName)), __LINE__);
        }
        $this->LabName = $labName;
        return $this;
    }
    /**
     * Get Shade value
     * @return string|null
     */
    public function getShade()
    {
        return $this->Shade;
    }
    /**
     * Set Shade value
     * @param string $shade
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setShade($shade = null)
    {
        // validation for constraint: string
        if (!is_null($shade) && !is_string($shade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shade, true), gettype($shade)), __LINE__);
        }
        $this->Shade = $shade;
        return $this;
    }
    /**
     * Get RxNumber value
     * @return string|null
     */
    public function getRxNumber()
    {
        return $this->RxNumber;
    }
    /**
     * Set RxNumber value
     * @param string $rxNumber
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setRxNumber($rxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($rxNumber) && !is_string($rxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rxNumber, true), gettype($rxNumber)), __LINE__);
        }
        $this->RxNumber = $rxNumber;
        return $this;
    }
    /**
     * Get DoctorName value
     * @return string|null
     */
    public function getDoctorName()
    {
        return $this->DoctorName;
    }
    /**
     * Set DoctorName value
     * @param string $doctorName
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setDoctorName($doctorName = null)
    {
        // validation for constraint: string
        if (!is_null($doctorName) && !is_string($doctorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doctorName, true), gettype($doctorName)), __LINE__);
        }
        $this->DoctorName = $doctorName;
        return $this;
    }
    /**
     * Get PracticeDoctorID value
     * @return string|null
     */
    public function getPracticeDoctorID()
    {
        return $this->PracticeDoctorID;
    }
    /**
     * Set PracticeDoctorID value
     * @param string $practiceDoctorID
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setPracticeDoctorID($practiceDoctorID = null)
    {
        // validation for constraint: string
        if (!is_null($practiceDoctorID) && !is_string($practiceDoctorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($practiceDoctorID, true), gettype($practiceDoctorID)), __LINE__);
        }
        $this->PracticeDoctorID = $practiceDoctorID;
        return $this;
    }
    /**
     * Get PanNumber value
     * @return string|null
     */
    public function getPanNumber()
    {
        return $this->PanNumber;
    }
    /**
     * Set PanNumber value
     * @param string $panNumber
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setPanNumber($panNumber = null)
    {
        // validation for constraint: string
        if (!is_null($panNumber) && !is_string($panNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($panNumber, true), gettype($panNumber)), __LINE__);
        }
        $this->PanNumber = $panNumber;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier, true), gettype($carrier)), __LINE__);
        }
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get CarrierServiceType value
     * @return string|null
     */
    public function getCarrierServiceType()
    {
        return $this->CarrierServiceType;
    }
    /**
     * Set CarrierServiceType value
     * @param string $carrierServiceType
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setCarrierServiceType($carrierServiceType = null)
    {
        // validation for constraint: string
        if (!is_null($carrierServiceType) && !is_string($carrierServiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierServiceType, true), gettype($carrierServiceType)), __LINE__);
        }
        $this->CarrierServiceType = $carrierServiceType;
        return $this;
    }
    /**
     * Get WebComments value
     * @return string|null
     */
    public function getWebComments()
    {
        return $this->WebComments;
    }
    /**
     * Set WebComments value
     * @param string $webComments
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setWebComments($webComments = null)
    {
        // validation for constraint: string
        if (!is_null($webComments) && !is_string($webComments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webComments, true), gettype($webComments)), __LINE__);
        }
        $this->WebComments = $webComments;
        return $this;
    }
    /**
     * Get WorkorderNotes value
     * @return string|null
     */
    public function getWorkorderNotes()
    {
        return $this->WorkorderNotes;
    }
    /**
     * Set WorkorderNotes value
     * @param string $workorderNotes
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setWorkorderNotes($workorderNotes = null)
    {
        // validation for constraint: string
        if (!is_null($workorderNotes) && !is_string($workorderNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workorderNotes, true), gettype($workorderNotes)), __LINE__);
        }
        $this->WorkorderNotes = $workorderNotes;
        return $this;
    }
    /**
     * Get Products value
     * @return \protec\ArrayType\ArrayOfDLCPMCaseProduct|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \protec\ArrayType\ArrayOfDLCPMCaseProduct $products
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setProducts(\protec\ArrayType\ArrayOfDLCPMCaseProduct $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get RemakeCaseID value
     * @return string|null
     */
    public function getRemakeCaseID()
    {
        return $this->RemakeCaseID;
    }
    /**
     * Set RemakeCaseID value
     * @param string $remakeCaseID
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setRemakeCaseID($remakeCaseID = null)
    {
        // validation for constraint: string
        if (!is_null($remakeCaseID) && !is_string($remakeCaseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remakeCaseID, true), gettype($remakeCaseID)), __LINE__);
        }
        $this->RemakeCaseID = $remakeCaseID;
        return $this;
    }
    /**
     * Get LinkedToCaseID value
     * @return string|null
     */
    public function getLinkedToCaseID()
    {
        return $this->LinkedToCaseID;
    }
    /**
     * Set LinkedToCaseID value
     * @param string $linkedToCaseID
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setLinkedToCaseID($linkedToCaseID = null)
    {
        // validation for constraint: string
        if (!is_null($linkedToCaseID) && !is_string($linkedToCaseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedToCaseID, true), gettype($linkedToCaseID)), __LINE__);
        }
        $this->LinkedToCaseID = $linkedToCaseID;
        return $this;
    }
    /**
     * Get DeliveryNotes value
     * @return string|null
     */
    public function getDeliveryNotes()
    {
        return $this->DeliveryNotes;
    }
    /**
     * Set DeliveryNotes value
     * @param string $deliveryNotes
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setDeliveryNotes($deliveryNotes = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNotes) && !is_string($deliveryNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryNotes, true), gettype($deliveryNotes)), __LINE__);
        }
        $this->DeliveryNotes = $deliveryNotes;
        return $this;
    }
    /**
     * Get ShipCustomerID value
     * @return string|null
     */
    public function getShipCustomerID()
    {
        return $this->ShipCustomerID;
    }
    /**
     * Set ShipCustomerID value
     * @param string $shipCustomerID
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setShipCustomerID($shipCustomerID = null)
    {
        // validation for constraint: string
        if (!is_null($shipCustomerID) && !is_string($shipCustomerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipCustomerID, true), gettype($shipCustomerID)), __LINE__);
        }
        $this->ShipCustomerID = $shipCustomerID;
        return $this;
    }
    /**
     * Get RxPreferences value
     * @return string|null
     */
    public function getRxPreferences()
    {
        return $this->RxPreferences;
    }
    /**
     * Set RxPreferences value
     * @param string $rxPreferences
     * @return \protec\StructType\DLCPMModifyCase
     */
    public function setRxPreferences($rxPreferences = null)
    {
        // validation for constraint: string
        if (!is_null($rxPreferences) && !is_string($rxPreferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rxPreferences, true), gettype($rxPreferences)), __LINE__);
        }
        $this->RxPreferences = $rxPreferences;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \protec\StructType\DLCPMModifyCase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
