<?php

namespace protec\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DLCPMCaseProduct StructType
 * @subpackage Structs
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class DLCPMCaseProduct extends AbstractStructBase
{
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The CPID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CPID;
    /**
     * The ProductCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ToothStr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToothStr;
    /**
     * The ToothStr2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToothStr2;
    /**
     * The Shade
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shade;
    /**
     * Constructor method for DLCPMCaseProduct
     * @uses DLCPMCaseProduct::setQuantity()
     * @uses DLCPMCaseProduct::setPrice()
     * @uses DLCPMCaseProduct::setCPID()
     * @uses DLCPMCaseProduct::setProductCode()
     * @uses DLCPMCaseProduct::setDescription()
     * @uses DLCPMCaseProduct::setToothStr()
     * @uses DLCPMCaseProduct::setToothStr2()
     * @uses DLCPMCaseProduct::setShade()
     * @param float $quantity
     * @param float $price
     * @param string $cPID
     * @param string $productCode
     * @param string $description
     * @param string $toothStr
     * @param string $toothStr2
     * @param string $shade
     */
    public function __construct($quantity = null, $price = null, $cPID = null, $productCode = null, $description = null, $toothStr = null, $toothStr2 = null, $shade = null)
    {
        $this
            ->setQuantity($quantity)
            ->setPrice($price)
            ->setCPID($cPID)
            ->setProductCode($productCode)
            ->setDescription($description)
            ->setToothStr($toothStr)
            ->setToothStr2($toothStr2)
            ->setShade($shade);
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \protec\StructType\DLCPMCaseProduct
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \protec\StructType\DLCPMCaseProduct
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get CPID value
     * @return string|null
     */
    public function getCPID()
    {
        return $this->CPID;
    }
    /**
     * Set CPID value
     * @param string $cPID
     * @return \protec\StructType\DLCPMCaseProduct
     */
    public function setCPID($cPID = null)
    {
        // validation for constraint: string
        if (!is_null($cPID) && !is_string($cPID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPID, true), gettype($cPID)), __LINE__);
        }
        $this->CPID = $cPID;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \protec\StructType\DLCPMCaseProduct
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \protec\StructType\DLCPMCaseProduct
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ToothStr value
     * @return string|null
     */
    public function getToothStr()
    {
        return $this->ToothStr;
    }
    /**
     * Set ToothStr value
     * @param string $toothStr
     * @return \protec\StructType\DLCPMCaseProduct
     */
    public function setToothStr($toothStr = null)
    {
        // validation for constraint: string
        if (!is_null($toothStr) && !is_string($toothStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toothStr, true), gettype($toothStr)), __LINE__);
        }
        $this->ToothStr = $toothStr;
        return $this;
    }
    /**
     * Get ToothStr2 value
     * @return string|null
     */
    public function getToothStr2()
    {
        return $this->ToothStr2;
    }
    /**
     * Set ToothStr2 value
     * @param string $toothStr2
     * @return \protec\StructType\DLCPMCaseProduct
     */
    public function setToothStr2($toothStr2 = null)
    {
        // validation for constraint: string
        if (!is_null($toothStr2) && !is_string($toothStr2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toothStr2, true), gettype($toothStr2)), __LINE__);
        }
        $this->ToothStr2 = $toothStr2;
        return $this;
    }
    /**
     * Get Shade value
     * @return string|null
     */
    public function getShade()
    {
        return $this->Shade;
    }
    /**
     * Set Shade value
     * @param string $shade
     * @return \protec\StructType\DLCPMCaseProduct
     */
    public function setShade($shade = null)
    {
        // validation for constraint: string
        if (!is_null($shade) && !is_string($shade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shade, true), gettype($shade)), __LINE__);
        }
        $this->Shade = $shade;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \protec\StructType\DLCPMCaseProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
