<?php

namespace protec\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DLCPMCaseDocument StructType
 * @subpackage Structs
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class DLCPMCaseDocument extends AbstractStructBase
{
    /**
     * The Repository
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Repository;
    /**
     * The IsLinkedDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsLinkedDocument;
    /**
     * The CaseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CaseID;
    /**
     * The Department
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Department;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The Filename
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filename;
    /**
     * The Buffer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Buffer;
    /**
     * The LinkURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LinkURL;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for DLCPMCaseDocument
     * @uses DLCPMCaseDocument::setRepository()
     * @uses DLCPMCaseDocument::setIsLinkedDocument()
     * @uses DLCPMCaseDocument::setCaseID()
     * @uses DLCPMCaseDocument::setDepartment()
     * @uses DLCPMCaseDocument::setNotes()
     * @uses DLCPMCaseDocument::setFilename()
     * @uses DLCPMCaseDocument::setBuffer()
     * @uses DLCPMCaseDocument::setLinkURL()
     * @uses DLCPMCaseDocument::setDescription()
     * @param string $repository
     * @param bool $isLinkedDocument
     * @param string $caseID
     * @param string $department
     * @param string $notes
     * @param string $filename
     * @param string $buffer
     * @param string $linkURL
     * @param string $description
     */
    public function __construct($repository = null, $isLinkedDocument = null, $caseID = null, $department = null, $notes = null, $filename = null, $buffer = null, $linkURL = null, $description = null)
    {
        $this
            ->setRepository($repository)
            ->setIsLinkedDocument($isLinkedDocument)
            ->setCaseID($caseID)
            ->setDepartment($department)
            ->setNotes($notes)
            ->setFilename($filename)
            ->setBuffer($buffer)
            ->setLinkURL($linkURL)
            ->setDescription($description);
    }
    /**
     * Get Repository value
     * @return string
     */
    public function getRepository()
    {
        return $this->Repository;
    }
    /**
     * Set Repository value
     * @uses \protec\EnumType\CaseDocumentRepositoryType::valueIsValid()
     * @uses \protec\EnumType\CaseDocumentRepositoryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $repository
     * @return \protec\StructType\DLCPMCaseDocument
     */
    public function setRepository($repository = null)
    {
        // validation for constraint: enumeration
        if (!\protec\EnumType\CaseDocumentRepositoryType::valueIsValid($repository)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \protec\EnumType\CaseDocumentRepositoryType', is_array($repository) ? implode(', ', $repository) : var_export($repository, true), implode(', ', \protec\EnumType\CaseDocumentRepositoryType::getValidValues())), __LINE__);
        }
        $this->Repository = $repository;
        return $this;
    }
    /**
     * Get IsLinkedDocument value
     * @return bool
     */
    public function getIsLinkedDocument()
    {
        return $this->IsLinkedDocument;
    }
    /**
     * Set IsLinkedDocument value
     * @param bool $isLinkedDocument
     * @return \protec\StructType\DLCPMCaseDocument
     */
    public function setIsLinkedDocument($isLinkedDocument = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLinkedDocument) && !is_bool($isLinkedDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLinkedDocument, true), gettype($isLinkedDocument)), __LINE__);
        }
        $this->IsLinkedDocument = $isLinkedDocument;
        return $this;
    }
    /**
     * Get CaseID value
     * @return string|null
     */
    public function getCaseID()
    {
        return $this->CaseID;
    }
    /**
     * Set CaseID value
     * @param string $caseID
     * @return \protec\StructType\DLCPMCaseDocument
     */
    public function setCaseID($caseID = null)
    {
        // validation for constraint: string
        if (!is_null($caseID) && !is_string($caseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caseID, true), gettype($caseID)), __LINE__);
        }
        $this->CaseID = $caseID;
        return $this;
    }
    /**
     * Get Department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->Department;
    }
    /**
     * Set Department value
     * @param string $department
     * @return \protec\StructType\DLCPMCaseDocument
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($department, true), gettype($department)), __LINE__);
        }
        $this->Department = $department;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \protec\StructType\DLCPMCaseDocument
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get Filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->Filename;
    }
    /**
     * Set Filename value
     * @param string $filename
     * @return \protec\StructType\DLCPMCaseDocument
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        $this->Filename = $filename;
        return $this;
    }
    /**
     * Get Buffer value
     * @return string|null
     */
    public function getBuffer()
    {
        return $this->Buffer;
    }
    /**
     * Set Buffer value
     * @param string $buffer
     * @return \protec\StructType\DLCPMCaseDocument
     */
    public function setBuffer($buffer = null)
    {
        // validation for constraint: string
        if (!is_null($buffer) && !is_string($buffer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buffer, true), gettype($buffer)), __LINE__);
        }
        $this->Buffer = $buffer;
        return $this;
    }
    /**
     * Get LinkURL value
     * @return string|null
     */
    public function getLinkURL()
    {
        return $this->LinkURL;
    }
    /**
     * Set LinkURL value
     * @param string $linkURL
     * @return \protec\StructType\DLCPMCaseDocument
     */
    public function setLinkURL($linkURL = null)
    {
        // validation for constraint: string
        if (!is_null($linkURL) && !is_string($linkURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkURL, true), gettype($linkURL)), __LINE__);
        }
        $this->LinkURL = $linkURL;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \protec\StructType\DLCPMCaseDocument
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \protec\StructType\DLCPMCaseDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
