<?php

namespace protec\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DLCPMCase StructType
 * @subpackage Structs
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class DLCPMCase extends AbstractStructBase
{
    /**
     * The CaseNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CaseNumber;
    /**
     * The ShipDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ShipDate;
    /**
     * The DateIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateIn;
    /**
     * The DueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DueDate;
    /**
     * The DocumentsCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocumentsCount;
    /**
     * The RemoteCaseNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RemoteCaseNumber;
    /**
     * The CaseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CaseID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerID;
    /**
     * The PatientFirst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PatientFirst;
    /**
     * The PatientLast
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PatientLast;
    /**
     * The LabName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LabName;
    /**
     * The Shade
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shade;
    /**
     * The RxNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RxNumber;
    /**
     * The DoctorName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DoctorName;
    /**
     * The PracticeDoctorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PracticeDoctorID;
    /**
     * The PanNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PanNumber;
    /**
     * The Carrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Carrier;
    /**
     * The CarrierServiceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierServiceType;
    /**
     * The WebComments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebComments;
    /**
     * The WorkorderNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkorderNotes;
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \protec\ArrayType\ArrayOfDLCPMCaseProduct
     */
    public $Products;
    /**
     * The RemakeCaseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RemakeCaseID;
    /**
     * The LinkedToCaseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LinkedToCaseID;
    /**
     * The RxPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RxPreferences;
    /**
     * The DeliveryNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryNotes;
    /**
     * The ShipCustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipCustomerID;
    /**
     * Constructor method for DLCPMCase
     * @uses DLCPMCase::setCaseNumber()
     * @uses DLCPMCase::setShipDate()
     * @uses DLCPMCase::setDateIn()
     * @uses DLCPMCase::setDueDate()
     * @uses DLCPMCase::setDocumentsCount()
     * @uses DLCPMCase::setRemoteCaseNumber()
     * @uses DLCPMCase::setCaseID()
     * @uses DLCPMCase::setCustomerID()
     * @uses DLCPMCase::setPatientFirst()
     * @uses DLCPMCase::setPatientLast()
     * @uses DLCPMCase::setLabName()
     * @uses DLCPMCase::setShade()
     * @uses DLCPMCase::setRxNumber()
     * @uses DLCPMCase::setDoctorName()
     * @uses DLCPMCase::setPracticeDoctorID()
     * @uses DLCPMCase::setPanNumber()
     * @uses DLCPMCase::setCarrier()
     * @uses DLCPMCase::setCarrierServiceType()
     * @uses DLCPMCase::setWebComments()
     * @uses DLCPMCase::setWorkorderNotes()
     * @uses DLCPMCase::setProducts()
     * @uses DLCPMCase::setRemakeCaseID()
     * @uses DLCPMCase::setLinkedToCaseID()
     * @uses DLCPMCase::setRxPreferences()
     * @uses DLCPMCase::setDeliveryNotes()
     * @uses DLCPMCase::setShipCustomerID()
     * @param int $caseNumber
     * @param string $shipDate
     * @param string $dateIn
     * @param string $dueDate
     * @param int $documentsCount
     * @param int $remoteCaseNumber
     * @param string $caseID
     * @param string $customerID
     * @param string $patientFirst
     * @param string $patientLast
     * @param string $labName
     * @param string $shade
     * @param string $rxNumber
     * @param string $doctorName
     * @param string $practiceDoctorID
     * @param string $panNumber
     * @param string $carrier
     * @param string $carrierServiceType
     * @param string $webComments
     * @param string $workorderNotes
     * @param \protec\ArrayType\ArrayOfDLCPMCaseProduct $products
     * @param string $remakeCaseID
     * @param string $linkedToCaseID
     * @param string $rxPreferences
     * @param string $deliveryNotes
     * @param string $shipCustomerID
     */
    public function __construct($caseNumber = null, $shipDate = null, $dateIn = null, $dueDate = null, $documentsCount = null, $remoteCaseNumber = null, $caseID = null, $customerID = null, $patientFirst = null, $patientLast = null, $labName = null, $shade = null, $rxNumber = null, $doctorName = null, $practiceDoctorID = null, $panNumber = null, $carrier = null, $carrierServiceType = null, $webComments = null, $workorderNotes = null, \protec\ArrayType\ArrayOfDLCPMCaseProduct $products = null, $remakeCaseID = null, $linkedToCaseID = null, $rxPreferences = null, $deliveryNotes = null, $shipCustomerID = null)
    {
        $this
            ->setCaseNumber($caseNumber)
            ->setShipDate($shipDate)
            ->setDateIn($dateIn)
            ->setDueDate($dueDate)
            ->setDocumentsCount($documentsCount)
            ->setRemoteCaseNumber($remoteCaseNumber)
            ->setCaseID($caseID)
            ->setCustomerID($customerID)
            ->setPatientFirst($patientFirst)
            ->setPatientLast($patientLast)
            ->setLabName($labName)
            ->setShade($shade)
            ->setRxNumber($rxNumber)
            ->setDoctorName($doctorName)
            ->setPracticeDoctorID($practiceDoctorID)
            ->setPanNumber($panNumber)
            ->setCarrier($carrier)
            ->setCarrierServiceType($carrierServiceType)
            ->setWebComments($webComments)
            ->setWorkorderNotes($workorderNotes)
            ->setProducts($products)
            ->setRemakeCaseID($remakeCaseID)
            ->setLinkedToCaseID($linkedToCaseID)
            ->setRxPreferences($rxPreferences)
            ->setDeliveryNotes($deliveryNotes)
            ->setShipCustomerID($shipCustomerID);
    }
    /**
     * Get CaseNumber value
     * @return int
     */
    public function getCaseNumber()
    {
        return $this->CaseNumber;
    }
    /**
     * Set CaseNumber value
     * @param int $caseNumber
     * @return \protec\StructType\DLCPMCase
     */
    public function setCaseNumber($caseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($caseNumber) && !(is_int($caseNumber) || ctype_digit($caseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($caseNumber, true), gettype($caseNumber)), __LINE__);
        }
        $this->CaseNumber = $caseNumber;
        return $this;
    }
    /**
     * Get ShipDate value
     * @return string
     */
    public function getShipDate()
    {
        return $this->ShipDate;
    }
    /**
     * Set ShipDate value
     * @param string $shipDate
     * @return \protec\StructType\DLCPMCase
     */
    public function setShipDate($shipDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipDate) && !is_string($shipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDate, true), gettype($shipDate)), __LINE__);
        }
        $this->ShipDate = $shipDate;
        return $this;
    }
    /**
     * Get DateIn value
     * @return string
     */
    public function getDateIn()
    {
        return $this->DateIn;
    }
    /**
     * Set DateIn value
     * @param string $dateIn
     * @return \protec\StructType\DLCPMCase
     */
    public function setDateIn($dateIn = null)
    {
        // validation for constraint: string
        if (!is_null($dateIn) && !is_string($dateIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateIn, true), gettype($dateIn)), __LINE__);
        }
        $this->DateIn = $dateIn;
        return $this;
    }
    /**
     * Get DueDate value
     * @return string
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \protec\StructType\DLCPMCase
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get DocumentsCount value
     * @return int
     */
    public function getDocumentsCount()
    {
        return $this->DocumentsCount;
    }
    /**
     * Set DocumentsCount value
     * @param int $documentsCount
     * @return \protec\StructType\DLCPMCase
     */
    public function setDocumentsCount($documentsCount = null)
    {
        // validation for constraint: int
        if (!is_null($documentsCount) && !(is_int($documentsCount) || ctype_digit($documentsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentsCount, true), gettype($documentsCount)), __LINE__);
        }
        $this->DocumentsCount = $documentsCount;
        return $this;
    }
    /**
     * Get RemoteCaseNumber value
     * @return int
     */
    public function getRemoteCaseNumber()
    {
        return $this->RemoteCaseNumber;
    }
    /**
     * Set RemoteCaseNumber value
     * @param int $remoteCaseNumber
     * @return \protec\StructType\DLCPMCase
     */
    public function setRemoteCaseNumber($remoteCaseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($remoteCaseNumber) && !(is_int($remoteCaseNumber) || ctype_digit($remoteCaseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($remoteCaseNumber, true), gettype($remoteCaseNumber)), __LINE__);
        }
        $this->RemoteCaseNumber = $remoteCaseNumber;
        return $this;
    }
    /**
     * Get CaseID value
     * @return string|null
     */
    public function getCaseID()
    {
        return $this->CaseID;
    }
    /**
     * Set CaseID value
     * @param string $caseID
     * @return \protec\StructType\DLCPMCase
     */
    public function setCaseID($caseID = null)
    {
        // validation for constraint: string
        if (!is_null($caseID) && !is_string($caseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caseID, true), gettype($caseID)), __LINE__);
        }
        $this->CaseID = $caseID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return string|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param string $customerID
     * @return \protec\StructType\DLCPMCase
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: string
        if (!is_null($customerID) && !is_string($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get PatientFirst value
     * @return string|null
     */
    public function getPatientFirst()
    {
        return $this->PatientFirst;
    }
    /**
     * Set PatientFirst value
     * @param string $patientFirst
     * @return \protec\StructType\DLCPMCase
     */
    public function setPatientFirst($patientFirst = null)
    {
        // validation for constraint: string
        if (!is_null($patientFirst) && !is_string($patientFirst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patientFirst, true), gettype($patientFirst)), __LINE__);
        }
        $this->PatientFirst = $patientFirst;
        return $this;
    }
    /**
     * Get PatientLast value
     * @return string|null
     */
    public function getPatientLast()
    {
        return $this->PatientLast;
    }
    /**
     * Set PatientLast value
     * @param string $patientLast
     * @return \protec\StructType\DLCPMCase
     */
    public function setPatientLast($patientLast = null)
    {
        // validation for constraint: string
        if (!is_null($patientLast) && !is_string($patientLast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patientLast, true), gettype($patientLast)), __LINE__);
        }
        $this->PatientLast = $patientLast;
        return $this;
    }
    /**
     * Get LabName value
     * @return string|null
     */
    public function getLabName()
    {
        return $this->LabName;
    }
    /**
     * Set LabName value
     * @param string $labName
     * @return \protec\StructType\DLCPMCase
     */
    public function setLabName($labName = null)
    {
        // validation for constraint: string
        if (!is_null($labName) && !is_string($labName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labName, true), gettype($labName)), __LINE__);
        }
        $this->LabName = $labName;
        return $this;
    }
    /**
     * Get Shade value
     * @return string|null
     */
    public function getShade()
    {
        return $this->Shade;
    }
    /**
     * Set Shade value
     * @param string $shade
     * @return \protec\StructType\DLCPMCase
     */
    public function setShade($shade = null)
    {
        // validation for constraint: string
        if (!is_null($shade) && !is_string($shade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shade, true), gettype($shade)), __LINE__);
        }
        $this->Shade = $shade;
        return $this;
    }
    /**
     * Get RxNumber value
     * @return string|null
     */
    public function getRxNumber()
    {
        return $this->RxNumber;
    }
    /**
     * Set RxNumber value
     * @param string $rxNumber
     * @return \protec\StructType\DLCPMCase
     */
    public function setRxNumber($rxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($rxNumber) && !is_string($rxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rxNumber, true), gettype($rxNumber)), __LINE__);
        }
        $this->RxNumber = $rxNumber;
        return $this;
    }
    /**
     * Get DoctorName value
     * @return string|null
     */
    public function getDoctorName()
    {
        return $this->DoctorName;
    }
    /**
     * Set DoctorName value
     * @param string $doctorName
     * @return \protec\StructType\DLCPMCase
     */
    public function setDoctorName($doctorName = null)
    {
        // validation for constraint: string
        if (!is_null($doctorName) && !is_string($doctorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doctorName, true), gettype($doctorName)), __LINE__);
        }
        $this->DoctorName = $doctorName;
        return $this;
    }
    /**
     * Get PracticeDoctorID value
     * @return string|null
     */
    public function getPracticeDoctorID()
    {
        return $this->PracticeDoctorID;
    }
    /**
     * Set PracticeDoctorID value
     * @param string $practiceDoctorID
     * @return \protec\StructType\DLCPMCase
     */
    public function setPracticeDoctorID($practiceDoctorID = null)
    {
        // validation for constraint: string
        if (!is_null($practiceDoctorID) && !is_string($practiceDoctorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($practiceDoctorID, true), gettype($practiceDoctorID)), __LINE__);
        }
        $this->PracticeDoctorID = $practiceDoctorID;
        return $this;
    }
    /**
     * Get PanNumber value
     * @return string|null
     */
    public function getPanNumber()
    {
        return $this->PanNumber;
    }
    /**
     * Set PanNumber value
     * @param string $panNumber
     * @return \protec\StructType\DLCPMCase
     */
    public function setPanNumber($panNumber = null)
    {
        // validation for constraint: string
        if (!is_null($panNumber) && !is_string($panNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($panNumber, true), gettype($panNumber)), __LINE__);
        }
        $this->PanNumber = $panNumber;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \protec\StructType\DLCPMCase
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier, true), gettype($carrier)), __LINE__);
        }
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get CarrierServiceType value
     * @return string|null
     */
    public function getCarrierServiceType()
    {
        return $this->CarrierServiceType;
    }
    /**
     * Set CarrierServiceType value
     * @param string $carrierServiceType
     * @return \protec\StructType\DLCPMCase
     */
    public function setCarrierServiceType($carrierServiceType = null)
    {
        // validation for constraint: string
        if (!is_null($carrierServiceType) && !is_string($carrierServiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierServiceType, true), gettype($carrierServiceType)), __LINE__);
        }
        $this->CarrierServiceType = $carrierServiceType;
        return $this;
    }
    /**
     * Get WebComments value
     * @return string|null
     */
    public function getWebComments()
    {
        return $this->WebComments;
    }
    /**
     * Set WebComments value
     * @param string $webComments
     * @return \protec\StructType\DLCPMCase
     */
    public function setWebComments($webComments = null)
    {
        // validation for constraint: string
        if (!is_null($webComments) && !is_string($webComments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webComments, true), gettype($webComments)), __LINE__);
        }
        $this->WebComments = $webComments;
        return $this;
    }
    /**
     * Get WorkorderNotes value
     * @return string|null
     */
    public function getWorkorderNotes()
    {
        return $this->WorkorderNotes;
    }
    /**
     * Set WorkorderNotes value
     * @param string $workorderNotes
     * @return \protec\StructType\DLCPMCase
     */
    public function setWorkorderNotes($workorderNotes = null)
    {
        // validation for constraint: string
        if (!is_null($workorderNotes) && !is_string($workorderNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workorderNotes, true), gettype($workorderNotes)), __LINE__);
        }
        $this->WorkorderNotes = $workorderNotes;
        return $this;
    }
    /**
     * Get Products value
     * @return \protec\ArrayType\ArrayOfDLCPMCaseProduct|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \protec\ArrayType\ArrayOfDLCPMCaseProduct $products
     * @return \protec\StructType\DLCPMCase
     */
    public function setProducts(\protec\ArrayType\ArrayOfDLCPMCaseProduct $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get RemakeCaseID value
     * @return string|null
     */
    public function getRemakeCaseID()
    {
        return $this->RemakeCaseID;
    }
    /**
     * Set RemakeCaseID value
     * @param string $remakeCaseID
     * @return \protec\StructType\DLCPMCase
     */
    public function setRemakeCaseID($remakeCaseID = null)
    {
        // validation for constraint: string
        if (!is_null($remakeCaseID) && !is_string($remakeCaseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remakeCaseID, true), gettype($remakeCaseID)), __LINE__);
        }
        $this->RemakeCaseID = $remakeCaseID;
        return $this;
    }
    /**
     * Get LinkedToCaseID value
     * @return string|null
     */
    public function getLinkedToCaseID()
    {
        return $this->LinkedToCaseID;
    }
    /**
     * Set LinkedToCaseID value
     * @param string $linkedToCaseID
     * @return \protec\StructType\DLCPMCase
     */
    public function setLinkedToCaseID($linkedToCaseID = null)
    {
        // validation for constraint: string
        if (!is_null($linkedToCaseID) && !is_string($linkedToCaseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedToCaseID, true), gettype($linkedToCaseID)), __LINE__);
        }
        $this->LinkedToCaseID = $linkedToCaseID;
        return $this;
    }
    /**
     * Get RxPreferences value
     * @return string|null
     */
    public function getRxPreferences()
    {
        return $this->RxPreferences;
    }
    /**
     * Set RxPreferences value
     * @param string $rxPreferences
     * @return \protec\StructType\DLCPMCase
     */
    public function setRxPreferences($rxPreferences = null)
    {
        // validation for constraint: string
        if (!is_null($rxPreferences) && !is_string($rxPreferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rxPreferences, true), gettype($rxPreferences)), __LINE__);
        }
        $this->RxPreferences = $rxPreferences;
        return $this;
    }
    /**
     * Get DeliveryNotes value
     * @return string|null
     */
    public function getDeliveryNotes()
    {
        return $this->DeliveryNotes;
    }
    /**
     * Set DeliveryNotes value
     * @param string $deliveryNotes
     * @return \protec\StructType\DLCPMCase
     */
    public function setDeliveryNotes($deliveryNotes = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNotes) && !is_string($deliveryNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryNotes, true), gettype($deliveryNotes)), __LINE__);
        }
        $this->DeliveryNotes = $deliveryNotes;
        return $this;
    }
    /**
     * Get ShipCustomerID value
     * @return string|null
     */
    public function getShipCustomerID()
    {
        return $this->ShipCustomerID;
    }
    /**
     * Set ShipCustomerID value
     * @param string $shipCustomerID
     * @return \protec\StructType\DLCPMCase
     */
    public function setShipCustomerID($shipCustomerID = null)
    {
        // validation for constraint: string
        if (!is_null($shipCustomerID) && !is_string($shipCustomerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipCustomerID, true), gettype($shipCustomerID)), __LINE__);
        }
        $this->ShipCustomerID = $shipCustomerID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \protec\StructType\DLCPMCase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
