<?php

namespace protec\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DLCPMAPIAuthentication StructType
 * @subpackage Structs
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class DLCPMAPIAuthentication extends AbstractStructBase
{
    /**
     * The AppName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AppName;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for DLCPMAPIAuthentication
     * @uses DLCPMAPIAuthentication::setAppName()
     * @uses DLCPMAPIAuthentication::setUserName()
     * @uses DLCPMAPIAuthentication::setPassword()
     * @param string $appName
     * @param string $userName
     * @param string $password
     */
    public function __construct($appName = null, $userName = null, $password = null)
    {
        $this
            ->setAppName($appName)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get AppName value
     * @return string|null
     */
    public function getAppName()
    {
        return $this->AppName;
    }
    /**
     * Set AppName value
     * @param string $appName
     * @return \protec\StructType\DLCPMAPIAuthentication
     */
    public function setAppName($appName = null)
    {
        // validation for constraint: string
        if (!is_null($appName) && !is_string($appName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appName, true), gettype($appName)), __LINE__);
        }
        $this->AppName = $appName;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \protec\StructType\DLCPMAPIAuthentication
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \protec\StructType\DLCPMAPIAuthentication
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \protec\StructType\DLCPMAPIAuthentication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
