<?php

namespace protec\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DLCPMAPIAddCaseResponse StructType
 * @subpackage Structs
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class DLCPMAPIAddCaseResponse extends DLCPMAPIResponse
{
    /**
     * The CaseNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CaseNumber;
    /**
     * The DueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DueDate;
    /**
     * The CaseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CaseID;
    /**
     * Constructor method for DLCPMAPIAddCaseResponse
     * @uses DLCPMAPIAddCaseResponse::setCaseNumber()
     * @uses DLCPMAPIAddCaseResponse::setDueDate()
     * @uses DLCPMAPIAddCaseResponse::setCaseID()
     * @param int $caseNumber
     * @param string $dueDate
     * @param string $caseID
     */
    public function __construct($caseNumber = null, $dueDate = null, $caseID = null)
    {
        $this
            ->setCaseNumber($caseNumber)
            ->setDueDate($dueDate)
            ->setCaseID($caseID);
    }
    /**
     * Get CaseNumber value
     * @return int
     */
    public function getCaseNumber()
    {
        return $this->CaseNumber;
    }
    /**
     * Set CaseNumber value
     * @param int $caseNumber
     * @return \protec\StructType\DLCPMAPIAddCaseResponse
     */
    public function setCaseNumber($caseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($caseNumber) && !(is_int($caseNumber) || ctype_digit($caseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($caseNumber, true), gettype($caseNumber)), __LINE__);
        }
        $this->CaseNumber = $caseNumber;
        return $this;
    }
    /**
     * Get DueDate value
     * @return string
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \protec\StructType\DLCPMAPIAddCaseResponse
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get CaseID value
     * @return string|null
     */
    public function getCaseID()
    {
        return $this->CaseID;
    }
    /**
     * Set CaseID value
     * @param string $caseID
     * @return \protec\StructType\DLCPMAPIAddCaseResponse
     */
    public function setCaseID($caseID = null)
    {
        // validation for constraint: string
        if (!is_null($caseID) && !is_string($caseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caseID, true), gettype($caseID)), __LINE__);
        }
        $this->CaseID = $caseID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \protec\StructType\DLCPMAPIAddCaseResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
