<?php

namespace protec\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Submit ServiceType
 * @subpackage Services
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class Submit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SubmitCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \protec\StructType\SubmitCustomer $parameters
     * @return \protec\StructType\SubmitCustomerResponse|bool
     */
    public function SubmitCustomer(\protec\StructType\SubmitCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SubmitCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitPracticeDoctor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \protec\StructType\SubmitPracticeDoctor $parameters
     * @return \protec\StructType\SubmitPracticeDoctorResponse|bool
     */
    public function SubmitPracticeDoctor(\protec\StructType\SubmitPracticeDoctor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SubmitPracticeDoctor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \protec\StructType\SubmitCustomerResponse|\protec\StructType\SubmitPracticeDoctorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
