<?php

namespace protec\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Query ServiceType
 * @subpackage Services
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class Query extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named QueryCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \protec\StructType\QueryCustomer $parameters
     * @return \protec\StructType\QueryCustomerResponse|bool
     */
    public function QueryCustomer(\protec\StructType\QueryCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->QueryCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \protec\StructType\QueryCustomerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
