<?php

namespace protec\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Noop ServiceType
 * @subpackage Services
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class Noop extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Noop1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \protec\StructType\Noop1 $parameters
     * @return \protec\StructType\Noop1Response|bool
     */
    public function Noop1(\protec\StructType\Noop1 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Noop1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Noop2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \protec\StructType\Noop2 $parameters
     * @return \protec\StructType\Noop2Response|bool
     */
    public function Noop2(\protec\StructType\Noop2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Noop2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Noop3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \protec\StructType\Noop3 $parameters
     * @return \protec\StructType\Noop3Response|bool
     */
    public function Noop3(\protec\StructType\Noop3 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Noop3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \protec\StructType\Noop1Response|\protec\StructType\Noop2Response|\protec\StructType\Noop3Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
