<?php

namespace protec\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeleteCase
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \protec\StructType\DeleteCase $parameters
     * @return \protec\StructType\DeleteCaseResponse|bool
     */
    public function DeleteCase(\protec\StructType\DeleteCase $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteCase($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteCaseDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \protec\StructType\DeleteCaseDocument $parameters
     * @return \protec\StructType\DeleteCaseDocumentResponse|bool
     */
    public function DeleteCaseDocument(\protec\StructType\DeleteCaseDocument $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteCaseDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \protec\StructType\DeleteCaseDocumentResponse|\protec\StructType\DeleteCaseResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
