<?php

namespace protec\EnumType;

/**
 * This class stands for CaseDocumentRepositoryType EnumType
 * @subpackage Enumerations
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class CaseDocumentRepositoryType
{
    /**
     * Constant for value 'CaseImages'
     * @return string 'CaseImages'
     */
    const VALUE_CASE_IMAGES = 'CaseImages';
    /**
     * Constant for value 'Designs'
     * @return string 'Designs'
     */
    const VALUE_DESIGNS = 'Designs';
    /**
     * Constant for value 'ModelScans'
     * @return string 'ModelScans'
     */
    const VALUE_MODEL_SCANS = 'ModelScans';
    /**
     * Constant for value 'DigitalImpressions'
     * @return string 'DigitalImpressions'
     */
    const VALUE_DIGITAL_IMPRESSIONS = 'DigitalImpressions';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CASE_IMAGES
     * @uses self::VALUE_DESIGNS
     * @uses self::VALUE_MODEL_SCANS
     * @uses self::VALUE_DIGITAL_IMPRESSIONS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CASE_IMAGES,
            self::VALUE_DESIGNS,
            self::VALUE_MODEL_SCANS,
            self::VALUE_DIGITAL_IMPRESSIONS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
