<?php

namespace protec;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'AddCase' => '\\protec\\StructType\\AddCase',
            'DLCPMAPIAddCaseRequest' => '\\protec\\StructType\\DLCPMAPIAddCaseRequest',
            'DLCPMAPIRequest' => '\\protec\\StructType\\DLCPMAPIRequest',
            'DLCPMAPIAuthentication' => '\\protec\\StructType\\DLCPMAPIAuthentication',
            'DLCPMCase' => '\\protec\\StructType\\DLCPMCase',
            'ArrayOfDLCPMCaseProduct' => '\\protec\\ArrayType\\ArrayOfDLCPMCaseProduct',
            'DLCPMCaseProduct' => '\\protec\\StructType\\DLCPMCaseProduct',
            'AddCaseResponse' => '\\protec\\StructType\\AddCaseResponse',
            'DLCPMAPIAddCaseResponse' => '\\protec\\StructType\\DLCPMAPIAddCaseResponse',
            'DLCPMAPIResponse' => '\\protec\\StructType\\DLCPMAPIResponse',
            'ArrayOfAnyType' => '\\protec\\ArrayType\\ArrayOfAnyType',
            'ModifyCase' => '\\protec\\StructType\\ModifyCase',
            'DLCPMAPIModifyCaseRequest' => '\\protec\\StructType\\DLCPMAPIModifyCaseRequest',
            'DLCPMModifyCase' => '\\protec\\StructType\\DLCPMModifyCase',
            'ModifyCaseResponse' => '\\protec\\StructType\\ModifyCaseResponse',
            'DeleteCase' => '\\protec\\StructType\\DeleteCase',
            'DLCPMAPIDeleteCaseRequest' => '\\protec\\StructType\\DLCPMAPIDeleteCaseRequest',
            'DeleteCaseResponse' => '\\protec\\StructType\\DeleteCaseResponse',
            'AddCaseDocument' => '\\protec\\StructType\\AddCaseDocument',
            'DLCPMAPIAddCaseDocumentRequest' => '\\protec\\StructType\\DLCPMAPIAddCaseDocumentRequest',
            'DLCPMCaseDocument' => '\\protec\\StructType\\DLCPMCaseDocument',
            'AddCaseDocumentResponse' => '\\protec\\StructType\\AddCaseDocumentResponse',
            'DLCPMAPIAddCaseDocumentResponse' => '\\protec\\StructType\\DLCPMAPIAddCaseDocumentResponse',
            'DeleteCaseDocument' => '\\protec\\StructType\\DeleteCaseDocument',
            'DLCPMAPIDeleteCaseDocumentRequest' => '\\protec\\StructType\\DLCPMAPIDeleteCaseDocumentRequest',
            'DeleteCaseDocumentResponse' => '\\protec\\StructType\\DeleteCaseDocumentResponse',
            'AddCallNote' => '\\protec\\StructType\\AddCallNote',
            'DLCPMAPIAddCallNoteRequest' => '\\protec\\StructType\\DLCPMAPIAddCallNoteRequest',
            'DLCPMCallNote' => '\\protec\\StructType\\DLCPMCallNote',
            'AddCallNoteResponse' => '\\protec\\StructType\\AddCallNoteResponse',
            'AddCaseLog' => '\\protec\\StructType\\AddCaseLog',
            'DLCPMAPIAddCaseLogRequest' => '\\protec\\StructType\\DLCPMAPIAddCaseLogRequest',
            'AddCaseLogResponse' => '\\protec\\StructType\\AddCaseLogResponse',
            'SubmitCustomer' => '\\protec\\StructType\\SubmitCustomer',
            'DLCPMAPISubmitCustomerRequest' => '\\protec\\StructType\\DLCPMAPISubmitCustomerRequest',
            'SubmitCustomerResponse' => '\\protec\\StructType\\SubmitCustomerResponse',
            'SubmitPracticeDoctor' => '\\protec\\StructType\\SubmitPracticeDoctor',
            'DLCPMAPISubmitPracticeDoctorRequest' => '\\protec\\StructType\\DLCPMAPISubmitPracticeDoctorRequest',
            'SubmitPracticeDoctorResponse' => '\\protec\\StructType\\SubmitPracticeDoctorResponse',
            'QueryCustomer' => '\\protec\\StructType\\QueryCustomer',
            'DLCPMAPIQueryCustomerRequest' => '\\protec\\StructType\\DLCPMAPIQueryCustomerRequest',
            'CustomerInfo' => '\\protec\\StructType\\CustomerInfo',
            'ArrayOfPracticeDoctorInfo' => '\\protec\\ArrayType\\ArrayOfPracticeDoctorInfo',
            'PracticeDoctorInfo' => '\\protec\\StructType\\PracticeDoctorInfo',
            'QueryCustomerResponse' => '\\protec\\StructType\\QueryCustomerResponse',
            'DLCPMAPIQueryCustomerResponse' => '\\protec\\StructType\\DLCPMAPIQueryCustomerResponse',
            'Noop1' => '\\protec\\StructType\\Noop1',
            'Noop1Response' => '\\protec\\StructType\\Noop1Response',
            'Noop2' => '\\protec\\StructType\\Noop2',
            'Noop2Response' => '\\protec\\StructType\\Noop2Response',
            'Noop3' => '\\protec\\StructType\\Noop3',
            'Noop3Response' => '\\protec\\StructType\\Noop3Response',
            'Test' => '\\protec\\StructType\\Test',
            'TestResponse' => '\\protec\\StructType\\TestResponse',
        );
    }
}
