<?php

namespace protec\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DLCPMAPIResponse StructType
 * @subpackage Structs
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class DLCPMAPIResponse extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResponseCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The List
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \protec\ArrayType\ArrayOfAnyType
     */
    public $List;
    /**
     * Constructor method for DLCPMAPIResponse
     * @uses DLCPMAPIResponse::setResponseCode()
     * @uses DLCPMAPIResponse::setDescription()
     * @uses DLCPMAPIResponse::setList()
     * @param int $responseCode
     * @param string $description
     * @param \protec\ArrayType\ArrayOfAnyType $list
     */
    public function __construct($responseCode = null, $description = null, \protec\ArrayType\ArrayOfAnyType $list = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setDescription($description)
            ->setList($list);
    }
    /**
     * Get ResponseCode value
     * @return int
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param int $responseCode
     * @return \protec\StructType\DLCPMAPIResponse
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: int
        if (!is_null($responseCode) && !(is_int($responseCode) || ctype_digit($responseCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \protec\StructType\DLCPMAPIResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get List value
     * @return \protec\ArrayType\ArrayOfAnyType|null
     */
    public function getList()
    {
        return $this->List;
    }
    /**
     * Set List value
     * @param \protec\ArrayType\ArrayOfAnyType $list
     * @return \protec\StructType\DLCPMAPIResponse
     */
    public function setList(\protec\ArrayType\ArrayOfAnyType $list = null)
    {
        $this->List = $list;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \protec\StructType\DLCPMAPIResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
