<?php

namespace protec\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DLCPMAPIQueryCustomerRequest StructType
 * @subpackage Structs
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class DLCPMAPIQueryCustomerRequest extends DLCPMAPIRequest
{
    /**
     * The RemoteID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RemoteID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerID;
    /**
     * Constructor method for DLCPMAPIQueryCustomerRequest
     * @uses DLCPMAPIQueryCustomerRequest::setRemoteID()
     * @uses DLCPMAPIQueryCustomerRequest::setCustomerID()
     * @param string $remoteID
     * @param string $customerID
     */
    public function __construct($remoteID = null, $customerID = null)
    {
        $this
            ->setRemoteID($remoteID)
            ->setCustomerID($customerID);
    }
    /**
     * Get RemoteID value
     * @return string|null
     */
    public function getRemoteID()
    {
        return $this->RemoteID;
    }
    /**
     * Set RemoteID value
     * @param string $remoteID
     * @return \protec\StructType\DLCPMAPIQueryCustomerRequest
     */
    public function setRemoteID($remoteID = null)
    {
        // validation for constraint: string
        if (!is_null($remoteID) && !is_string($remoteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remoteID, true), gettype($remoteID)), __LINE__);
        }
        $this->RemoteID = $remoteID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return string|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param string $customerID
     * @return \protec\StructType\DLCPMAPIQueryCustomerRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: string
        if (!is_null($customerID) && !is_string($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \protec\StructType\DLCPMAPIQueryCustomerRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
