<?php

namespace protec\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Test ServiceType
 * @subpackage Services
 * @version 1.0
 * @date 2019/06/17
 * @author webdev
 */
class Test extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Test
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \protec\StructType\Test $parameters
     * @return \protec\StructType\TestResponse|bool
     */
    public function Test(\protec\StructType\Test $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Test($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \protec\StructType\TestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
