<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.quadranet.co.uk/qsldemowebservice/QSLWebBooking.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.quadranet.co.uk/qsldemowebservice/QSLWebBooking.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \pg\ClassMap::get(),
);
/**
 * Samples for Test ServiceType
 */
$test = new \pg\ServiceType\Test($options);
/**
 * Sample call for Test operation/method
 */
if ($test->Test(new \pg\StructType\Test()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Samples for Book ServiceType
 */
$book = new \pg\ServiceType\Book($options);
/**
 * Sample call for BookTable operation/method
 */
if ($book->BookTable(new \pg\StructType\BookTable()) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \pg\ServiceType\Get($options);
/**
 * Sample call for GetSessionAvailability operation/method
 */
if ($get->GetSessionAvailability(new \pg\StructType\GetSessionAvailability()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWebConfig operation/method
 */
if ($get->GetWebConfig(new \pg\StructType\GetWebConfig()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSessionAvailabilityV4 operation/method
 */
if ($get->GetSessionAvailabilityV4(new \pg\StructType\GetSessionAvailabilityV4()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTimesForSessionV4 operation/method
 */
if ($get->GetTimesForSessionV4(new \pg\StructType\GetTimesForSessionV4()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdvancedBookingLimitV4 operation/method
 */
if ($get->GetAdvancedBookingLimitV4(new \pg\StructType\GetAdvancedBookingLimitV4()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDateLimitV4 operation/method
 */
if ($get->GetDateLimitV4(new \pg\StructType\GetDateLimitV4()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
