<?php

namespace pg\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSessionAvailabilityV4 StructType
 * @subpackage Structs
 */
class GetSessionAvailabilityV4 extends AbstractStructBase
{
    /**
     * The UserAccessLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserAccessLevel;
    /**
     * The PlanDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PlanDate;
    /**
     * The Session
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Session;
    /**
     * The Covers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Covers;
    /**
     * The RestaurantGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RestaurantGroup;
    /**
     * The Prefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Prefix;
    /**
     * Constructor method for GetSessionAvailabilityV4
     * @uses GetSessionAvailabilityV4::setUserAccessLevel()
     * @uses GetSessionAvailabilityV4::setPlanDate()
     * @uses GetSessionAvailabilityV4::setSession()
     * @uses GetSessionAvailabilityV4::setCovers()
     * @uses GetSessionAvailabilityV4::setRestaurantGroup()
     * @uses GetSessionAvailabilityV4::setPrefix()
     * @param int $userAccessLevel
     * @param string $planDate
     * @param int $session
     * @param int $covers
     * @param string $restaurantGroup
     * @param string $prefix
     */
    public function __construct($userAccessLevel = null, $planDate = null, $session = null, $covers = null, $restaurantGroup = null, $prefix = null)
    {
        $this
            ->setUserAccessLevel($userAccessLevel)
            ->setPlanDate($planDate)
            ->setSession($session)
            ->setCovers($covers)
            ->setRestaurantGroup($restaurantGroup)
            ->setPrefix($prefix);
    }
    /**
     * Get UserAccessLevel value
     * @return int
     */
    public function getUserAccessLevel()
    {
        return $this->UserAccessLevel;
    }
    /**
     * Set UserAccessLevel value
     * @param int $userAccessLevel
     * @return \pg\StructType\GetSessionAvailabilityV4
     */
    public function setUserAccessLevel($userAccessLevel = null)
    {
        // validation for constraint: int
        if (!is_null($userAccessLevel) && !(is_int($userAccessLevel) || ctype_digit($userAccessLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userAccessLevel, true), gettype($userAccessLevel)), __LINE__);
        }
        $this->UserAccessLevel = $userAccessLevel;
        return $this;
    }
    /**
     * Get PlanDate value
     * @return string
     */
    public function getPlanDate()
    {
        return $this->PlanDate;
    }
    /**
     * Set PlanDate value
     * @param string $planDate
     * @return \pg\StructType\GetSessionAvailabilityV4
     */
    public function setPlanDate($planDate = null)
    {
        // validation for constraint: string
        if (!is_null($planDate) && !is_string($planDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($planDate, true), gettype($planDate)), __LINE__);
        }
        $this->PlanDate = $planDate;
        return $this;
    }
    /**
     * Get Session value
     * @return int
     */
    public function getSession()
    {
        return $this->Session;
    }
    /**
     * Set Session value
     * @param int $session
     * @return \pg\StructType\GetSessionAvailabilityV4
     */
    public function setSession($session = null)
    {
        // validation for constraint: int
        if (!is_null($session) && !(is_int($session) || ctype_digit($session))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($session, true), gettype($session)), __LINE__);
        }
        $this->Session = $session;
        return $this;
    }
    /**
     * Get Covers value
     * @return int
     */
    public function getCovers()
    {
        return $this->Covers;
    }
    /**
     * Set Covers value
     * @param int $covers
     * @return \pg\StructType\GetSessionAvailabilityV4
     */
    public function setCovers($covers = null)
    {
        // validation for constraint: int
        if (!is_null($covers) && !(is_int($covers) || ctype_digit($covers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($covers, true), gettype($covers)), __LINE__);
        }
        $this->Covers = $covers;
        return $this;
    }
    /**
     * Get RestaurantGroup value
     * @return string|null
     */
    public function getRestaurantGroup()
    {
        return $this->RestaurantGroup;
    }
    /**
     * Set RestaurantGroup value
     * @param string $restaurantGroup
     * @return \pg\StructType\GetSessionAvailabilityV4
     */
    public function setRestaurantGroup($restaurantGroup = null)
    {
        // validation for constraint: string
        if (!is_null($restaurantGroup) && !is_string($restaurantGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restaurantGroup, true), gettype($restaurantGroup)), __LINE__);
        }
        $this->RestaurantGroup = $restaurantGroup;
        return $this;
    }
    /**
     * Get Prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->Prefix;
    }
    /**
     * Set Prefix value
     * @param string $prefix
     * @return \pg\StructType\GetSessionAvailabilityV4
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefix, true), gettype($prefix)), __LINE__);
        }
        $this->Prefix = $prefix;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \pg\StructType\GetSessionAvailabilityV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
