<?php

namespace pg\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetSessionAvailability
     * Meta informations extracted from the WSDL
     * - documentation: v5 only: Gets availability for specified session
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \pg\StructType\GetSessionAvailability $parameters
     * @return \pg\StructType\GetSessionAvailabilityResponse|bool
     */
    public function GetSessionAvailability(\pg\StructType\GetSessionAvailability $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSessionAvailability($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebConfig
     * Meta informations extracted from the WSDL
     * - documentation: v5 only: Gets web booking configuration information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \pg\StructType\GetWebConfig $parameters
     * @return \pg\StructType\GetWebConfigResponse|bool
     */
    public function GetWebConfig(\pg\StructType\GetWebConfig $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWebConfig($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSessionAvailabilityV4
     * Meta informations extracted from the WSDL
     * - documentation: v4 only: Gets availability for specified session
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \pg\StructType\GetSessionAvailabilityV4 $parameters
     * @return \pg\StructType\GetSessionAvailabilityV4Response|bool
     */
    public function GetSessionAvailabilityV4(\pg\StructType\GetSessionAvailabilityV4 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSessionAvailabilityV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTimesForSessionV4
     * Meta informations extracted from the WSDL
     * - documentation: v4 only: Gets availability for specified session (obsolete)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \pg\StructType\GetTimesForSessionV4 $parameters
     * @return \pg\StructType\GetTimesForSessionV4Response|bool
     */
    public function GetTimesForSessionV4(\pg\StructType\GetTimesForSessionV4 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTimesForSessionV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdvancedBookingLimitV4
     * Meta informations extracted from the WSDL
     * - documentation: v4 only: Date up to which bookings will be accepted
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \pg\StructType\GetAdvancedBookingLimitV4 $parameters
     * @return \pg\StructType\GetAdvancedBookingLimitV4Response|bool
     */
    public function GetAdvancedBookingLimitV4(\pg\StructType\GetAdvancedBookingLimitV4 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAdvancedBookingLimitV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDateLimitV4
     * Meta informations extracted from the WSDL
     * - documentation: v4 only: Date up to which bookings will be accepted (obsolete)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \pg\StructType\GetDateLimitV4 $parameters
     * @return \pg\StructType\GetDateLimitV4Response|bool
     */
    public function GetDateLimitV4(\pg\StructType\GetDateLimitV4 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDateLimitV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \pg\StructType\GetAdvancedBookingLimitV4Response|\pg\StructType\GetDateLimitV4Response|\pg\StructType\GetSessionAvailabilityResponse|\pg\StructType\GetSessionAvailabilityV4Response|\pg\StructType\GetTimesForSessionV4Response|\pg\StructType\GetWebConfigResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
