<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://sandbox-api.cvent.com/soap/V200611.ASMX?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://sandbox-api.cvent.com/soap/V200611.ASMX?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \ServiceType\Retrieve($options);
$retrieve->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for Retrieve operation/method
 */
if ($retrieve->Retrieve(new \StructType\Retrieve()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for GetUpdated operation/method
 */
if ($get->GetUpdated(new \StructType\GetUpdated()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDeleted operation/method
 */
if ($get->GetDeleted(new \StructType\GetDeleted()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
$search->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for Search operation/method
 */
if ($search->Search(new \StructType\Search()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Describe ServiceType
 */
$describe = new \ServiceType\Describe($options);
$describe->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for DescribeGlobal operation/method
 */
if ($describe->DescribeGlobal(new \StructType\DescribeGlobal()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for DescribeCvObject operation/method
 */
if ($describe->DescribeCvObject(new \StructType\DescribeCvObject()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for Login operation/method
 */
if ($login->Login(new \StructType\Login()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
$create->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for CreateContact operation/method
 */
if ($create->CreateContact(new \StructType\CreateContact()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateContactGroup operation/method
 */
if ($create->CreateContactGroup(new \StructType\CreateContactGroup()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateDistributionList operation/method
 */
if ($create->CreateDistributionList(new \StructType\CreateDistributionList()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateApprover operation/method
 */
if ($create->CreateApprover(new \StructType\CreateApprover()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateBudgetItem operation/method
 */
if ($create->CreateBudgetItem(new \StructType\CreateBudgetItem()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateUser operation/method
 */
if ($create->CreateUser(new \StructType\CreateUser()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateSurveyAnswer operation/method
 */
if ($create->CreateSurveyAnswer(new \StructType\CreateSurveyAnswer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePostEventFeedback operation/method
 */
if ($create->CreatePostEventFeedback(new \StructType\CreatePostEventFeedback()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateNoRegEvent operation/method
 */
if ($create->CreateNoRegEvent(new \StructType\CreateNoRegEvent()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateRateHistory operation/method
 */
if ($create->CreateRateHistory(new \StructType\CreateRateHistory()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateTransaction operation/method
 */
if ($create->CreateTransaction(new \StructType\CreateTransaction()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateRFP operation/method
 */
if ($create->CreateRFP(new \StructType\CreateRFP()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateConversionRate operation/method
 */
if ($create->CreateConversionRate(new \StructType\CreateConversionRate()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateSession operation/method
 */
if ($create->CreateSession(new \StructType\CreateSession()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateMeetingRequest operation/method
 */
if ($create->CreateMeetingRequest(new \StructType\CreateMeetingRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCustomField operation/method
 */
if ($create->CreateCustomField(new \StructType\CreateCustomField()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for UpdateContact operation/method
 */
if ($update->UpdateContact(new \StructType\UpdateContact()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateInviteeInternalInfo operation/method
 */
if ($update->UpdateInviteeInternalInfo(new \StructType\UpdateInviteeInternalInfo()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateApprover operation/method
 */
if ($update->UpdateApprover(new \StructType\UpdateApprover()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateUser operation/method
 */
if ($update->UpdateUser(new \StructType\UpdateUser()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSession operation/method
 */
if ($update->UpdateSession(new \StructType\UpdateSession()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateEventParameters operation/method
 */
if ($update->UpdateEventParameters(new \StructType\UpdateEventParameters()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateMeetingRequest operation/method
 */
if ($update->UpdateMeetingRequest(new \StructType\UpdateMeetingRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomField operation/method
 */
if ($update->UpdateCustomField(new \StructType\UpdateCustomField()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateRegistrationType operation/method
 */
if ($update->UpdateRegistrationType(new \StructType\UpdateRegistrationType()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateGuestInfo operation/method
 */
if ($update->UpdateGuestInfo(new \StructType\UpdateGuestInfo()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Upsert ServiceType
 */
$upsert = new \ServiceType\Upsert($options);
$upsert->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for UpsertContact operation/method
 */
if ($upsert->UpsertContact(new \StructType\UpsertContact()) !== false) {
    print_r($upsert->getResult());
} else {
    print_r($upsert->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
$delete->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for DeleteContact operation/method
 */
if ($delete->DeleteContact(new \StructType\DeleteContact()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteApprover operation/method
 */
if ($delete->DeleteApprover(new \StructType\DeleteApprover()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteBudgetItem operation/method
 */
if ($delete->DeleteBudgetItem(new \StructType\DeleteBudgetItem()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteUser operation/method
 */
if ($delete->DeleteUser(new \StructType\DeleteUser()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteRateHistory operation/method
 */
if ($delete->DeleteRateHistory(new \StructType\DeleteRateHistory()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteConversionRate operation/method
 */
if ($delete->DeleteConversionRate(new \StructType\DeleteConversionRate()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Manage ServiceType
 */
$manage = new \ServiceType\Manage($options);
$manage->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for ManageContactGroupMembers operation/method
 */
if ($manage->ManageContactGroupMembers(new \StructType\ManageContactGroupMembers()) !== false) {
    print_r($manage->getResult());
} else {
    print_r($manage->getLastError());
}
/**
 * Sample call for ManageDistributionListMembers operation/method
 */
if ($manage->ManageDistributionListMembers(new \StructType\ManageDistributionListMembers()) !== false) {
    print_r($manage->getResult());
} else {
    print_r($manage->getLastError());
}
/**
 * Sample call for ManageUserGroup operation/method
 */
if ($manage->ManageUserGroup(new \StructType\ManageUserGroup()) !== false) {
    print_r($manage->getResult());
} else {
    print_r($manage->getLastError());
}
/**
 * Samples for Transfer ServiceType
 */
$transfer = new \ServiceType\Transfer($options);
$transfer->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for TransferInvitee operation/method
 */
if ($transfer->TransferInvitee(new \StructType\TransferInvitee()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
$check->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for CheckIn operation/method
 */
if ($check->CheckIn(new \StructType\CheckIn()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Simple ServiceType
 */
$simple = new \ServiceType\Simple($options);
$simple->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for SimpleEventRegistration operation/method
 */
if ($simple->SimpleEventRegistration(new \StructType\SimpleEventRegistration()) !== false) {
    print_r($simple->getResult());
} else {
    print_r($simple->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
$send->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for SendEmail operation/method
 */
if ($send->SendEmail(new \StructType\SendEmail()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Copy ServiceType
 */
$copy = new \ServiceType\Copy($options);
$copy->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for CopyEvent operation/method
 */
if ($copy->CopyEvent(new \StructType\CopyEvent()) !== false) {
    print_r($copy->getResult());
} else {
    print_r($copy->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
$validate->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for ValidateInvitee operation/method
 */
if ($validate->ValidateInvitee(new \StructType\ValidateInvitee()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Session ServiceType
 */
$session = new \ServiceType\Session($options);
$session->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for SessionRegAction operation/method
 */
if ($session->SessionRegAction(new \StructType\SessionRegAction()) !== false) {
    print_r($session->getResult());
} else {
    print_r($session->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderCventSessionHeader(new \StructType\CventSessionHeader());
/**
 * Sample call for AddAdvancedLogic operation/method
 */
if ($add->AddAdvancedLogic(new \StructType\AddAdvancedLogic()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
