<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VisibilityDefaults StructType
 * @subpackage Structs
 */
class VisibilityDefaults extends AbstractStructBase
{
    /**
     * The UserGroupName
     * @var string
     */
    public $UserGroupName;
    /**
     * The VisibilityType
     * @var string
     */
    public $VisibilityType;
    /**
     * The UserGroupId
     * @var string
     */
    public $UserGroupId;
    /**
     * Constructor method for VisibilityDefaults
     * @uses VisibilityDefaults::setUserGroupName()
     * @uses VisibilityDefaults::setVisibilityType()
     * @uses VisibilityDefaults::setUserGroupId()
     * @param string $userGroupName
     * @param string $visibilityType
     * @param string $userGroupId
     */
    public function __construct($userGroupName = null, $visibilityType = null, $userGroupId = null)
    {
        $this
            ->setUserGroupName($userGroupName)
            ->setVisibilityType($visibilityType)
            ->setUserGroupId($userGroupId);
    }
    /**
     * Get UserGroupName value
     * @return string|null
     */
    public function getUserGroupName()
    {
        return $this->UserGroupName;
    }
    /**
     * Set UserGroupName value
     * @param string $userGroupName
     * @return \StructType\VisibilityDefaults
     */
    public function setUserGroupName($userGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($userGroupName) && !is_string($userGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userGroupName, true), gettype($userGroupName)), __LINE__);
        }
        $this->UserGroupName = $userGroupName;
        return $this;
    }
    /**
     * Get VisibilityType value
     * @return string|null
     */
    public function getVisibilityType()
    {
        return $this->VisibilityType;
    }
    /**
     * Set VisibilityType value
     * @uses \EnumType\CvVisibilityType::valueIsValid()
     * @uses \EnumType\CvVisibilityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $visibilityType
     * @return \StructType\VisibilityDefaults
     */
    public function setVisibilityType($visibilityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CvVisibilityType::valueIsValid($visibilityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CvVisibilityType', is_array($visibilityType) ? implode(', ', $visibilityType) : var_export($visibilityType, true), implode(', ', \EnumType\CvVisibilityType::getValidValues())), __LINE__);
        }
        $this->VisibilityType = $visibilityType;
        return $this;
    }
    /**
     * Get UserGroupId value
     * @return string|null
     */
    public function getUserGroupId()
    {
        return $this->UserGroupId;
    }
    /**
     * Set UserGroupId value
     * @param string $userGroupId
     * @return \StructType\VisibilityDefaults
     */
    public function setUserGroupId($userGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($userGroupId) && !is_string($userGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userGroupId, true), gettype($userGroupId)), __LINE__);
        }
        $this->UserGroupId = $userGroupId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VisibilityDefaults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
