<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateInviteeResult StructType
 * Meta informations extracted from the WSDL
 * - type: s1:ValidateInviteeResultArray
 * @subpackage Structs
 */
class ValidateInviteeResult extends AbstractStructBase
{
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfError
     */
    public $Errors;
    /**
     * The ReferenceId
     * @var string
     */
    public $ReferenceId;
    /**
     * The InviteeID
     * @var string
     */
    public $InviteeID;
    /**
     * The Registered
     * @var bool
     */
    public $Registered;
    /**
     * The PaidInFull
     * @var bool
     */
    public $PaidInFull;
    /**
     * The CheckedIn
     * @var bool
     */
    public $CheckedIn;
    /**
     * The Success
     * @var bool
     */
    public $Success;
    /**
     * Constructor method for ValidateInviteeResult
     * @uses ValidateInviteeResult::setErrors()
     * @uses ValidateInviteeResult::setReferenceId()
     * @uses ValidateInviteeResult::setInviteeID()
     * @uses ValidateInviteeResult::setRegistered()
     * @uses ValidateInviteeResult::setPaidInFull()
     * @uses ValidateInviteeResult::setCheckedIn()
     * @uses ValidateInviteeResult::setSuccess()
     * @param \ArrayType\ArrayOfError $errors
     * @param string $referenceId
     * @param string $inviteeID
     * @param bool $registered
     * @param bool $paidInFull
     * @param bool $checkedIn
     * @param bool $success
     */
    public function __construct(\ArrayType\ArrayOfError $errors = null, $referenceId = null, $inviteeID = null, $registered = null, $paidInFull = null, $checkedIn = null, $success = null)
    {
        $this
            ->setErrors($errors)
            ->setReferenceId($referenceId)
            ->setInviteeID($inviteeID)
            ->setRegistered($registered)
            ->setPaidInFull($paidInFull)
            ->setCheckedIn($checkedIn)
            ->setSuccess($success);
    }
    /**
     * Get Errors value
     * @return \ArrayType\ArrayOfError|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \ArrayType\ArrayOfError $errors
     * @return \StructType\ValidateInviteeResult
     */
    public function setErrors(\ArrayType\ArrayOfError $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get ReferenceId value
     * @return string|null
     */
    public function getReferenceId()
    {
        return $this->ReferenceId;
    }
    /**
     * Set ReferenceId value
     * @param string $referenceId
     * @return \StructType\ValidateInviteeResult
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        $this->ReferenceId = $referenceId;
        return $this;
    }
    /**
     * Get InviteeID value
     * @return string|null
     */
    public function getInviteeID()
    {
        return $this->InviteeID;
    }
    /**
     * Set InviteeID value
     * @param string $inviteeID
     * @return \StructType\ValidateInviteeResult
     */
    public function setInviteeID($inviteeID = null)
    {
        // validation for constraint: string
        if (!is_null($inviteeID) && !is_string($inviteeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inviteeID, true), gettype($inviteeID)), __LINE__);
        }
        $this->InviteeID = $inviteeID;
        return $this;
    }
    /**
     * Get Registered value
     * @return bool|null
     */
    public function getRegistered()
    {
        return $this->Registered;
    }
    /**
     * Set Registered value
     * @param bool $registered
     * @return \StructType\ValidateInviteeResult
     */
    public function setRegistered($registered = null)
    {
        // validation for constraint: boolean
        if (!is_null($registered) && !is_bool($registered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($registered, true), gettype($registered)), __LINE__);
        }
        $this->Registered = $registered;
        return $this;
    }
    /**
     * Get PaidInFull value
     * @return bool|null
     */
    public function getPaidInFull()
    {
        return $this->PaidInFull;
    }
    /**
     * Set PaidInFull value
     * @param bool $paidInFull
     * @return \StructType\ValidateInviteeResult
     */
    public function setPaidInFull($paidInFull = null)
    {
        // validation for constraint: boolean
        if (!is_null($paidInFull) && !is_bool($paidInFull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paidInFull, true), gettype($paidInFull)), __LINE__);
        }
        $this->PaidInFull = $paidInFull;
        return $this;
    }
    /**
     * Get CheckedIn value
     * @return bool|null
     */
    public function getCheckedIn()
    {
        return $this->CheckedIn;
    }
    /**
     * Set CheckedIn value
     * @param bool $checkedIn
     * @return \StructType\ValidateInviteeResult
     */
    public function setCheckedIn($checkedIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkedIn) && !is_bool($checkedIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checkedIn, true), gettype($checkedIn)), __LINE__);
        }
        $this->CheckedIn = $checkedIn;
        return $this;
    }
    /**
     * Get Success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \StructType\ValidateInviteeResult
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidateInviteeResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
