<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateInvitee StructType
 * @subpackage Structs
 */
class ValidateInvitee extends AbstractStructBase
{
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProductType;
    /**
     * The CheckPaidInFull
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CheckPaidInFull;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductID;
    /**
     * The CvInvitees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCvInvitee
     */
    public $CvInvitees;
    /**
     * Constructor method for ValidateInvitee
     * @uses ValidateInvitee::setProductType()
     * @uses ValidateInvitee::setCheckPaidInFull()
     * @uses ValidateInvitee::setProductID()
     * @uses ValidateInvitee::setCvInvitees()
     * @param string $productType
     * @param bool $checkPaidInFull
     * @param string $productID
     * @param \ArrayType\ArrayOfCvInvitee $cvInvitees
     */
    public function __construct($productType = null, $checkPaidInFull = null, $productID = null, \ArrayType\ArrayOfCvInvitee $cvInvitees = null)
    {
        $this
            ->setProductType($productType)
            ->setCheckPaidInFull($checkPaidInFull)
            ->setProductID($productID)
            ->setCvInvitees($cvInvitees);
    }
    /**
     * Get ProductType value
     * @return string
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\ProductType::valueIsValid()
     * @uses \EnumType\ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\ValidateInvitee
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductType', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \EnumType\ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get CheckPaidInFull value
     * @return bool
     */
    public function getCheckPaidInFull()
    {
        return $this->CheckPaidInFull;
    }
    /**
     * Set CheckPaidInFull value
     * @param bool $checkPaidInFull
     * @return \StructType\ValidateInvitee
     */
    public function setCheckPaidInFull($checkPaidInFull = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkPaidInFull) && !is_bool($checkPaidInFull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checkPaidInFull, true), gettype($checkPaidInFull)), __LINE__);
        }
        $this->CheckPaidInFull = $checkPaidInFull;
        return $this;
    }
    /**
     * Get ProductID value
     * @return string|null
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param string $productID
     * @return \StructType\ValidateInvitee
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: string
        if (!is_null($productID) && !is_string($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productID, true), gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get CvInvitees value
     * @return \ArrayType\ArrayOfCvInvitee|null
     */
    public function getCvInvitees()
    {
        return $this->CvInvitees;
    }
    /**
     * Set CvInvitees value
     * @param \ArrayType\ArrayOfCvInvitee $cvInvitees
     * @return \StructType\ValidateInvitee
     */
    public function setCvInvitees(\ArrayType\ArrayOfCvInvitee $cvInvitees = null)
    {
        $this->CvInvitees = $cvInvitees;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidateInvitee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
