<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserRole StructType
 * @subpackage Structs
 */
class UserRole extends CvObject
{
    /**
     * The UserRights
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UserRights[]
     */
    public $UserRights;
    /**
     * The UserRoleName
     * @var string
     */
    public $UserRoleName;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * Constructor method for UserRole
     * @uses UserRole::setUserRights()
     * @uses UserRole::setUserRoleName()
     * @uses UserRole::setDescription()
     * @param \StructType\UserRights[] $userRights
     * @param string $userRoleName
     * @param string $description
     */
    public function __construct(array $userRights = array(), $userRoleName = null, $description = null)
    {
        $this
            ->setUserRights($userRights)
            ->setUserRoleName($userRoleName)
            ->setDescription($description);
    }
    /**
     * Get UserRights value
     * @return \StructType\UserRights[]|null
     */
    public function getUserRights()
    {
        return $this->UserRights;
    }
    /**
     * This method is responsible for validating the values passed to the setUserRights method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserRights method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserRightsForArrayConstraintsFromSetUserRights(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $userRoleUserRightsItem) {
            // validation for constraint: itemType
            if (!$userRoleUserRightsItem instanceof \StructType\UserRights) {
                $invalidValues[] = is_object($userRoleUserRightsItem) ? get_class($userRoleUserRightsItem) : sprintf('%s(%s)', gettype($userRoleUserRightsItem), var_export($userRoleUserRightsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserRights property can only contain items of type \StructType\UserRights, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserRights value
     * @throws \InvalidArgumentException
     * @param \StructType\UserRights[] $userRights
     * @return \StructType\UserRole
     */
    public function setUserRights(array $userRights = array())
    {
        // validation for constraint: array
        if ('' !== ($userRightsArrayErrorMessage = self::validateUserRightsForArrayConstraintsFromSetUserRights($userRights))) {
            throw new \InvalidArgumentException($userRightsArrayErrorMessage, __LINE__);
        }
        $this->UserRights = $userRights;
        return $this;
    }
    /**
     * Add item to UserRights value
     * @throws \InvalidArgumentException
     * @param \StructType\UserRights $item
     * @return \StructType\UserRole
     */
    public function addToUserRights(\StructType\UserRights $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserRights) {
            throw new \InvalidArgumentException(sprintf('The UserRights property can only contain items of type \StructType\UserRights, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserRights[] = $item;
        return $this;
    }
    /**
     * Get UserRoleName value
     * @return string|null
     */
    public function getUserRoleName()
    {
        return $this->UserRoleName;
    }
    /**
     * Set UserRoleName value
     * @param string $userRoleName
     * @return \StructType\UserRole
     */
    public function setUserRoleName($userRoleName = null)
    {
        // validation for constraint: string
        if (!is_null($userRoleName) && !is_string($userRoleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userRoleName, true), gettype($userRoleName)), __LINE__);
        }
        $this->UserRoleName = $userRoleName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\UserRole
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserRole
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
