<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserRights StructType
 * @subpackage Structs
 */
class UserRights extends AbstractStructBase
{
    /**
     * The UserRightName
     * @var string
     */
    public $UserRightName;
    /**
     * The UserRightCategory
     * @var string
     */
    public $UserRightCategory;
    /**
     * The AccessLevel
     * @var string
     */
    public $AccessLevel;
    /**
     * Constructor method for UserRights
     * @uses UserRights::setUserRightName()
     * @uses UserRights::setUserRightCategory()
     * @uses UserRights::setAccessLevel()
     * @param string $userRightName
     * @param string $userRightCategory
     * @param string $accessLevel
     */
    public function __construct($userRightName = null, $userRightCategory = null, $accessLevel = null)
    {
        $this
            ->setUserRightName($userRightName)
            ->setUserRightCategory($userRightCategory)
            ->setAccessLevel($accessLevel);
    }
    /**
     * Get UserRightName value
     * @return string|null
     */
    public function getUserRightName()
    {
        return $this->UserRightName;
    }
    /**
     * Set UserRightName value
     * @param string $userRightName
     * @return \StructType\UserRights
     */
    public function setUserRightName($userRightName = null)
    {
        // validation for constraint: string
        if (!is_null($userRightName) && !is_string($userRightName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userRightName, true), gettype($userRightName)), __LINE__);
        }
        $this->UserRightName = $userRightName;
        return $this;
    }
    /**
     * Get UserRightCategory value
     * @return string|null
     */
    public function getUserRightCategory()
    {
        return $this->UserRightCategory;
    }
    /**
     * Set UserRightCategory value
     * @param string $userRightCategory
     * @return \StructType\UserRights
     */
    public function setUserRightCategory($userRightCategory = null)
    {
        // validation for constraint: string
        if (!is_null($userRightCategory) && !is_string($userRightCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userRightCategory, true), gettype($userRightCategory)), __LINE__);
        }
        $this->UserRightCategory = $userRightCategory;
        return $this;
    }
    /**
     * Get AccessLevel value
     * @return string|null
     */
    public function getAccessLevel()
    {
        return $this->AccessLevel;
    }
    /**
     * Set AccessLevel value
     * @param string $accessLevel
     * @return \StructType\UserRights
     */
    public function setAccessLevel($accessLevel = null)
    {
        // validation for constraint: string
        if (!is_null($accessLevel) && !is_string($accessLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessLevel, true), gettype($accessLevel)), __LINE__);
        }
        $this->AccessLevel = $accessLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserRights
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
