<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserGroup StructType
 * @subpackage Structs
 */
class UserGroup extends CvObject
{
    /**
     * The UserGroupName
     * @var string
     */
    public $UserGroupName;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * Constructor method for UserGroup
     * @uses UserGroup::setUserGroupName()
     * @uses UserGroup::setInternalNote()
     * @param string $userGroupName
     * @param string $internalNote
     */
    public function __construct($userGroupName = null, $internalNote = null)
    {
        $this
            ->setUserGroupName($userGroupName)
            ->setInternalNote($internalNote);
    }
    /**
     * Get UserGroupName value
     * @return string|null
     */
    public function getUserGroupName()
    {
        return $this->UserGroupName;
    }
    /**
     * Set UserGroupName value
     * @param string $userGroupName
     * @return \StructType\UserGroup
     */
    public function setUserGroupName($userGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($userGroupName) && !is_string($userGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userGroupName, true), gettype($userGroupName)), __LINE__);
        }
        $this->UserGroupName = $userGroupName;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\UserGroup
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
