<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for User StructType
 * @subpackage Structs
 */
class User extends CvObject
{
    /**
     * The CustomFieldDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldDetail[]
     */
    public $CustomFieldDetail;
    /**
     * The UserGroupDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UserGroupDetail[]
     */
    public $UserGroupDetail;
    /**
     * The VisibilityDefaults
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VisibilityDefaults[]
     */
    public $VisibilityDefaults;
    /**
     * The Active
     * @var bool
     */
    public $Active;
    /**
     * The Address1
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * @var string
     */
    public $Address2;
    /**
     * The Address3
     * @var string
     */
    public $Address3;
    /**
     * The AllEventVisibility
     * @var bool
     */
    public $AllEventVisibility;
    /**
     * The AllRFPVisibility
     * @var bool
     */
    public $AllRFPVisibility;
    /**
     * The AllSurveyVisibility
     * @var bool
     */
    public $AllSurveyVisibility;
    /**
     * The ChangePasswordOnLogin
     * @var bool
     */
    public $ChangePasswordOnLogin;
    /**
     * The City
     * @var string
     */
    public $City;
    /**
     * The Company
     * @var string
     */
    public $Company;
    /**
     * The Country
     * @var string
     */
    public $Country;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * The CreatedBy
     * @var string
     */
    public $CreatedBy;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The DefaultContactGroupId
     * @var string
     */
    public $DefaultContactGroupId;
    /**
     * The Email
     * @var string
     */
    public $Email;
    /**
     * The FederatedId
     * @var string
     */
    public $FederatedId;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The HomeFax
     * @var string
     */
    public $HomeFax;
    /**
     * The HomePhone
     * @var string
     */
    public $HomePhone;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The MobilePhone
     * @var string
     */
    public $MobilePhone;
    /**
     * The Pager
     * @var string
     */
    public $Pager;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * The PostalCode
     * @var string
     */
    public $PostalCode;
    /**
     * The Prefix
     * @var string
     */
    public $Prefix;
    /**
     * The State
     * @var string
     */
    public $State;
    /**
     * The StateCode
     * @var string
     */
    public $StateCode;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The Username
     * @var string
     */
    public $Username;
    /**
     * The UserType
     * @var string
     */
    public $UserType;
    /**
     * The UserRole
     * @var string
     */
    public $UserRole;
    /**
     * The UserRoleId
     * @var string
     */
    public $UserRoleId;
    /**
     * The WorkFax
     * @var string
     */
    public $WorkFax;
    /**
     * The WorkPhone
     * @var string
     */
    public $WorkPhone;
    /**
     * The LastLoginDate
     * @var string
     */
    public $LastLoginDate;
    /**
     * Constructor method for User
     * @uses User::setCustomFieldDetail()
     * @uses User::setUserGroupDetail()
     * @uses User::setVisibilityDefaults()
     * @uses User::setActive()
     * @uses User::setAddress1()
     * @uses User::setAddress2()
     * @uses User::setAddress3()
     * @uses User::setAllEventVisibility()
     * @uses User::setAllRFPVisibility()
     * @uses User::setAllSurveyVisibility()
     * @uses User::setChangePasswordOnLogin()
     * @uses User::setCity()
     * @uses User::setCompany()
     * @uses User::setCountry()
     * @uses User::setCountryCode()
     * @uses User::setCreatedBy()
     * @uses User::setCreatedDate()
     * @uses User::setDefaultContactGroupId()
     * @uses User::setEmail()
     * @uses User::setFederatedId()
     * @uses User::setFirstName()
     * @uses User::setHomeFax()
     * @uses User::setHomePhone()
     * @uses User::setLastModifiedBy()
     * @uses User::setLastModifiedDate()
     * @uses User::setLastName()
     * @uses User::setMobilePhone()
     * @uses User::setPager()
     * @uses User::setPassword()
     * @uses User::setPostalCode()
     * @uses User::setPrefix()
     * @uses User::setState()
     * @uses User::setStateCode()
     * @uses User::setTitle()
     * @uses User::setUsername()
     * @uses User::setUserType()
     * @uses User::setUserRole()
     * @uses User::setUserRoleId()
     * @uses User::setWorkFax()
     * @uses User::setWorkPhone()
     * @uses User::setLastLoginDate()
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @param \StructType\UserGroupDetail[] $userGroupDetail
     * @param \StructType\VisibilityDefaults[] $visibilityDefaults
     * @param bool $active
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param bool $allEventVisibility
     * @param bool $allRFPVisibility
     * @param bool $allSurveyVisibility
     * @param bool $changePasswordOnLogin
     * @param string $city
     * @param string $company
     * @param string $country
     * @param string $countryCode
     * @param string $createdBy
     * @param string $createdDate
     * @param string $defaultContactGroupId
     * @param string $email
     * @param string $federatedId
     * @param string $firstName
     * @param string $homeFax
     * @param string $homePhone
     * @param string $lastModifiedBy
     * @param string $lastModifiedDate
     * @param string $lastName
     * @param string $mobilePhone
     * @param string $pager
     * @param string $password
     * @param string $postalCode
     * @param string $prefix
     * @param string $state
     * @param string $stateCode
     * @param string $title
     * @param string $username
     * @param string $userType
     * @param string $userRole
     * @param string $userRoleId
     * @param string $workFax
     * @param string $workPhone
     * @param string $lastLoginDate
     */
    public function __construct(array $customFieldDetail = array(), array $userGroupDetail = array(), array $visibilityDefaults = array(), $active = null, $address1 = null, $address2 = null, $address3 = null, $allEventVisibility = null, $allRFPVisibility = null, $allSurveyVisibility = null, $changePasswordOnLogin = null, $city = null, $company = null, $country = null, $countryCode = null, $createdBy = null, $createdDate = null, $defaultContactGroupId = null, $email = null, $federatedId = null, $firstName = null, $homeFax = null, $homePhone = null, $lastModifiedBy = null, $lastModifiedDate = null, $lastName = null, $mobilePhone = null, $pager = null, $password = null, $postalCode = null, $prefix = null, $state = null, $stateCode = null, $title = null, $username = null, $userType = null, $userRole = null, $userRoleId = null, $workFax = null, $workPhone = null, $lastLoginDate = null)
    {
        $this
            ->setCustomFieldDetail($customFieldDetail)
            ->setUserGroupDetail($userGroupDetail)
            ->setVisibilityDefaults($visibilityDefaults)
            ->setActive($active)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setAllEventVisibility($allEventVisibility)
            ->setAllRFPVisibility($allRFPVisibility)
            ->setAllSurveyVisibility($allSurveyVisibility)
            ->setChangePasswordOnLogin($changePasswordOnLogin)
            ->setCity($city)
            ->setCompany($company)
            ->setCountry($country)
            ->setCountryCode($countryCode)
            ->setCreatedBy($createdBy)
            ->setCreatedDate($createdDate)
            ->setDefaultContactGroupId($defaultContactGroupId)
            ->setEmail($email)
            ->setFederatedId($federatedId)
            ->setFirstName($firstName)
            ->setHomeFax($homeFax)
            ->setHomePhone($homePhone)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastName($lastName)
            ->setMobilePhone($mobilePhone)
            ->setPager($pager)
            ->setPassword($password)
            ->setPostalCode($postalCode)
            ->setPrefix($prefix)
            ->setState($state)
            ->setStateCode($stateCode)
            ->setTitle($title)
            ->setUsername($username)
            ->setUserType($userType)
            ->setUserRole($userRole)
            ->setUserRoleId($userRoleId)
            ->setWorkFax($workFax)
            ->setWorkPhone($workPhone)
            ->setLastLoginDate($lastLoginDate);
    }
    /**
     * Get CustomFieldDetail value
     * @return \StructType\CustomFieldDetail[]|null
     */
    public function getCustomFieldDetail()
    {
        return $this->CustomFieldDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomFieldDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomFieldDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $userCustomFieldDetailItem) {
            // validation for constraint: itemType
            if (!$userCustomFieldDetailItem instanceof \StructType\CustomFieldDetail) {
                $invalidValues[] = is_object($userCustomFieldDetailItem) ? get_class($userCustomFieldDetailItem) : sprintf('%s(%s)', gettype($userCustomFieldDetailItem), var_export($userCustomFieldDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @return \StructType\User
     */
    public function setCustomFieldDetail(array $customFieldDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldDetailArrayErrorMessage = self::validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail($customFieldDetail))) {
            throw new \InvalidArgumentException($customFieldDetailArrayErrorMessage, __LINE__);
        }
        $this->CustomFieldDetail = $customFieldDetail;
        return $this;
    }
    /**
     * Add item to CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail $item
     * @return \StructType\User
     */
    public function addToCustomFieldDetail(\StructType\CustomFieldDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomFieldDetail[] = $item;
        return $this;
    }
    /**
     * Get UserGroupDetail value
     * @return \StructType\UserGroupDetail[]|null
     */
    public function getUserGroupDetail()
    {
        return $this->UserGroupDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setUserGroupDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserGroupDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserGroupDetailForArrayConstraintsFromSetUserGroupDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $userUserGroupDetailItem) {
            // validation for constraint: itemType
            if (!$userUserGroupDetailItem instanceof \StructType\UserGroupDetail) {
                $invalidValues[] = is_object($userUserGroupDetailItem) ? get_class($userUserGroupDetailItem) : sprintf('%s(%s)', gettype($userUserGroupDetailItem), var_export($userUserGroupDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserGroupDetail property can only contain items of type \StructType\UserGroupDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserGroupDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\UserGroupDetail[] $userGroupDetail
     * @return \StructType\User
     */
    public function setUserGroupDetail(array $userGroupDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($userGroupDetailArrayErrorMessage = self::validateUserGroupDetailForArrayConstraintsFromSetUserGroupDetail($userGroupDetail))) {
            throw new \InvalidArgumentException($userGroupDetailArrayErrorMessage, __LINE__);
        }
        $this->UserGroupDetail = $userGroupDetail;
        return $this;
    }
    /**
     * Add item to UserGroupDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\UserGroupDetail $item
     * @return \StructType\User
     */
    public function addToUserGroupDetail(\StructType\UserGroupDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserGroupDetail) {
            throw new \InvalidArgumentException(sprintf('The UserGroupDetail property can only contain items of type \StructType\UserGroupDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserGroupDetail[] = $item;
        return $this;
    }
    /**
     * Get VisibilityDefaults value
     * @return \StructType\VisibilityDefaults[]|null
     */
    public function getVisibilityDefaults()
    {
        return $this->VisibilityDefaults;
    }
    /**
     * This method is responsible for validating the values passed to the setVisibilityDefaults method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVisibilityDefaults method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVisibilityDefaultsForArrayConstraintsFromSetVisibilityDefaults(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $userVisibilityDefaultsItem) {
            // validation for constraint: itemType
            if (!$userVisibilityDefaultsItem instanceof \StructType\VisibilityDefaults) {
                $invalidValues[] = is_object($userVisibilityDefaultsItem) ? get_class($userVisibilityDefaultsItem) : sprintf('%s(%s)', gettype($userVisibilityDefaultsItem), var_export($userVisibilityDefaultsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VisibilityDefaults property can only contain items of type \StructType\VisibilityDefaults, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VisibilityDefaults value
     * @throws \InvalidArgumentException
     * @param \StructType\VisibilityDefaults[] $visibilityDefaults
     * @return \StructType\User
     */
    public function setVisibilityDefaults(array $visibilityDefaults = array())
    {
        // validation for constraint: array
        if ('' !== ($visibilityDefaultsArrayErrorMessage = self::validateVisibilityDefaultsForArrayConstraintsFromSetVisibilityDefaults($visibilityDefaults))) {
            throw new \InvalidArgumentException($visibilityDefaultsArrayErrorMessage, __LINE__);
        }
        $this->VisibilityDefaults = $visibilityDefaults;
        return $this;
    }
    /**
     * Add item to VisibilityDefaults value
     * @throws \InvalidArgumentException
     * @param \StructType\VisibilityDefaults $item
     * @return \StructType\User
     */
    public function addToVisibilityDefaults(\StructType\VisibilityDefaults $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VisibilityDefaults) {
            throw new \InvalidArgumentException(sprintf('The VisibilityDefaults property can only contain items of type \StructType\VisibilityDefaults, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VisibilityDefaults[] = $item;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\User
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\User
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\User
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get Address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->Address3;
    }
    /**
     * Set Address3 value
     * @param string $address3
     * @return \StructType\User
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address3, true), gettype($address3)), __LINE__);
        }
        $this->Address3 = $address3;
        return $this;
    }
    /**
     * Get AllEventVisibility value
     * @return bool|null
     */
    public function getAllEventVisibility()
    {
        return $this->AllEventVisibility;
    }
    /**
     * Set AllEventVisibility value
     * @param bool $allEventVisibility
     * @return \StructType\User
     */
    public function setAllEventVisibility($allEventVisibility = null)
    {
        // validation for constraint: boolean
        if (!is_null($allEventVisibility) && !is_bool($allEventVisibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allEventVisibility, true), gettype($allEventVisibility)), __LINE__);
        }
        $this->AllEventVisibility = $allEventVisibility;
        return $this;
    }
    /**
     * Get AllRFPVisibility value
     * @return bool|null
     */
    public function getAllRFPVisibility()
    {
        return $this->AllRFPVisibility;
    }
    /**
     * Set AllRFPVisibility value
     * @param bool $allRFPVisibility
     * @return \StructType\User
     */
    public function setAllRFPVisibility($allRFPVisibility = null)
    {
        // validation for constraint: boolean
        if (!is_null($allRFPVisibility) && !is_bool($allRFPVisibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allRFPVisibility, true), gettype($allRFPVisibility)), __LINE__);
        }
        $this->AllRFPVisibility = $allRFPVisibility;
        return $this;
    }
    /**
     * Get AllSurveyVisibility value
     * @return bool|null
     */
    public function getAllSurveyVisibility()
    {
        return $this->AllSurveyVisibility;
    }
    /**
     * Set AllSurveyVisibility value
     * @param bool $allSurveyVisibility
     * @return \StructType\User
     */
    public function setAllSurveyVisibility($allSurveyVisibility = null)
    {
        // validation for constraint: boolean
        if (!is_null($allSurveyVisibility) && !is_bool($allSurveyVisibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allSurveyVisibility, true), gettype($allSurveyVisibility)), __LINE__);
        }
        $this->AllSurveyVisibility = $allSurveyVisibility;
        return $this;
    }
    /**
     * Get ChangePasswordOnLogin value
     * @return bool|null
     */
    public function getChangePasswordOnLogin()
    {
        return $this->ChangePasswordOnLogin;
    }
    /**
     * Set ChangePasswordOnLogin value
     * @param bool $changePasswordOnLogin
     * @return \StructType\User
     */
    public function setChangePasswordOnLogin($changePasswordOnLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($changePasswordOnLogin) && !is_bool($changePasswordOnLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($changePasswordOnLogin, true), gettype($changePasswordOnLogin)), __LINE__);
        }
        $this->ChangePasswordOnLogin = $changePasswordOnLogin;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\User
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\User
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\User
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\User
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param string $createdBy
     * @return \StructType\User
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\User
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get DefaultContactGroupId value
     * @return string|null
     */
    public function getDefaultContactGroupId()
    {
        return $this->DefaultContactGroupId;
    }
    /**
     * Set DefaultContactGroupId value
     * @param string $defaultContactGroupId
     * @return \StructType\User
     */
    public function setDefaultContactGroupId($defaultContactGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultContactGroupId) && !is_string($defaultContactGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultContactGroupId, true), gettype($defaultContactGroupId)), __LINE__);
        }
        $this->DefaultContactGroupId = $defaultContactGroupId;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\User
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get FederatedId value
     * @return string|null
     */
    public function getFederatedId()
    {
        return $this->FederatedId;
    }
    /**
     * Set FederatedId value
     * @param string $federatedId
     * @return \StructType\User
     */
    public function setFederatedId($federatedId = null)
    {
        // validation for constraint: string
        if (!is_null($federatedId) && !is_string($federatedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($federatedId, true), gettype($federatedId)), __LINE__);
        }
        $this->FederatedId = $federatedId;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\User
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get HomeFax value
     * @return string|null
     */
    public function getHomeFax()
    {
        return $this->HomeFax;
    }
    /**
     * Set HomeFax value
     * @param string $homeFax
     * @return \StructType\User
     */
    public function setHomeFax($homeFax = null)
    {
        // validation for constraint: string
        if (!is_null($homeFax) && !is_string($homeFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeFax, true), gettype($homeFax)), __LINE__);
        }
        $this->HomeFax = $homeFax;
        return $this;
    }
    /**
     * Get HomePhone value
     * @return string|null
     */
    public function getHomePhone()
    {
        return $this->HomePhone;
    }
    /**
     * Set HomePhone value
     * @param string $homePhone
     * @return \StructType\User
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        $this->HomePhone = $homePhone;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\User
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\User
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\User
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get MobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->MobilePhone;
    }
    /**
     * Set MobilePhone value
     * @param string $mobilePhone
     * @return \StructType\User
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        $this->MobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get Pager value
     * @return string|null
     */
    public function getPager()
    {
        return $this->Pager;
    }
    /**
     * Set Pager value
     * @param string $pager
     * @return \StructType\User
     */
    public function setPager($pager = null)
    {
        // validation for constraint: string
        if (!is_null($pager) && !is_string($pager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pager, true), gettype($pager)), __LINE__);
        }
        $this->Pager = $pager;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\User
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\User
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->Prefix;
    }
    /**
     * Set Prefix value
     * @param string $prefix
     * @return \StructType\User
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefix, true), gettype($prefix)), __LINE__);
        }
        $this->Prefix = $prefix;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\User
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \StructType\User
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateCode, true), gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\User
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\User
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get UserType value
     * @return string|null
     */
    public function getUserType()
    {
        return $this->UserType;
    }
    /**
     * Set UserType value
     * @uses \EnumType\CvUserType::valueIsValid()
     * @uses \EnumType\CvUserType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userType
     * @return \StructType\User
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CvUserType::valueIsValid($userType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CvUserType', is_array($userType) ? implode(', ', $userType) : var_export($userType, true), implode(', ', \EnumType\CvUserType::getValidValues())), __LINE__);
        }
        $this->UserType = $userType;
        return $this;
    }
    /**
     * Get UserRole value
     * @return string|null
     */
    public function getUserRole()
    {
        return $this->UserRole;
    }
    /**
     * Set UserRole value
     * @param string $userRole
     * @return \StructType\User
     */
    public function setUserRole($userRole = null)
    {
        // validation for constraint: string
        if (!is_null($userRole) && !is_string($userRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userRole, true), gettype($userRole)), __LINE__);
        }
        $this->UserRole = $userRole;
        return $this;
    }
    /**
     * Get UserRoleId value
     * @return string|null
     */
    public function getUserRoleId()
    {
        return $this->UserRoleId;
    }
    /**
     * Set UserRoleId value
     * @param string $userRoleId
     * @return \StructType\User
     */
    public function setUserRoleId($userRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($userRoleId) && !is_string($userRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userRoleId, true), gettype($userRoleId)), __LINE__);
        }
        $this->UserRoleId = $userRoleId;
        return $this;
    }
    /**
     * Get WorkFax value
     * @return string|null
     */
    public function getWorkFax()
    {
        return $this->WorkFax;
    }
    /**
     * Set WorkFax value
     * @param string $workFax
     * @return \StructType\User
     */
    public function setWorkFax($workFax = null)
    {
        // validation for constraint: string
        if (!is_null($workFax) && !is_string($workFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workFax, true), gettype($workFax)), __LINE__);
        }
        $this->WorkFax = $workFax;
        return $this;
    }
    /**
     * Get WorkPhone value
     * @return string|null
     */
    public function getWorkPhone()
    {
        return $this->WorkPhone;
    }
    /**
     * Set WorkPhone value
     * @param string $workPhone
     * @return \StructType\User
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPhone, true), gettype($workPhone)), __LINE__);
        }
        $this->WorkPhone = $workPhone;
        return $this;
    }
    /**
     * Get LastLoginDate value
     * @return string|null
     */
    public function getLastLoginDate()
    {
        return $this->LastLoginDate;
    }
    /**
     * Set LastLoginDate value
     * @param string $lastLoginDate
     * @return \StructType\User
     */
    public function setLastLoginDate($lastLoginDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastLoginDate) && !is_string($lastLoginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastLoginDate, true), gettype($lastLoginDate)), __LINE__);
        }
        $this->LastLoginDate = $lastLoginDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\User
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
