<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateGuestInfo StructType
 * @subpackage Structs
 */
class UpdateGuestInfo extends AbstractStructBase
{
    /**
     * The EventId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventId;
    /**
     * The Guests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGuest
     */
    public $Guests;
    /**
     * Constructor method for UpdateGuestInfo
     * @uses UpdateGuestInfo::setEventId()
     * @uses UpdateGuestInfo::setGuests()
     * @param string $eventId
     * @param \ArrayType\ArrayOfGuest $guests
     */
    public function __construct($eventId = null, \ArrayType\ArrayOfGuest $guests = null)
    {
        $this
            ->setEventId($eventId)
            ->setGuests($guests);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\UpdateGuestInfo
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get Guests value
     * @return \ArrayType\ArrayOfGuest|null
     */
    public function getGuests()
    {
        return $this->Guests;
    }
    /**
     * Set Guests value
     * @param \ArrayType\ArrayOfGuest $guests
     * @return \StructType\UpdateGuestInfo
     */
    public function setGuests(\ArrayType\ArrayOfGuest $guests = null)
    {
        $this->Guests = $guests;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateGuestInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
