<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel StructType
 * @subpackage Structs
 */
class Travel extends CvObject
{
    /**
     * The HotelRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelRequest[]
     */
    public $HotelRequest;
    /**
     * The CarRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CarRequest[]
     */
    public $CarRequest;
    /**
     * The AirRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirRequest[]
     */
    public $AirRequest;
    /**
     * The AirActual
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirActual[]
     */
    public $AirActual;
    /**
     * The ContactId
     * @var string
     */
    public $ContactId;
    /**
     * The SourceId
     * @var string
     */
    public $SourceId;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The Company
     * @var string
     */
    public $Company;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The EmailAddress
     * @var string
     */
    public $EmailAddress;
    /**
     * The CCEmailAddress
     * @var string
     */
    public $CCEmailAddress;
    /**
     * The WorkPhone
     * @var string
     */
    public $WorkPhone;
    /**
     * The EventId
     * @var string
     */
    public $EventId;
    /**
     * The EventCode
     * @var string
     */
    public $EventCode;
    /**
     * The EventTitle
     * @var string
     */
    public $EventTitle;
    /**
     * The EventStartDate
     * @var string
     */
    public $EventStartDate;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The RegistrationType
     * @var string
     */
    public $RegistrationType;
    /**
     * Constructor method for Travel
     * @uses Travel::setHotelRequest()
     * @uses Travel::setCarRequest()
     * @uses Travel::setAirRequest()
     * @uses Travel::setAirActual()
     * @uses Travel::setContactId()
     * @uses Travel::setSourceId()
     * @uses Travel::setFirstName()
     * @uses Travel::setLastName()
     * @uses Travel::setCompany()
     * @uses Travel::setTitle()
     * @uses Travel::setEmailAddress()
     * @uses Travel::setCCEmailAddress()
     * @uses Travel::setWorkPhone()
     * @uses Travel::setEventId()
     * @uses Travel::setEventCode()
     * @uses Travel::setEventTitle()
     * @uses Travel::setEventStartDate()
     * @uses Travel::setStatus()
     * @uses Travel::setRegistrationType()
     * @param \StructType\HotelRequest[] $hotelRequest
     * @param \StructType\CarRequest[] $carRequest
     * @param \StructType\AirRequest[] $airRequest
     * @param \StructType\AirActual[] $airActual
     * @param string $contactId
     * @param string $sourceId
     * @param string $firstName
     * @param string $lastName
     * @param string $company
     * @param string $title
     * @param string $emailAddress
     * @param string $cCEmailAddress
     * @param string $workPhone
     * @param string $eventId
     * @param string $eventCode
     * @param string $eventTitle
     * @param string $eventStartDate
     * @param string $status
     * @param string $registrationType
     */
    public function __construct(array $hotelRequest = array(), array $carRequest = array(), array $airRequest = array(), array $airActual = array(), $contactId = null, $sourceId = null, $firstName = null, $lastName = null, $company = null, $title = null, $emailAddress = null, $cCEmailAddress = null, $workPhone = null, $eventId = null, $eventCode = null, $eventTitle = null, $eventStartDate = null, $status = null, $registrationType = null)
    {
        $this
            ->setHotelRequest($hotelRequest)
            ->setCarRequest($carRequest)
            ->setAirRequest($airRequest)
            ->setAirActual($airActual)
            ->setContactId($contactId)
            ->setSourceId($sourceId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCompany($company)
            ->setTitle($title)
            ->setEmailAddress($emailAddress)
            ->setCCEmailAddress($cCEmailAddress)
            ->setWorkPhone($workPhone)
            ->setEventId($eventId)
            ->setEventCode($eventCode)
            ->setEventTitle($eventTitle)
            ->setEventStartDate($eventStartDate)
            ->setStatus($status)
            ->setRegistrationType($registrationType);
    }
    /**
     * Get HotelRequest value
     * @return \StructType\HotelRequest[]|null
     */
    public function getHotelRequest()
    {
        return $this->HotelRequest;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelRequestForArrayConstraintsFromSetHotelRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelHotelRequestItem) {
            // validation for constraint: itemType
            if (!$travelHotelRequestItem instanceof \StructType\HotelRequest) {
                $invalidValues[] = is_object($travelHotelRequestItem) ? get_class($travelHotelRequestItem) : sprintf('%s(%s)', gettype($travelHotelRequestItem), var_export($travelHotelRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelRequest property can only contain items of type \StructType\HotelRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelRequest[] $hotelRequest
     * @return \StructType\Travel
     */
    public function setHotelRequest(array $hotelRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelRequestArrayErrorMessage = self::validateHotelRequestForArrayConstraintsFromSetHotelRequest($hotelRequest))) {
            throw new \InvalidArgumentException($hotelRequestArrayErrorMessage, __LINE__);
        }
        $this->HotelRequest = $hotelRequest;
        return $this;
    }
    /**
     * Add item to HotelRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelRequest $item
     * @return \StructType\Travel
     */
    public function addToHotelRequest(\StructType\HotelRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelRequest) {
            throw new \InvalidArgumentException(sprintf('The HotelRequest property can only contain items of type \StructType\HotelRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelRequest[] = $item;
        return $this;
    }
    /**
     * Get CarRequest value
     * @return \StructType\CarRequest[]|null
     */
    public function getCarRequest()
    {
        return $this->CarRequest;
    }
    /**
     * This method is responsible for validating the values passed to the setCarRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarRequestForArrayConstraintsFromSetCarRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelCarRequestItem) {
            // validation for constraint: itemType
            if (!$travelCarRequestItem instanceof \StructType\CarRequest) {
                $invalidValues[] = is_object($travelCarRequestItem) ? get_class($travelCarRequestItem) : sprintf('%s(%s)', gettype($travelCarRequestItem), var_export($travelCarRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CarRequest property can only contain items of type \StructType\CarRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CarRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\CarRequest[] $carRequest
     * @return \StructType\Travel
     */
    public function setCarRequest(array $carRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($carRequestArrayErrorMessage = self::validateCarRequestForArrayConstraintsFromSetCarRequest($carRequest))) {
            throw new \InvalidArgumentException($carRequestArrayErrorMessage, __LINE__);
        }
        $this->CarRequest = $carRequest;
        return $this;
    }
    /**
     * Add item to CarRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\CarRequest $item
     * @return \StructType\Travel
     */
    public function addToCarRequest(\StructType\CarRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CarRequest) {
            throw new \InvalidArgumentException(sprintf('The CarRequest property can only contain items of type \StructType\CarRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CarRequest[] = $item;
        return $this;
    }
    /**
     * Get AirRequest value
     * @return \StructType\AirRequest[]|null
     */
    public function getAirRequest()
    {
        return $this->AirRequest;
    }
    /**
     * This method is responsible for validating the values passed to the setAirRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirRequestForArrayConstraintsFromSetAirRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelAirRequestItem) {
            // validation for constraint: itemType
            if (!$travelAirRequestItem instanceof \StructType\AirRequest) {
                $invalidValues[] = is_object($travelAirRequestItem) ? get_class($travelAirRequestItem) : sprintf('%s(%s)', gettype($travelAirRequestItem), var_export($travelAirRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirRequest property can only contain items of type \StructType\AirRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\AirRequest[] $airRequest
     * @return \StructType\Travel
     */
    public function setAirRequest(array $airRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($airRequestArrayErrorMessage = self::validateAirRequestForArrayConstraintsFromSetAirRequest($airRequest))) {
            throw new \InvalidArgumentException($airRequestArrayErrorMessage, __LINE__);
        }
        $this->AirRequest = $airRequest;
        return $this;
    }
    /**
     * Add item to AirRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\AirRequest $item
     * @return \StructType\Travel
     */
    public function addToAirRequest(\StructType\AirRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirRequest) {
            throw new \InvalidArgumentException(sprintf('The AirRequest property can only contain items of type \StructType\AirRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirRequest[] = $item;
        return $this;
    }
    /**
     * Get AirActual value
     * @return \StructType\AirActual[]|null
     */
    public function getAirActual()
    {
        return $this->AirActual;
    }
    /**
     * This method is responsible for validating the values passed to the setAirActual method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirActual method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirActualForArrayConstraintsFromSetAirActual(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelAirActualItem) {
            // validation for constraint: itemType
            if (!$travelAirActualItem instanceof \StructType\AirActual) {
                $invalidValues[] = is_object($travelAirActualItem) ? get_class($travelAirActualItem) : sprintf('%s(%s)', gettype($travelAirActualItem), var_export($travelAirActualItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirActual property can only contain items of type \StructType\AirActual, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirActual value
     * @throws \InvalidArgumentException
     * @param \StructType\AirActual[] $airActual
     * @return \StructType\Travel
     */
    public function setAirActual(array $airActual = array())
    {
        // validation for constraint: array
        if ('' !== ($airActualArrayErrorMessage = self::validateAirActualForArrayConstraintsFromSetAirActual($airActual))) {
            throw new \InvalidArgumentException($airActualArrayErrorMessage, __LINE__);
        }
        $this->AirActual = $airActual;
        return $this;
    }
    /**
     * Add item to AirActual value
     * @throws \InvalidArgumentException
     * @param \StructType\AirActual $item
     * @return \StructType\Travel
     */
    public function addToAirActual(\StructType\AirActual $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirActual) {
            throw new \InvalidArgumentException(sprintf('The AirActual property can only contain items of type \StructType\AirActual, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirActual[] = $item;
        return $this;
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \StructType\Travel
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get SourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->SourceId;
    }
    /**
     * Set SourceId value
     * @param string $sourceId
     * @return \StructType\Travel
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        $this->SourceId = $sourceId;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Travel
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Travel
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\Travel
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Travel
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\Travel
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get CCEmailAddress value
     * @return string|null
     */
    public function getCCEmailAddress()
    {
        return $this->CCEmailAddress;
    }
    /**
     * Set CCEmailAddress value
     * @param string $cCEmailAddress
     * @return \StructType\Travel
     */
    public function setCCEmailAddress($cCEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($cCEmailAddress) && !is_string($cCEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCEmailAddress, true), gettype($cCEmailAddress)), __LINE__);
        }
        $this->CCEmailAddress = $cCEmailAddress;
        return $this;
    }
    /**
     * Get WorkPhone value
     * @return string|null
     */
    public function getWorkPhone()
    {
        return $this->WorkPhone;
    }
    /**
     * Set WorkPhone value
     * @param string $workPhone
     * @return \StructType\Travel
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPhone, true), gettype($workPhone)), __LINE__);
        }
        $this->WorkPhone = $workPhone;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\Travel
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\Travel
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get EventTitle value
     * @return string|null
     */
    public function getEventTitle()
    {
        return $this->EventTitle;
    }
    /**
     * Set EventTitle value
     * @param string $eventTitle
     * @return \StructType\Travel
     */
    public function setEventTitle($eventTitle = null)
    {
        // validation for constraint: string
        if (!is_null($eventTitle) && !is_string($eventTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTitle, true), gettype($eventTitle)), __LINE__);
        }
        $this->EventTitle = $eventTitle;
        return $this;
    }
    /**
     * Get EventStartDate value
     * @return string|null
     */
    public function getEventStartDate()
    {
        return $this->EventStartDate;
    }
    /**
     * Set EventStartDate value
     * @param string $eventStartDate
     * @return \StructType\Travel
     */
    public function setEventStartDate($eventStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventStartDate) && !is_string($eventStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStartDate, true), gettype($eventStartDate)), __LINE__);
        }
        $this->EventStartDate = $eventStartDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\Travel
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get RegistrationType value
     * @return string|null
     */
    public function getRegistrationType()
    {
        return $this->RegistrationType;
    }
    /**
     * Set RegistrationType value
     * @param string $registrationType
     * @return \StructType\Travel
     */
    public function setRegistrationType($registrationType = null)
    {
        // validation for constraint: string
        if (!is_null($registrationType) && !is_string($registrationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationType, true), gettype($registrationType)), __LINE__);
        }
        $this->RegistrationType = $registrationType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Travel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
