<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferInviteeResult StructType
 * Meta informations extracted from the WSDL
 * - type: s1:TransferInviteeResultArray
 * @subpackage Structs
 */
class TransferInviteeResult extends AbstractStructBase
{
    /**
     * The WeblinkDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WeblinkDetail[]
     */
    public $WeblinkDetail;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfError
     */
    public $Errors;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The Success
     * @var bool
     */
    public $Success;
    /**
     * The ReferenceId
     * @var string
     */
    public $ReferenceId;
    /**
     * Constructor method for TransferInviteeResult
     * @uses TransferInviteeResult::setWeblinkDetail()
     * @uses TransferInviteeResult::setErrors()
     * @uses TransferInviteeResult::setId()
     * @uses TransferInviteeResult::setSuccess()
     * @uses TransferInviteeResult::setReferenceId()
     * @param \StructType\WeblinkDetail[] $weblinkDetail
     * @param \ArrayType\ArrayOfError $errors
     * @param string $id
     * @param bool $success
     * @param string $referenceId
     */
    public function __construct(array $weblinkDetail = array(), \ArrayType\ArrayOfError $errors = null, $id = null, $success = null, $referenceId = null)
    {
        $this
            ->setWeblinkDetail($weblinkDetail)
            ->setErrors($errors)
            ->setId($id)
            ->setSuccess($success)
            ->setReferenceId($referenceId);
    }
    /**
     * Get WeblinkDetail value
     * @return \StructType\WeblinkDetail[]|null
     */
    public function getWeblinkDetail()
    {
        return $this->WeblinkDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setWeblinkDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeblinkDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeblinkDetailForArrayConstraintsFromSetWeblinkDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transferInviteeResultWeblinkDetailItem) {
            // validation for constraint: itemType
            if (!$transferInviteeResultWeblinkDetailItem instanceof \StructType\WeblinkDetail) {
                $invalidValues[] = is_object($transferInviteeResultWeblinkDetailItem) ? get_class($transferInviteeResultWeblinkDetailItem) : sprintf('%s(%s)', gettype($transferInviteeResultWeblinkDetailItem), var_export($transferInviteeResultWeblinkDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WeblinkDetail property can only contain items of type \StructType\WeblinkDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WeblinkDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\WeblinkDetail[] $weblinkDetail
     * @return \StructType\TransferInviteeResult
     */
    public function setWeblinkDetail(array $weblinkDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($weblinkDetailArrayErrorMessage = self::validateWeblinkDetailForArrayConstraintsFromSetWeblinkDetail($weblinkDetail))) {
            throw new \InvalidArgumentException($weblinkDetailArrayErrorMessage, __LINE__);
        }
        $this->WeblinkDetail = $weblinkDetail;
        return $this;
    }
    /**
     * Add item to WeblinkDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\WeblinkDetail $item
     * @return \StructType\TransferInviteeResult
     */
    public function addToWeblinkDetail(\StructType\WeblinkDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WeblinkDetail) {
            throw new \InvalidArgumentException(sprintf('The WeblinkDetail property can only contain items of type \StructType\WeblinkDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WeblinkDetail[] = $item;
        return $this;
    }
    /**
     * Get Errors value
     * @return \ArrayType\ArrayOfError|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \ArrayType\ArrayOfError $errors
     * @return \StructType\TransferInviteeResult
     */
    public function setErrors(\ArrayType\ArrayOfError $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\TransferInviteeResult
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \StructType\TransferInviteeResult
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ReferenceId value
     * @return string|null
     */
    public function getReferenceId()
    {
        return $this->ReferenceId;
    }
    /**
     * Set ReferenceId value
     * @param string $referenceId
     * @return \StructType\TransferInviteeResult
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        $this->ReferenceId = $referenceId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransferInviteeResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
