<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferInvitee StructType
 * @subpackage Structs
 */
class TransferInvitee extends AbstractStructBase
{
    /**
     * The ActivityType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ActivityType;
    /**
     * The ActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityId;
    /**
     * The TargetedListId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TargetedListId;
    /**
     * The CvObjects
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s1:CvObjects
     * @var \ArrayType\CvObjectArray
     */
    public $CvObjects;
    /**
     * Constructor method for TransferInvitee
     * @uses TransferInvitee::setActivityType()
     * @uses TransferInvitee::setActivityId()
     * @uses TransferInvitee::setTargetedListId()
     * @uses TransferInvitee::setCvObjects()
     * @param string $activityType
     * @param string $activityId
     * @param string $targetedListId
     * @param \ArrayType\CvObjectArray $cvObjects
     */
    public function __construct($activityType = null, $activityId = null, $targetedListId = null, \ArrayType\CvObjectArray $cvObjects = null)
    {
        $this
            ->setActivityType($activityType)
            ->setActivityId($activityId)
            ->setTargetedListId($targetedListId)
            ->setCvObjects($cvObjects);
    }
    /**
     * Get ActivityType value
     * @return string
     */
    public function getActivityType()
    {
        return $this->ActivityType;
    }
    /**
     * Set ActivityType value
     * @uses \EnumType\ActivityType::valueIsValid()
     * @uses \EnumType\ActivityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activityType
     * @return \StructType\TransferInvitee
     */
    public function setActivityType($activityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActivityType::valueIsValid($activityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActivityType', is_array($activityType) ? implode(', ', $activityType) : var_export($activityType, true), implode(', ', \EnumType\ActivityType::getValidValues())), __LINE__);
        }
        $this->ActivityType = $activityType;
        return $this;
    }
    /**
     * Get ActivityId value
     * @return string|null
     */
    public function getActivityId()
    {
        return $this->ActivityId;
    }
    /**
     * Set ActivityId value
     * @param string $activityId
     * @return \StructType\TransferInvitee
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityId, true), gettype($activityId)), __LINE__);
        }
        $this->ActivityId = $activityId;
        return $this;
    }
    /**
     * Get TargetedListId value
     * @return string|null
     */
    public function getTargetedListId()
    {
        return $this->TargetedListId;
    }
    /**
     * Set TargetedListId value
     * @param string $targetedListId
     * @return \StructType\TransferInvitee
     */
    public function setTargetedListId($targetedListId = null)
    {
        // validation for constraint: string
        if (!is_null($targetedListId) && !is_string($targetedListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetedListId, true), gettype($targetedListId)), __LINE__);
        }
        $this->TargetedListId = $targetedListId;
        return $this;
    }
    /**
     * Get CvObjects value
     * @return \ArrayType\CvObjectArray|null
     */
    public function getCvObjects()
    {
        return $this->CvObjects;
    }
    /**
     * Set CvObjects value
     * @param \ArrayType\CvObjectArray $cvObjects
     * @return \StructType\TransferInvitee
     */
    public function setCvObjects(\ArrayType\CvObjectArray $cvObjects = null)
    {
        $this->CvObjects = $cvObjects;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransferInvitee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
