<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transaction StructType
 * @subpackage Structs
 */
class Transaction extends CvObject
{
    /**
     * The TransactionType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $TransactionType;
    /**
     * The DistributionDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DistributionDetail[]
     */
    public $DistributionDetail;
    /**
     * The ContactId
     * @var string
     */
    public $ContactId;
    /**
     * The InviteeId
     * @var string
     */
    public $InviteeId;
    /**
     * The SourceId
     * @var string
     */
    public $SourceId;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The Company
     * @var string
     */
    public $Company;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The EmailAddress
     * @var string
     */
    public $EmailAddress;
    /**
     * The WorkPhone
     * @var string
     */
    public $WorkPhone;
    /**
     * The EventId
     * @var string
     */
    public $EventId;
    /**
     * The EventCode
     * @var string
     */
    public $EventCode;
    /**
     * The EventTitle
     * @var string
     */
    public $EventTitle;
    /**
     * The EventStartDate
     * @var string
     */
    public $EventStartDate;
    /**
     * The Success
     * @var bool
     */
    public $Success;
    /**
     * The TransactionNumber
     * @var string
     */
    public $TransactionNumber;
    /**
     * The PaymentType
     * @var string
     */
    public $PaymentType;
    /**
     * The NameOnCard
     * @var string
     */
    public $NameOnCard;
    /**
     * The ReferenceNumber
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The BatchNumber
     * @var string
     */
    public $BatchNumber;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The PaidInFull
     * @var bool
     */
    public $PaidInFull;
    /**
     * The TransactionDate
     * @var string
     */
    public $TransactionDate;
    /**
     * The Note
     * @var string
     */
    public $Note;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The ModifiedBy
     * @var string
     */
    public $ModifiedBy;
    /**
     * The AuthorizationCode
     * @var string
     */
    public $AuthorizationCode;
    /**
     * Constructor method for Transaction
     * @uses Transaction::setTransactionType()
     * @uses Transaction::setDistributionDetail()
     * @uses Transaction::setContactId()
     * @uses Transaction::setInviteeId()
     * @uses Transaction::setSourceId()
     * @uses Transaction::setFirstName()
     * @uses Transaction::setLastName()
     * @uses Transaction::setCompany()
     * @uses Transaction::setTitle()
     * @uses Transaction::setEmailAddress()
     * @uses Transaction::setWorkPhone()
     * @uses Transaction::setEventId()
     * @uses Transaction::setEventCode()
     * @uses Transaction::setEventTitle()
     * @uses Transaction::setEventStartDate()
     * @uses Transaction::setSuccess()
     * @uses Transaction::setTransactionNumber()
     * @uses Transaction::setPaymentType()
     * @uses Transaction::setNameOnCard()
     * @uses Transaction::setReferenceNumber()
     * @uses Transaction::setBatchNumber()
     * @uses Transaction::setAmount()
     * @uses Transaction::setPaidInFull()
     * @uses Transaction::setTransactionDate()
     * @uses Transaction::setNote()
     * @uses Transaction::setLastModifiedDate()
     * @uses Transaction::setModifiedBy()
     * @uses Transaction::setAuthorizationCode()
     * @param string $transactionType
     * @param \StructType\DistributionDetail[] $distributionDetail
     * @param string $contactId
     * @param string $inviteeId
     * @param string $sourceId
     * @param string $firstName
     * @param string $lastName
     * @param string $company
     * @param string $title
     * @param string $emailAddress
     * @param string $workPhone
     * @param string $eventId
     * @param string $eventCode
     * @param string $eventTitle
     * @param string $eventStartDate
     * @param bool $success
     * @param string $transactionNumber
     * @param string $paymentType
     * @param string $nameOnCard
     * @param string $referenceNumber
     * @param string $batchNumber
     * @param float $amount
     * @param bool $paidInFull
     * @param string $transactionDate
     * @param string $note
     * @param string $lastModifiedDate
     * @param string $modifiedBy
     * @param string $authorizationCode
     */
    public function __construct($transactionType = null, array $distributionDetail = array(), $contactId = null, $inviteeId = null, $sourceId = null, $firstName = null, $lastName = null, $company = null, $title = null, $emailAddress = null, $workPhone = null, $eventId = null, $eventCode = null, $eventTitle = null, $eventStartDate = null, $success = null, $transactionNumber = null, $paymentType = null, $nameOnCard = null, $referenceNumber = null, $batchNumber = null, $amount = null, $paidInFull = null, $transactionDate = null, $note = null, $lastModifiedDate = null, $modifiedBy = null, $authorizationCode = null)
    {
        $this
            ->setTransactionType($transactionType)
            ->setDistributionDetail($distributionDetail)
            ->setContactId($contactId)
            ->setInviteeId($inviteeId)
            ->setSourceId($sourceId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCompany($company)
            ->setTitle($title)
            ->setEmailAddress($emailAddress)
            ->setWorkPhone($workPhone)
            ->setEventId($eventId)
            ->setEventCode($eventCode)
            ->setEventTitle($eventTitle)
            ->setEventStartDate($eventStartDate)
            ->setSuccess($success)
            ->setTransactionNumber($transactionNumber)
            ->setPaymentType($paymentType)
            ->setNameOnCard($nameOnCard)
            ->setReferenceNumber($referenceNumber)
            ->setBatchNumber($batchNumber)
            ->setAmount($amount)
            ->setPaidInFull($paidInFull)
            ->setTransactionDate($transactionDate)
            ->setNote($note)
            ->setLastModifiedDate($lastModifiedDate)
            ->setModifiedBy($modifiedBy)
            ->setAuthorizationCode($authorizationCode);
    }
    /**
     * Get TransactionType value
     * @return string
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @uses \EnumType\TransactionType::valueIsValid()
     * @uses \EnumType\TransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \StructType\Transaction
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionType::valueIsValid($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionType', is_array($transactionType) ? implode(', ', $transactionType) : var_export($transactionType, true), implode(', ', \EnumType\TransactionType::getValidValues())), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Get DistributionDetail value
     * @return \StructType\DistributionDetail[]|null
     */
    public function getDistributionDetail()
    {
        return $this->DistributionDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setDistributionDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDistributionDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDistributionDetailForArrayConstraintsFromSetDistributionDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transactionDistributionDetailItem) {
            // validation for constraint: itemType
            if (!$transactionDistributionDetailItem instanceof \StructType\DistributionDetail) {
                $invalidValues[] = is_object($transactionDistributionDetailItem) ? get_class($transactionDistributionDetailItem) : sprintf('%s(%s)', gettype($transactionDistributionDetailItem), var_export($transactionDistributionDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DistributionDetail property can only contain items of type \StructType\DistributionDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DistributionDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DistributionDetail[] $distributionDetail
     * @return \StructType\Transaction
     */
    public function setDistributionDetail(array $distributionDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($distributionDetailArrayErrorMessage = self::validateDistributionDetailForArrayConstraintsFromSetDistributionDetail($distributionDetail))) {
            throw new \InvalidArgumentException($distributionDetailArrayErrorMessage, __LINE__);
        }
        $this->DistributionDetail = $distributionDetail;
        return $this;
    }
    /**
     * Add item to DistributionDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DistributionDetail $item
     * @return \StructType\Transaction
     */
    public function addToDistributionDetail(\StructType\DistributionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DistributionDetail) {
            throw new \InvalidArgumentException(sprintf('The DistributionDetail property can only contain items of type \StructType\DistributionDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DistributionDetail[] = $item;
        return $this;
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \StructType\Transaction
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get InviteeId value
     * @return string|null
     */
    public function getInviteeId()
    {
        return $this->InviteeId;
    }
    /**
     * Set InviteeId value
     * @param string $inviteeId
     * @return \StructType\Transaction
     */
    public function setInviteeId($inviteeId = null)
    {
        // validation for constraint: string
        if (!is_null($inviteeId) && !is_string($inviteeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inviteeId, true), gettype($inviteeId)), __LINE__);
        }
        $this->InviteeId = $inviteeId;
        return $this;
    }
    /**
     * Get SourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->SourceId;
    }
    /**
     * Set SourceId value
     * @param string $sourceId
     * @return \StructType\Transaction
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        $this->SourceId = $sourceId;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Transaction
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Transaction
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\Transaction
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Transaction
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\Transaction
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get WorkPhone value
     * @return string|null
     */
    public function getWorkPhone()
    {
        return $this->WorkPhone;
    }
    /**
     * Set WorkPhone value
     * @param string $workPhone
     * @return \StructType\Transaction
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPhone, true), gettype($workPhone)), __LINE__);
        }
        $this->WorkPhone = $workPhone;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\Transaction
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\Transaction
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get EventTitle value
     * @return string|null
     */
    public function getEventTitle()
    {
        return $this->EventTitle;
    }
    /**
     * Set EventTitle value
     * @param string $eventTitle
     * @return \StructType\Transaction
     */
    public function setEventTitle($eventTitle = null)
    {
        // validation for constraint: string
        if (!is_null($eventTitle) && !is_string($eventTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTitle, true), gettype($eventTitle)), __LINE__);
        }
        $this->EventTitle = $eventTitle;
        return $this;
    }
    /**
     * Get EventStartDate value
     * @return string|null
     */
    public function getEventStartDate()
    {
        return $this->EventStartDate;
    }
    /**
     * Set EventStartDate value
     * @param string $eventStartDate
     * @return \StructType\Transaction
     */
    public function setEventStartDate($eventStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventStartDate) && !is_string($eventStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStartDate, true), gettype($eventStartDate)), __LINE__);
        }
        $this->EventStartDate = $eventStartDate;
        return $this;
    }
    /**
     * Get Success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \StructType\Transaction
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get TransactionNumber value
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return $this->TransactionNumber;
    }
    /**
     * Set TransactionNumber value
     * @param string $transactionNumber
     * @return \StructType\Transaction
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        $this->TransactionNumber = $transactionNumber;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \StructType\Transaction
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get NameOnCard value
     * @return string|null
     */
    public function getNameOnCard()
    {
        return $this->NameOnCard;
    }
    /**
     * Set NameOnCard value
     * @param string $nameOnCard
     * @return \StructType\Transaction
     */
    public function setNameOnCard($nameOnCard = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnCard) && !is_string($nameOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameOnCard, true), gettype($nameOnCard)), __LINE__);
        }
        $this->NameOnCard = $nameOnCard;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\Transaction
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get BatchNumber value
     * @return string|null
     */
    public function getBatchNumber()
    {
        return $this->BatchNumber;
    }
    /**
     * Set BatchNumber value
     * @param string $batchNumber
     * @return \StructType\Transaction
     */
    public function setBatchNumber($batchNumber = null)
    {
        // validation for constraint: string
        if (!is_null($batchNumber) && !is_string($batchNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchNumber, true), gettype($batchNumber)), __LINE__);
        }
        $this->BatchNumber = $batchNumber;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Transaction
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PaidInFull value
     * @return bool|null
     */
    public function getPaidInFull()
    {
        return $this->PaidInFull;
    }
    /**
     * Set PaidInFull value
     * @param bool $paidInFull
     * @return \StructType\Transaction
     */
    public function setPaidInFull($paidInFull = null)
    {
        // validation for constraint: boolean
        if (!is_null($paidInFull) && !is_bool($paidInFull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paidInFull, true), gettype($paidInFull)), __LINE__);
        }
        $this->PaidInFull = $paidInFull;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \StructType\Transaction
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \StructType\Transaction
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Transaction
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get ModifiedBy value
     * @return string|null
     */
    public function getModifiedBy()
    {
        return $this->ModifiedBy;
    }
    /**
     * Set ModifiedBy value
     * @param string $modifiedBy
     * @return \StructType\Transaction
     */
    public function setModifiedBy($modifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedBy) && !is_string($modifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedBy, true), gettype($modifiedBy)), __LINE__);
        }
        $this->ModifiedBy = $modifiedBy;
        return $this;
    }
    /**
     * Get AuthorizationCode value
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return $this->AuthorizationCode;
    }
    /**
     * Set AuthorizationCode value
     * @param string $authorizationCode
     * @return \StructType\Transaction
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCode, true), gettype($authorizationCode)), __LINE__);
        }
        $this->AuthorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Transaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
