<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxDetail StructType
 * @subpackage Structs
 */
class TaxDetail extends AbstractStructBase
{
    /**
     * The TaxId
     * @var string
     */
    public $TaxId;
    /**
     * The Tax
     * @var float
     */
    public $Tax;
    /**
     * The TaxType
     * @var string
     */
    public $TaxType;
    /**
     * The TaxName
     * @var string
     */
    public $TaxName;
    /**
     * Constructor method for TaxDetail
     * @uses TaxDetail::setTaxId()
     * @uses TaxDetail::setTax()
     * @uses TaxDetail::setTaxType()
     * @uses TaxDetail::setTaxName()
     * @param string $taxId
     * @param float $tax
     * @param string $taxType
     * @param string $taxName
     */
    public function __construct($taxId = null, $tax = null, $taxType = null, $taxName = null)
    {
        $this
            ->setTaxId($taxId)
            ->setTax($tax)
            ->setTaxType($taxType)
            ->setTaxName($taxName);
    }
    /**
     * Get TaxId value
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->TaxId;
    }
    /**
     * Set TaxId value
     * @param string $taxId
     * @return \StructType\TaxDetail
     */
    public function setTaxId($taxId = null)
    {
        // validation for constraint: string
        if (!is_null($taxId) && !is_string($taxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxId, true), gettype($taxId)), __LINE__);
        }
        $this->TaxId = $taxId;
        return $this;
    }
    /**
     * Get Tax value
     * @return float|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param float $tax
     * @return \StructType\TaxDetail
     */
    public function setTax($tax = null)
    {
        // validation for constraint: float
        if (!is_null($tax) && !(is_float($tax) || is_numeric($tax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax, true), gettype($tax)), __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get TaxType value
     * @return string|null
     */
    public function getTaxType()
    {
        return $this->TaxType;
    }
    /**
     * Set TaxType value
     * @param string $taxType
     * @return \StructType\TaxDetail
     */
    public function setTaxType($taxType = null)
    {
        // validation for constraint: string
        if (!is_null($taxType) && !is_string($taxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxType, true), gettype($taxType)), __LINE__);
        }
        $this->TaxType = $taxType;
        return $this;
    }
    /**
     * Get TaxName value
     * @return string|null
     */
    public function getTaxName()
    {
        return $this->TaxName;
    }
    /**
     * Set TaxName value
     * @param string $taxName
     * @return \StructType\TaxDetail
     */
    public function setTaxName($taxName = null)
    {
        // validation for constraint: string
        if (!is_null($taxName) && !is_string($taxName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxName, true), gettype($taxName)), __LINE__);
        }
        $this->TaxName = $taxName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
