<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetListDetail StructType
 * @subpackage Structs
 */
class TargetListDetail extends AbstractStructBase
{
    /**
     * The TargetedListId
     * @var string
     */
    public $TargetedListId;
    /**
     * The TargetedListName
     * @var string
     */
    public $TargetedListName;
    /**
     * The TargetedListLanguage
     * @var string
     */
    public $TargetedListLanguage;
    /**
     * The TargetedListDefault
     * @var bool
     */
    public $TargetedListDefault;
    /**
     * Constructor method for TargetListDetail
     * @uses TargetListDetail::setTargetedListId()
     * @uses TargetListDetail::setTargetedListName()
     * @uses TargetListDetail::setTargetedListLanguage()
     * @uses TargetListDetail::setTargetedListDefault()
     * @param string $targetedListId
     * @param string $targetedListName
     * @param string $targetedListLanguage
     * @param bool $targetedListDefault
     */
    public function __construct($targetedListId = null, $targetedListName = null, $targetedListLanguage = null, $targetedListDefault = null)
    {
        $this
            ->setTargetedListId($targetedListId)
            ->setTargetedListName($targetedListName)
            ->setTargetedListLanguage($targetedListLanguage)
            ->setTargetedListDefault($targetedListDefault);
    }
    /**
     * Get TargetedListId value
     * @return string|null
     */
    public function getTargetedListId()
    {
        return $this->TargetedListId;
    }
    /**
     * Set TargetedListId value
     * @param string $targetedListId
     * @return \StructType\TargetListDetail
     */
    public function setTargetedListId($targetedListId = null)
    {
        // validation for constraint: string
        if (!is_null($targetedListId) && !is_string($targetedListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetedListId, true), gettype($targetedListId)), __LINE__);
        }
        $this->TargetedListId = $targetedListId;
        return $this;
    }
    /**
     * Get TargetedListName value
     * @return string|null
     */
    public function getTargetedListName()
    {
        return $this->TargetedListName;
    }
    /**
     * Set TargetedListName value
     * @param string $targetedListName
     * @return \StructType\TargetListDetail
     */
    public function setTargetedListName($targetedListName = null)
    {
        // validation for constraint: string
        if (!is_null($targetedListName) && !is_string($targetedListName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetedListName, true), gettype($targetedListName)), __LINE__);
        }
        $this->TargetedListName = $targetedListName;
        return $this;
    }
    /**
     * Get TargetedListLanguage value
     * @return string|null
     */
    public function getTargetedListLanguage()
    {
        return $this->TargetedListLanguage;
    }
    /**
     * Set TargetedListLanguage value
     * @param string $targetedListLanguage
     * @return \StructType\TargetListDetail
     */
    public function setTargetedListLanguage($targetedListLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($targetedListLanguage) && !is_string($targetedListLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetedListLanguage, true), gettype($targetedListLanguage)), __LINE__);
        }
        $this->TargetedListLanguage = $targetedListLanguage;
        return $this;
    }
    /**
     * Get TargetedListDefault value
     * @return bool|null
     */
    public function getTargetedListDefault()
    {
        return $this->TargetedListDefault;
    }
    /**
     * Set TargetedListDefault value
     * @param bool $targetedListDefault
     * @return \StructType\TargetListDetail
     */
    public function setTargetedListDefault($targetedListDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($targetedListDefault) && !is_bool($targetedListDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($targetedListDefault, true), gettype($targetedListDefault)), __LINE__);
        }
        $this->TargetedListDefault = $targetedListDefault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TargetListDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
