<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TableAssignment StructType
 * @subpackage Structs
 */
class TableAssignment extends CvObject
{
    /**
     * The TableId
     * @var string
     */
    public $TableId;
    /**
     * The TableName
     * @var string
     */
    public $TableName;
    /**
     * The SeatingId
     * @var string
     */
    public $SeatingId;
    /**
     * The SeatingCode
     * @var string
     */
    public $SeatingCode;
    /**
     * The SeatingName
     * @var string
     */
    public $SeatingName;
    /**
     * The EventId
     * @var string
     */
    public $EventId;
    /**
     * The EventTitle
     * @var string
     */
    public $EventTitle;
    /**
     * The EntityId
     * @var string
     */
    public $EntityId;
    /**
     * The EntityType
     * @var string
     */
    public $EntityType;
    /**
     * The SeatName
     * @var string
     */
    public $SeatName;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The Company
     * @var string
     */
    public $Company;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * Constructor method for TableAssignment
     * @uses TableAssignment::setTableId()
     * @uses TableAssignment::setTableName()
     * @uses TableAssignment::setSeatingId()
     * @uses TableAssignment::setSeatingCode()
     * @uses TableAssignment::setSeatingName()
     * @uses TableAssignment::setEventId()
     * @uses TableAssignment::setEventTitle()
     * @uses TableAssignment::setEntityId()
     * @uses TableAssignment::setEntityType()
     * @uses TableAssignment::setSeatName()
     * @uses TableAssignment::setFirstName()
     * @uses TableAssignment::setLastName()
     * @uses TableAssignment::setCompany()
     * @uses TableAssignment::setLastModifiedDate()
     * @param string $tableId
     * @param string $tableName
     * @param string $seatingId
     * @param string $seatingCode
     * @param string $seatingName
     * @param string $eventId
     * @param string $eventTitle
     * @param string $entityId
     * @param string $entityType
     * @param string $seatName
     * @param string $firstName
     * @param string $lastName
     * @param string $company
     * @param string $lastModifiedDate
     */
    public function __construct($tableId = null, $tableName = null, $seatingId = null, $seatingCode = null, $seatingName = null, $eventId = null, $eventTitle = null, $entityId = null, $entityType = null, $seatName = null, $firstName = null, $lastName = null, $company = null, $lastModifiedDate = null)
    {
        $this
            ->setTableId($tableId)
            ->setTableName($tableName)
            ->setSeatingId($seatingId)
            ->setSeatingCode($seatingCode)
            ->setSeatingName($seatingName)
            ->setEventId($eventId)
            ->setEventTitle($eventTitle)
            ->setEntityId($entityId)
            ->setEntityType($entityType)
            ->setSeatName($seatName)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCompany($company)
            ->setLastModifiedDate($lastModifiedDate);
    }
    /**
     * Get TableId value
     * @return string|null
     */
    public function getTableId()
    {
        return $this->TableId;
    }
    /**
     * Set TableId value
     * @param string $tableId
     * @return \StructType\TableAssignment
     */
    public function setTableId($tableId = null)
    {
        // validation for constraint: string
        if (!is_null($tableId) && !is_string($tableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tableId, true), gettype($tableId)), __LINE__);
        }
        $this->TableId = $tableId;
        return $this;
    }
    /**
     * Get TableName value
     * @return string|null
     */
    public function getTableName()
    {
        return $this->TableName;
    }
    /**
     * Set TableName value
     * @param string $tableName
     * @return \StructType\TableAssignment
     */
    public function setTableName($tableName = null)
    {
        // validation for constraint: string
        if (!is_null($tableName) && !is_string($tableName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tableName, true), gettype($tableName)), __LINE__);
        }
        $this->TableName = $tableName;
        return $this;
    }
    /**
     * Get SeatingId value
     * @return string|null
     */
    public function getSeatingId()
    {
        return $this->SeatingId;
    }
    /**
     * Set SeatingId value
     * @param string $seatingId
     * @return \StructType\TableAssignment
     */
    public function setSeatingId($seatingId = null)
    {
        // validation for constraint: string
        if (!is_null($seatingId) && !is_string($seatingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingId, true), gettype($seatingId)), __LINE__);
        }
        $this->SeatingId = $seatingId;
        return $this;
    }
    /**
     * Get SeatingCode value
     * @return string|null
     */
    public function getSeatingCode()
    {
        return $this->SeatingCode;
    }
    /**
     * Set SeatingCode value
     * @param string $seatingCode
     * @return \StructType\TableAssignment
     */
    public function setSeatingCode($seatingCode = null)
    {
        // validation for constraint: string
        if (!is_null($seatingCode) && !is_string($seatingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingCode, true), gettype($seatingCode)), __LINE__);
        }
        $this->SeatingCode = $seatingCode;
        return $this;
    }
    /**
     * Get SeatingName value
     * @return string|null
     */
    public function getSeatingName()
    {
        return $this->SeatingName;
    }
    /**
     * Set SeatingName value
     * @param string $seatingName
     * @return \StructType\TableAssignment
     */
    public function setSeatingName($seatingName = null)
    {
        // validation for constraint: string
        if (!is_null($seatingName) && !is_string($seatingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingName, true), gettype($seatingName)), __LINE__);
        }
        $this->SeatingName = $seatingName;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\TableAssignment
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get EventTitle value
     * @return string|null
     */
    public function getEventTitle()
    {
        return $this->EventTitle;
    }
    /**
     * Set EventTitle value
     * @param string $eventTitle
     * @return \StructType\TableAssignment
     */
    public function setEventTitle($eventTitle = null)
    {
        // validation for constraint: string
        if (!is_null($eventTitle) && !is_string($eventTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTitle, true), gettype($eventTitle)), __LINE__);
        }
        $this->EventTitle = $eventTitle;
        return $this;
    }
    /**
     * Get EntityId value
     * @return string|null
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param string $entityId
     * @return \StructType\TableAssignment
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
    /**
     * Get EntityType value
     * @return string|null
     */
    public function getEntityType()
    {
        return $this->EntityType;
    }
    /**
     * Set EntityType value
     * @param string $entityType
     * @return \StructType\TableAssignment
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        $this->EntityType = $entityType;
        return $this;
    }
    /**
     * Get SeatName value
     * @return string|null
     */
    public function getSeatName()
    {
        return $this->SeatName;
    }
    /**
     * Set SeatName value
     * @param string $seatName
     * @return \StructType\TableAssignment
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        $this->SeatName = $seatName;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\TableAssignment
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\TableAssignment
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\TableAssignment
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\TableAssignment
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TableAssignment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
