<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SurveyQuestion StructType
 * @subpackage Structs
 */
class SurveyQuestion extends CvObject
{
    /**
     * The AnswerDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AnswerDetail[]
     */
    public $AnswerDetail;
    /**
     * The RowDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RowDetail[]
     */
    public $RowDetail;
    /**
     * The QuestionText
     * @var string
     */
    public $QuestionText;
    /**
     * The QuestionHTMLText
     * @var string
     */
    public $QuestionHTMLText;
    /**
     * The QuestionCode
     * @var string
     */
    public $QuestionCode;
    /**
     * The QuestionType
     * @var string
     */
    public $QuestionType;
    /**
     * The SurveyId
     * @var string
     */
    public $SurveyId;
    /**
     * The SurveyCode
     * @var string
     */
    public $SurveyCode;
    /**
     * The SurveyTitle
     * @var string
     */
    public $SurveyTitle;
    /**
     * The QuestionNumber
     * @var string
     */
    public $QuestionNumber;
    /**
     * The MinimumSelections
     * @var string
     */
    public $MinimumSelections;
    /**
     * The MaximumSelections
     * @var string
     */
    public $MaximumSelections;
    /**
     * The MinimumCharacters
     * @var string
     */
    public $MinimumCharacters;
    /**
     * The MaximumCharacters
     * @var string
     */
    public $MaximumCharacters;
    /**
     * The LeftSideHeader
     * @var string
     */
    public $LeftSideHeader;
    /**
     * The RightSideHeader
     * @var string
     */
    public $RightSideHeader;
    /**
     * The AnswerFormat
     * @var string
     */
    public $AnswerFormat;
    /**
     * The AllowOther
     * @var bool
     */
    public $AllowOther;
    /**
     * The IsRequired
     * @var bool
     */
    public $IsRequired;
    /**
     * The AllowNA
     * @var bool
     */
    public $AllowNA;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * Constructor method for SurveyQuestion
     * @uses SurveyQuestion::setAnswerDetail()
     * @uses SurveyQuestion::setRowDetail()
     * @uses SurveyQuestion::setQuestionText()
     * @uses SurveyQuestion::setQuestionHTMLText()
     * @uses SurveyQuestion::setQuestionCode()
     * @uses SurveyQuestion::setQuestionType()
     * @uses SurveyQuestion::setSurveyId()
     * @uses SurveyQuestion::setSurveyCode()
     * @uses SurveyQuestion::setSurveyTitle()
     * @uses SurveyQuestion::setQuestionNumber()
     * @uses SurveyQuestion::setMinimumSelections()
     * @uses SurveyQuestion::setMaximumSelections()
     * @uses SurveyQuestion::setMinimumCharacters()
     * @uses SurveyQuestion::setMaximumCharacters()
     * @uses SurveyQuestion::setLeftSideHeader()
     * @uses SurveyQuestion::setRightSideHeader()
     * @uses SurveyQuestion::setAnswerFormat()
     * @uses SurveyQuestion::setAllowOther()
     * @uses SurveyQuestion::setIsRequired()
     * @uses SurveyQuestion::setAllowNA()
     * @uses SurveyQuestion::setLastModifiedDate()
     * @uses SurveyQuestion::setLastModifiedBy()
     * @param \StructType\AnswerDetail[] $answerDetail
     * @param \StructType\RowDetail[] $rowDetail
     * @param string $questionText
     * @param string $questionHTMLText
     * @param string $questionCode
     * @param string $questionType
     * @param string $surveyId
     * @param string $surveyCode
     * @param string $surveyTitle
     * @param string $questionNumber
     * @param string $minimumSelections
     * @param string $maximumSelections
     * @param string $minimumCharacters
     * @param string $maximumCharacters
     * @param string $leftSideHeader
     * @param string $rightSideHeader
     * @param string $answerFormat
     * @param bool $allowOther
     * @param bool $isRequired
     * @param bool $allowNA
     * @param string $lastModifiedDate
     * @param string $lastModifiedBy
     */
    public function __construct(array $answerDetail = array(), array $rowDetail = array(), $questionText = null, $questionHTMLText = null, $questionCode = null, $questionType = null, $surveyId = null, $surveyCode = null, $surveyTitle = null, $questionNumber = null, $minimumSelections = null, $maximumSelections = null, $minimumCharacters = null, $maximumCharacters = null, $leftSideHeader = null, $rightSideHeader = null, $answerFormat = null, $allowOther = null, $isRequired = null, $allowNA = null, $lastModifiedDate = null, $lastModifiedBy = null)
    {
        $this
            ->setAnswerDetail($answerDetail)
            ->setRowDetail($rowDetail)
            ->setQuestionText($questionText)
            ->setQuestionHTMLText($questionHTMLText)
            ->setQuestionCode($questionCode)
            ->setQuestionType($questionType)
            ->setSurveyId($surveyId)
            ->setSurveyCode($surveyCode)
            ->setSurveyTitle($surveyTitle)
            ->setQuestionNumber($questionNumber)
            ->setMinimumSelections($minimumSelections)
            ->setMaximumSelections($maximumSelections)
            ->setMinimumCharacters($minimumCharacters)
            ->setMaximumCharacters($maximumCharacters)
            ->setLeftSideHeader($leftSideHeader)
            ->setRightSideHeader($rightSideHeader)
            ->setAnswerFormat($answerFormat)
            ->setAllowOther($allowOther)
            ->setIsRequired($isRequired)
            ->setAllowNA($allowNA)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastModifiedBy($lastModifiedBy);
    }
    /**
     * Get AnswerDetail value
     * @return \StructType\AnswerDetail[]|null
     */
    public function getAnswerDetail()
    {
        return $this->AnswerDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAnswerDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnswerDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnswerDetailForArrayConstraintsFromSetAnswerDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $surveyQuestionAnswerDetailItem) {
            // validation for constraint: itemType
            if (!$surveyQuestionAnswerDetailItem instanceof \StructType\AnswerDetail) {
                $invalidValues[] = is_object($surveyQuestionAnswerDetailItem) ? get_class($surveyQuestionAnswerDetailItem) : sprintf('%s(%s)', gettype($surveyQuestionAnswerDetailItem), var_export($surveyQuestionAnswerDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AnswerDetail property can only contain items of type \StructType\AnswerDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AnswerDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AnswerDetail[] $answerDetail
     * @return \StructType\SurveyQuestion
     */
    public function setAnswerDetail(array $answerDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($answerDetailArrayErrorMessage = self::validateAnswerDetailForArrayConstraintsFromSetAnswerDetail($answerDetail))) {
            throw new \InvalidArgumentException($answerDetailArrayErrorMessage, __LINE__);
        }
        $this->AnswerDetail = $answerDetail;
        return $this;
    }
    /**
     * Add item to AnswerDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AnswerDetail $item
     * @return \StructType\SurveyQuestion
     */
    public function addToAnswerDetail(\StructType\AnswerDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnswerDetail) {
            throw new \InvalidArgumentException(sprintf('The AnswerDetail property can only contain items of type \StructType\AnswerDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AnswerDetail[] = $item;
        return $this;
    }
    /**
     * Get RowDetail value
     * @return \StructType\RowDetail[]|null
     */
    public function getRowDetail()
    {
        return $this->RowDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setRowDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRowDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRowDetailForArrayConstraintsFromSetRowDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $surveyQuestionRowDetailItem) {
            // validation for constraint: itemType
            if (!$surveyQuestionRowDetailItem instanceof \StructType\RowDetail) {
                $invalidValues[] = is_object($surveyQuestionRowDetailItem) ? get_class($surveyQuestionRowDetailItem) : sprintf('%s(%s)', gettype($surveyQuestionRowDetailItem), var_export($surveyQuestionRowDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RowDetail property can only contain items of type \StructType\RowDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RowDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RowDetail[] $rowDetail
     * @return \StructType\SurveyQuestion
     */
    public function setRowDetail(array $rowDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($rowDetailArrayErrorMessage = self::validateRowDetailForArrayConstraintsFromSetRowDetail($rowDetail))) {
            throw new \InvalidArgumentException($rowDetailArrayErrorMessage, __LINE__);
        }
        $this->RowDetail = $rowDetail;
        return $this;
    }
    /**
     * Add item to RowDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RowDetail $item
     * @return \StructType\SurveyQuestion
     */
    public function addToRowDetail(\StructType\RowDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RowDetail) {
            throw new \InvalidArgumentException(sprintf('The RowDetail property can only contain items of type \StructType\RowDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RowDetail[] = $item;
        return $this;
    }
    /**
     * Get QuestionText value
     * @return string|null
     */
    public function getQuestionText()
    {
        return $this->QuestionText;
    }
    /**
     * Set QuestionText value
     * @param string $questionText
     * @return \StructType\SurveyQuestion
     */
    public function setQuestionText($questionText = null)
    {
        // validation for constraint: string
        if (!is_null($questionText) && !is_string($questionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionText, true), gettype($questionText)), __LINE__);
        }
        $this->QuestionText = $questionText;
        return $this;
    }
    /**
     * Get QuestionHTMLText value
     * @return string|null
     */
    public function getQuestionHTMLText()
    {
        return $this->QuestionHTMLText;
    }
    /**
     * Set QuestionHTMLText value
     * @param string $questionHTMLText
     * @return \StructType\SurveyQuestion
     */
    public function setQuestionHTMLText($questionHTMLText = null)
    {
        // validation for constraint: string
        if (!is_null($questionHTMLText) && !is_string($questionHTMLText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionHTMLText, true), gettype($questionHTMLText)), __LINE__);
        }
        $this->QuestionHTMLText = $questionHTMLText;
        return $this;
    }
    /**
     * Get QuestionCode value
     * @return string|null
     */
    public function getQuestionCode()
    {
        return $this->QuestionCode;
    }
    /**
     * Set QuestionCode value
     * @param string $questionCode
     * @return \StructType\SurveyQuestion
     */
    public function setQuestionCode($questionCode = null)
    {
        // validation for constraint: string
        if (!is_null($questionCode) && !is_string($questionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionCode, true), gettype($questionCode)), __LINE__);
        }
        $this->QuestionCode = $questionCode;
        return $this;
    }
    /**
     * Get QuestionType value
     * @return string|null
     */
    public function getQuestionType()
    {
        return $this->QuestionType;
    }
    /**
     * Set QuestionType value
     * @param string $questionType
     * @return \StructType\SurveyQuestion
     */
    public function setQuestionType($questionType = null)
    {
        // validation for constraint: string
        if (!is_null($questionType) && !is_string($questionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionType, true), gettype($questionType)), __LINE__);
        }
        $this->QuestionType = $questionType;
        return $this;
    }
    /**
     * Get SurveyId value
     * @return string|null
     */
    public function getSurveyId()
    {
        return $this->SurveyId;
    }
    /**
     * Set SurveyId value
     * @param string $surveyId
     * @return \StructType\SurveyQuestion
     */
    public function setSurveyId($surveyId = null)
    {
        // validation for constraint: string
        if (!is_null($surveyId) && !is_string($surveyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyId, true), gettype($surveyId)), __LINE__);
        }
        $this->SurveyId = $surveyId;
        return $this;
    }
    /**
     * Get SurveyCode value
     * @return string|null
     */
    public function getSurveyCode()
    {
        return $this->SurveyCode;
    }
    /**
     * Set SurveyCode value
     * @param string $surveyCode
     * @return \StructType\SurveyQuestion
     */
    public function setSurveyCode($surveyCode = null)
    {
        // validation for constraint: string
        if (!is_null($surveyCode) && !is_string($surveyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyCode, true), gettype($surveyCode)), __LINE__);
        }
        $this->SurveyCode = $surveyCode;
        return $this;
    }
    /**
     * Get SurveyTitle value
     * @return string|null
     */
    public function getSurveyTitle()
    {
        return $this->SurveyTitle;
    }
    /**
     * Set SurveyTitle value
     * @param string $surveyTitle
     * @return \StructType\SurveyQuestion
     */
    public function setSurveyTitle($surveyTitle = null)
    {
        // validation for constraint: string
        if (!is_null($surveyTitle) && !is_string($surveyTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyTitle, true), gettype($surveyTitle)), __LINE__);
        }
        $this->SurveyTitle = $surveyTitle;
        return $this;
    }
    /**
     * Get QuestionNumber value
     * @return string|null
     */
    public function getQuestionNumber()
    {
        return $this->QuestionNumber;
    }
    /**
     * Set QuestionNumber value
     * @param string $questionNumber
     * @return \StructType\SurveyQuestion
     */
    public function setQuestionNumber($questionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($questionNumber) && !is_string($questionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionNumber, true), gettype($questionNumber)), __LINE__);
        }
        $this->QuestionNumber = $questionNumber;
        return $this;
    }
    /**
     * Get MinimumSelections value
     * @return string|null
     */
    public function getMinimumSelections()
    {
        return $this->MinimumSelections;
    }
    /**
     * Set MinimumSelections value
     * @param string $minimumSelections
     * @return \StructType\SurveyQuestion
     */
    public function setMinimumSelections($minimumSelections = null)
    {
        // validation for constraint: string
        if (!is_null($minimumSelections) && !is_string($minimumSelections)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumSelections, true), gettype($minimumSelections)), __LINE__);
        }
        $this->MinimumSelections = $minimumSelections;
        return $this;
    }
    /**
     * Get MaximumSelections value
     * @return string|null
     */
    public function getMaximumSelections()
    {
        return $this->MaximumSelections;
    }
    /**
     * Set MaximumSelections value
     * @param string $maximumSelections
     * @return \StructType\SurveyQuestion
     */
    public function setMaximumSelections($maximumSelections = null)
    {
        // validation for constraint: string
        if (!is_null($maximumSelections) && !is_string($maximumSelections)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumSelections, true), gettype($maximumSelections)), __LINE__);
        }
        $this->MaximumSelections = $maximumSelections;
        return $this;
    }
    /**
     * Get MinimumCharacters value
     * @return string|null
     */
    public function getMinimumCharacters()
    {
        return $this->MinimumCharacters;
    }
    /**
     * Set MinimumCharacters value
     * @param string $minimumCharacters
     * @return \StructType\SurveyQuestion
     */
    public function setMinimumCharacters($minimumCharacters = null)
    {
        // validation for constraint: string
        if (!is_null($minimumCharacters) && !is_string($minimumCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumCharacters, true), gettype($minimumCharacters)), __LINE__);
        }
        $this->MinimumCharacters = $minimumCharacters;
        return $this;
    }
    /**
     * Get MaximumCharacters value
     * @return string|null
     */
    public function getMaximumCharacters()
    {
        return $this->MaximumCharacters;
    }
    /**
     * Set MaximumCharacters value
     * @param string $maximumCharacters
     * @return \StructType\SurveyQuestion
     */
    public function setMaximumCharacters($maximumCharacters = null)
    {
        // validation for constraint: string
        if (!is_null($maximumCharacters) && !is_string($maximumCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumCharacters, true), gettype($maximumCharacters)), __LINE__);
        }
        $this->MaximumCharacters = $maximumCharacters;
        return $this;
    }
    /**
     * Get LeftSideHeader value
     * @return string|null
     */
    public function getLeftSideHeader()
    {
        return $this->LeftSideHeader;
    }
    /**
     * Set LeftSideHeader value
     * @param string $leftSideHeader
     * @return \StructType\SurveyQuestion
     */
    public function setLeftSideHeader($leftSideHeader = null)
    {
        // validation for constraint: string
        if (!is_null($leftSideHeader) && !is_string($leftSideHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leftSideHeader, true), gettype($leftSideHeader)), __LINE__);
        }
        $this->LeftSideHeader = $leftSideHeader;
        return $this;
    }
    /**
     * Get RightSideHeader value
     * @return string|null
     */
    public function getRightSideHeader()
    {
        return $this->RightSideHeader;
    }
    /**
     * Set RightSideHeader value
     * @param string $rightSideHeader
     * @return \StructType\SurveyQuestion
     */
    public function setRightSideHeader($rightSideHeader = null)
    {
        // validation for constraint: string
        if (!is_null($rightSideHeader) && !is_string($rightSideHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rightSideHeader, true), gettype($rightSideHeader)), __LINE__);
        }
        $this->RightSideHeader = $rightSideHeader;
        return $this;
    }
    /**
     * Get AnswerFormat value
     * @return string|null
     */
    public function getAnswerFormat()
    {
        return $this->AnswerFormat;
    }
    /**
     * Set AnswerFormat value
     * @param string $answerFormat
     * @return \StructType\SurveyQuestion
     */
    public function setAnswerFormat($answerFormat = null)
    {
        // validation for constraint: string
        if (!is_null($answerFormat) && !is_string($answerFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answerFormat, true), gettype($answerFormat)), __LINE__);
        }
        $this->AnswerFormat = $answerFormat;
        return $this;
    }
    /**
     * Get AllowOther value
     * @return bool|null
     */
    public function getAllowOther()
    {
        return $this->AllowOther;
    }
    /**
     * Set AllowOther value
     * @param bool $allowOther
     * @return \StructType\SurveyQuestion
     */
    public function setAllowOther($allowOther = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowOther) && !is_bool($allowOther)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowOther, true), gettype($allowOther)), __LINE__);
        }
        $this->AllowOther = $allowOther;
        return $this;
    }
    /**
     * Get IsRequired value
     * @return bool|null
     */
    public function getIsRequired()
    {
        return $this->IsRequired;
    }
    /**
     * Set IsRequired value
     * @param bool $isRequired
     * @return \StructType\SurveyQuestion
     */
    public function setIsRequired($isRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRequired) && !is_bool($isRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRequired, true), gettype($isRequired)), __LINE__);
        }
        $this->IsRequired = $isRequired;
        return $this;
    }
    /**
     * Get AllowNA value
     * @return bool|null
     */
    public function getAllowNA()
    {
        return $this->AllowNA;
    }
    /**
     * Set AllowNA value
     * @param bool $allowNA
     * @return \StructType\SurveyQuestion
     */
    public function setAllowNA($allowNA = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowNA) && !is_bool($allowNA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowNA, true), gettype($allowNA)), __LINE__);
        }
        $this->AllowNA = $allowNA;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\SurveyQuestion
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\SurveyQuestion
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SurveyQuestion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
