<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SurveyEmailHistory StructType
 * @subpackage Structs
 */
class SurveyEmailHistory extends CvObject
{
    /**
     * The SurveyId
     * @var string
     */
    public $SurveyId;
    /**
     * The RespondentId
     * @var string
     */
    public $RespondentId;
    /**
     * The ContactId
     * @var string
     */
    public $ContactId;
    /**
     * The TargetList
     * @var string
     */
    public $TargetList;
    /**
     * The EmailSentDate
     * @var string
     */
    public $EmailSentDate;
    /**
     * The EmailStatus
     * @var string
     */
    public $EmailStatus;
    /**
     * The EmailType
     * @var string
     */
    public $EmailType;
    /**
     * The FromEmailAddress
     * @var string
     */
    public $FromEmailAddress;
    /**
     * The ToEmailAddress
     * @var string
     */
    public $ToEmailAddress;
    /**
     * The EmailViewed
     * @var bool
     */
    public $EmailViewed;
    /**
     * The EmailBounced
     * @var bool
     */
    public $EmailBounced;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * Constructor method for SurveyEmailHistory
     * @uses SurveyEmailHistory::setSurveyId()
     * @uses SurveyEmailHistory::setRespondentId()
     * @uses SurveyEmailHistory::setContactId()
     * @uses SurveyEmailHistory::setTargetList()
     * @uses SurveyEmailHistory::setEmailSentDate()
     * @uses SurveyEmailHistory::setEmailStatus()
     * @uses SurveyEmailHistory::setEmailType()
     * @uses SurveyEmailHistory::setFromEmailAddress()
     * @uses SurveyEmailHistory::setToEmailAddress()
     * @uses SurveyEmailHistory::setEmailViewed()
     * @uses SurveyEmailHistory::setEmailBounced()
     * @uses SurveyEmailHistory::setLastModifiedDate()
     * @param string $surveyId
     * @param string $respondentId
     * @param string $contactId
     * @param string $targetList
     * @param string $emailSentDate
     * @param string $emailStatus
     * @param string $emailType
     * @param string $fromEmailAddress
     * @param string $toEmailAddress
     * @param bool $emailViewed
     * @param bool $emailBounced
     * @param string $lastModifiedDate
     */
    public function __construct($surveyId = null, $respondentId = null, $contactId = null, $targetList = null, $emailSentDate = null, $emailStatus = null, $emailType = null, $fromEmailAddress = null, $toEmailAddress = null, $emailViewed = null, $emailBounced = null, $lastModifiedDate = null)
    {
        $this
            ->setSurveyId($surveyId)
            ->setRespondentId($respondentId)
            ->setContactId($contactId)
            ->setTargetList($targetList)
            ->setEmailSentDate($emailSentDate)
            ->setEmailStatus($emailStatus)
            ->setEmailType($emailType)
            ->setFromEmailAddress($fromEmailAddress)
            ->setToEmailAddress($toEmailAddress)
            ->setEmailViewed($emailViewed)
            ->setEmailBounced($emailBounced)
            ->setLastModifiedDate($lastModifiedDate);
    }
    /**
     * Get SurveyId value
     * @return string|null
     */
    public function getSurveyId()
    {
        return $this->SurveyId;
    }
    /**
     * Set SurveyId value
     * @param string $surveyId
     * @return \StructType\SurveyEmailHistory
     */
    public function setSurveyId($surveyId = null)
    {
        // validation for constraint: string
        if (!is_null($surveyId) && !is_string($surveyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyId, true), gettype($surveyId)), __LINE__);
        }
        $this->SurveyId = $surveyId;
        return $this;
    }
    /**
     * Get RespondentId value
     * @return string|null
     */
    public function getRespondentId()
    {
        return $this->RespondentId;
    }
    /**
     * Set RespondentId value
     * @param string $respondentId
     * @return \StructType\SurveyEmailHistory
     */
    public function setRespondentId($respondentId = null)
    {
        // validation for constraint: string
        if (!is_null($respondentId) && !is_string($respondentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($respondentId, true), gettype($respondentId)), __LINE__);
        }
        $this->RespondentId = $respondentId;
        return $this;
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \StructType\SurveyEmailHistory
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get TargetList value
     * @return string|null
     */
    public function getTargetList()
    {
        return $this->TargetList;
    }
    /**
     * Set TargetList value
     * @param string $targetList
     * @return \StructType\SurveyEmailHistory
     */
    public function setTargetList($targetList = null)
    {
        // validation for constraint: string
        if (!is_null($targetList) && !is_string($targetList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetList, true), gettype($targetList)), __LINE__);
        }
        $this->TargetList = $targetList;
        return $this;
    }
    /**
     * Get EmailSentDate value
     * @return string|null
     */
    public function getEmailSentDate()
    {
        return $this->EmailSentDate;
    }
    /**
     * Set EmailSentDate value
     * @param string $emailSentDate
     * @return \StructType\SurveyEmailHistory
     */
    public function setEmailSentDate($emailSentDate = null)
    {
        // validation for constraint: string
        if (!is_null($emailSentDate) && !is_string($emailSentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailSentDate, true), gettype($emailSentDate)), __LINE__);
        }
        $this->EmailSentDate = $emailSentDate;
        return $this;
    }
    /**
     * Get EmailStatus value
     * @return string|null
     */
    public function getEmailStatus()
    {
        return $this->EmailStatus;
    }
    /**
     * Set EmailStatus value
     * @param string $emailStatus
     * @return \StructType\SurveyEmailHistory
     */
    public function setEmailStatus($emailStatus = null)
    {
        // validation for constraint: string
        if (!is_null($emailStatus) && !is_string($emailStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailStatus, true), gettype($emailStatus)), __LINE__);
        }
        $this->EmailStatus = $emailStatus;
        return $this;
    }
    /**
     * Get EmailType value
     * @return string|null
     */
    public function getEmailType()
    {
        return $this->EmailType;
    }
    /**
     * Set EmailType value
     * @param string $emailType
     * @return \StructType\SurveyEmailHistory
     */
    public function setEmailType($emailType = null)
    {
        // validation for constraint: string
        if (!is_null($emailType) && !is_string($emailType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailType, true), gettype($emailType)), __LINE__);
        }
        $this->EmailType = $emailType;
        return $this;
    }
    /**
     * Get FromEmailAddress value
     * @return string|null
     */
    public function getFromEmailAddress()
    {
        return $this->FromEmailAddress;
    }
    /**
     * Set FromEmailAddress value
     * @param string $fromEmailAddress
     * @return \StructType\SurveyEmailHistory
     */
    public function setFromEmailAddress($fromEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fromEmailAddress) && !is_string($fromEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromEmailAddress, true), gettype($fromEmailAddress)), __LINE__);
        }
        $this->FromEmailAddress = $fromEmailAddress;
        return $this;
    }
    /**
     * Get ToEmailAddress value
     * @return string|null
     */
    public function getToEmailAddress()
    {
        return $this->ToEmailAddress;
    }
    /**
     * Set ToEmailAddress value
     * @param string $toEmailAddress
     * @return \StructType\SurveyEmailHistory
     */
    public function setToEmailAddress($toEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($toEmailAddress) && !is_string($toEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toEmailAddress, true), gettype($toEmailAddress)), __LINE__);
        }
        $this->ToEmailAddress = $toEmailAddress;
        return $this;
    }
    /**
     * Get EmailViewed value
     * @return bool|null
     */
    public function getEmailViewed()
    {
        return $this->EmailViewed;
    }
    /**
     * Set EmailViewed value
     * @param bool $emailViewed
     * @return \StructType\SurveyEmailHistory
     */
    public function setEmailViewed($emailViewed = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailViewed) && !is_bool($emailViewed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailViewed, true), gettype($emailViewed)), __LINE__);
        }
        $this->EmailViewed = $emailViewed;
        return $this;
    }
    /**
     * Get EmailBounced value
     * @return bool|null
     */
    public function getEmailBounced()
    {
        return $this->EmailBounced;
    }
    /**
     * Set EmailBounced value
     * @param bool $emailBounced
     * @return \StructType\SurveyEmailHistory
     */
    public function setEmailBounced($emailBounced = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailBounced) && !is_bool($emailBounced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailBounced, true), gettype($emailBounced)), __LINE__);
        }
        $this->EmailBounced = $emailBounced;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\SurveyEmailHistory
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SurveyEmailHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
