<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SurveyDetail StructType
 * @subpackage Structs
 */
class SurveyDetail extends AbstractStructBase
{
    /**
     * The QuestionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuestionType;
    /**
     * The QuestionScore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QuestionScore;
    /**
     * The QuestionText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QuestionText;
    /**
     * The QuestionExportValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QuestionExportValue;
    /**
     * The Answer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Answer[]
     */
    public $Answer;
    /**
     * Constructor method for SurveyDetail
     * @uses SurveyDetail::setQuestionType()
     * @uses SurveyDetail::setQuestionScore()
     * @uses SurveyDetail::setQuestionText()
     * @uses SurveyDetail::setQuestionExportValue()
     * @uses SurveyDetail::setAnswer()
     * @param int $questionType
     * @param float $questionScore
     * @param string $questionText
     * @param string $questionExportValue
     * @param \StructType\Answer[] $answer
     */
    public function __construct($questionType = null, $questionScore = null, $questionText = null, $questionExportValue = null, array $answer = array())
    {
        $this
            ->setQuestionType($questionType)
            ->setQuestionScore($questionScore)
            ->setQuestionText($questionText)
            ->setQuestionExportValue($questionExportValue)
            ->setAnswer($answer);
    }
    /**
     * Get QuestionType value
     * @return int
     */
    public function getQuestionType()
    {
        return $this->QuestionType;
    }
    /**
     * Set QuestionType value
     * @param int $questionType
     * @return \StructType\SurveyDetail
     */
    public function setQuestionType($questionType = null)
    {
        // validation for constraint: int
        if (!is_null($questionType) && !(is_int($questionType) || ctype_digit($questionType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($questionType, true), gettype($questionType)), __LINE__);
        }
        $this->QuestionType = $questionType;
        return $this;
    }
    /**
     * Get QuestionScore value
     * @return float
     */
    public function getQuestionScore()
    {
        return $this->QuestionScore;
    }
    /**
     * Set QuestionScore value
     * @param float $questionScore
     * @return \StructType\SurveyDetail
     */
    public function setQuestionScore($questionScore = null)
    {
        // validation for constraint: float
        if (!is_null($questionScore) && !(is_float($questionScore) || is_numeric($questionScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($questionScore, true), gettype($questionScore)), __LINE__);
        }
        $this->QuestionScore = $questionScore;
        return $this;
    }
    /**
     * Get QuestionText value
     * @return string|null
     */
    public function getQuestionText()
    {
        return $this->QuestionText;
    }
    /**
     * Set QuestionText value
     * @param string $questionText
     * @return \StructType\SurveyDetail
     */
    public function setQuestionText($questionText = null)
    {
        // validation for constraint: string
        if (!is_null($questionText) && !is_string($questionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionText, true), gettype($questionText)), __LINE__);
        }
        $this->QuestionText = $questionText;
        return $this;
    }
    /**
     * Get QuestionExportValue value
     * @return string|null
     */
    public function getQuestionExportValue()
    {
        return $this->QuestionExportValue;
    }
    /**
     * Set QuestionExportValue value
     * @param string $questionExportValue
     * @return \StructType\SurveyDetail
     */
    public function setQuestionExportValue($questionExportValue = null)
    {
        // validation for constraint: string
        if (!is_null($questionExportValue) && !is_string($questionExportValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionExportValue, true), gettype($questionExportValue)), __LINE__);
        }
        $this->QuestionExportValue = $questionExportValue;
        return $this;
    }
    /**
     * Get Answer value
     * @return \StructType\Answer[]|null
     */
    public function getAnswer()
    {
        return $this->Answer;
    }
    /**
     * This method is responsible for validating the values passed to the setAnswer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnswer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnswerForArrayConstraintsFromSetAnswer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $surveyDetailAnswerItem) {
            // validation for constraint: itemType
            if (!$surveyDetailAnswerItem instanceof \StructType\Answer) {
                $invalidValues[] = is_object($surveyDetailAnswerItem) ? get_class($surveyDetailAnswerItem) : sprintf('%s(%s)', gettype($surveyDetailAnswerItem), var_export($surveyDetailAnswerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Answer property can only contain items of type \StructType\Answer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Answer value
     * @throws \InvalidArgumentException
     * @param \StructType\Answer[] $answer
     * @return \StructType\SurveyDetail
     */
    public function setAnswer(array $answer = array())
    {
        // validation for constraint: array
        if ('' !== ($answerArrayErrorMessage = self::validateAnswerForArrayConstraintsFromSetAnswer($answer))) {
            throw new \InvalidArgumentException($answerArrayErrorMessage, __LINE__);
        }
        $this->Answer = $answer;
        return $this;
    }
    /**
     * Add item to Answer value
     * @throws \InvalidArgumentException
     * @param \StructType\Answer $item
     * @return \StructType\SurveyDetail
     */
    public function addToAnswer(\StructType\Answer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Answer) {
            throw new \InvalidArgumentException(sprintf('The Answer property can only contain items of type \StructType\Answer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Answer[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SurveyDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
