<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Survey StructType
 * @subpackage Structs
 */
class Survey extends CvObject
{
    /**
     * The CustomFieldDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldDetail[]
     */
    public $CustomFieldDetail;
    /**
     * The WeblinkDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WeblinkDetail[]
     */
    public $WeblinkDetail;
    /**
     * The TargetListDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TargetListDetail[]
     */
    public $TargetListDetail;
    /**
     * The AssociatedEvents
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AssociatedEvents[]
     */
    public $AssociatedEvents;
    /**
     * The SurveyCode
     * @var string
     */
    public $SurveyCode;
    /**
     * The SurveyTitle
     * @var string
     */
    public $SurveyTitle;
    /**
     * The SurveyCloseDate
     * @var string
     */
    public $SurveyCloseDate;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The SurveyStatus
     * @var string
     */
    public $SurveyStatus;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * The PlannerFirstName
     * @var string
     */
    public $PlannerFirstName;
    /**
     * The PlannerLastName
     * @var string
     */
    public $PlannerLastName;
    /**
     * The SurveyLaunchDate
     * @var string
     */
    public $SurveyLaunchDate;
    /**
     * Constructor method for Survey
     * @uses Survey::setCustomFieldDetail()
     * @uses Survey::setWeblinkDetail()
     * @uses Survey::setTargetListDetail()
     * @uses Survey::setAssociatedEvents()
     * @uses Survey::setSurveyCode()
     * @uses Survey::setSurveyTitle()
     * @uses Survey::setSurveyCloseDate()
     * @uses Survey::setDescription()
     * @uses Survey::setSurveyStatus()
     * @uses Survey::setInternalNote()
     * @uses Survey::setPlannerFirstName()
     * @uses Survey::setPlannerLastName()
     * @uses Survey::setSurveyLaunchDate()
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @param \StructType\WeblinkDetail[] $weblinkDetail
     * @param \StructType\TargetListDetail[] $targetListDetail
     * @param \StructType\AssociatedEvents[] $associatedEvents
     * @param string $surveyCode
     * @param string $surveyTitle
     * @param string $surveyCloseDate
     * @param string $description
     * @param string $surveyStatus
     * @param string $internalNote
     * @param string $plannerFirstName
     * @param string $plannerLastName
     * @param string $surveyLaunchDate
     */
    public function __construct(array $customFieldDetail = array(), array $weblinkDetail = array(), array $targetListDetail = array(), array $associatedEvents = array(), $surveyCode = null, $surveyTitle = null, $surveyCloseDate = null, $description = null, $surveyStatus = null, $internalNote = null, $plannerFirstName = null, $plannerLastName = null, $surveyLaunchDate = null)
    {
        $this
            ->setCustomFieldDetail($customFieldDetail)
            ->setWeblinkDetail($weblinkDetail)
            ->setTargetListDetail($targetListDetail)
            ->setAssociatedEvents($associatedEvents)
            ->setSurveyCode($surveyCode)
            ->setSurveyTitle($surveyTitle)
            ->setSurveyCloseDate($surveyCloseDate)
            ->setDescription($description)
            ->setSurveyStatus($surveyStatus)
            ->setInternalNote($internalNote)
            ->setPlannerFirstName($plannerFirstName)
            ->setPlannerLastName($plannerLastName)
            ->setSurveyLaunchDate($surveyLaunchDate);
    }
    /**
     * Get CustomFieldDetail value
     * @return \StructType\CustomFieldDetail[]|null
     */
    public function getCustomFieldDetail()
    {
        return $this->CustomFieldDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomFieldDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomFieldDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $surveyCustomFieldDetailItem) {
            // validation for constraint: itemType
            if (!$surveyCustomFieldDetailItem instanceof \StructType\CustomFieldDetail) {
                $invalidValues[] = is_object($surveyCustomFieldDetailItem) ? get_class($surveyCustomFieldDetailItem) : sprintf('%s(%s)', gettype($surveyCustomFieldDetailItem), var_export($surveyCustomFieldDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @return \StructType\Survey
     */
    public function setCustomFieldDetail(array $customFieldDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldDetailArrayErrorMessage = self::validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail($customFieldDetail))) {
            throw new \InvalidArgumentException($customFieldDetailArrayErrorMessage, __LINE__);
        }
        $this->CustomFieldDetail = $customFieldDetail;
        return $this;
    }
    /**
     * Add item to CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail $item
     * @return \StructType\Survey
     */
    public function addToCustomFieldDetail(\StructType\CustomFieldDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomFieldDetail[] = $item;
        return $this;
    }
    /**
     * Get WeblinkDetail value
     * @return \StructType\WeblinkDetail[]|null
     */
    public function getWeblinkDetail()
    {
        return $this->WeblinkDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setWeblinkDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeblinkDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeblinkDetailForArrayConstraintsFromSetWeblinkDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $surveyWeblinkDetailItem) {
            // validation for constraint: itemType
            if (!$surveyWeblinkDetailItem instanceof \StructType\WeblinkDetail) {
                $invalidValues[] = is_object($surveyWeblinkDetailItem) ? get_class($surveyWeblinkDetailItem) : sprintf('%s(%s)', gettype($surveyWeblinkDetailItem), var_export($surveyWeblinkDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WeblinkDetail property can only contain items of type \StructType\WeblinkDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WeblinkDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\WeblinkDetail[] $weblinkDetail
     * @return \StructType\Survey
     */
    public function setWeblinkDetail(array $weblinkDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($weblinkDetailArrayErrorMessage = self::validateWeblinkDetailForArrayConstraintsFromSetWeblinkDetail($weblinkDetail))) {
            throw new \InvalidArgumentException($weblinkDetailArrayErrorMessage, __LINE__);
        }
        $this->WeblinkDetail = $weblinkDetail;
        return $this;
    }
    /**
     * Add item to WeblinkDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\WeblinkDetail $item
     * @return \StructType\Survey
     */
    public function addToWeblinkDetail(\StructType\WeblinkDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WeblinkDetail) {
            throw new \InvalidArgumentException(sprintf('The WeblinkDetail property can only contain items of type \StructType\WeblinkDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WeblinkDetail[] = $item;
        return $this;
    }
    /**
     * Get TargetListDetail value
     * @return \StructType\TargetListDetail[]|null
     */
    public function getTargetListDetail()
    {
        return $this->TargetListDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setTargetListDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTargetListDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTargetListDetailForArrayConstraintsFromSetTargetListDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $surveyTargetListDetailItem) {
            // validation for constraint: itemType
            if (!$surveyTargetListDetailItem instanceof \StructType\TargetListDetail) {
                $invalidValues[] = is_object($surveyTargetListDetailItem) ? get_class($surveyTargetListDetailItem) : sprintf('%s(%s)', gettype($surveyTargetListDetailItem), var_export($surveyTargetListDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TargetListDetail property can only contain items of type \StructType\TargetListDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TargetListDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TargetListDetail[] $targetListDetail
     * @return \StructType\Survey
     */
    public function setTargetListDetail(array $targetListDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($targetListDetailArrayErrorMessage = self::validateTargetListDetailForArrayConstraintsFromSetTargetListDetail($targetListDetail))) {
            throw new \InvalidArgumentException($targetListDetailArrayErrorMessage, __LINE__);
        }
        $this->TargetListDetail = $targetListDetail;
        return $this;
    }
    /**
     * Add item to TargetListDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TargetListDetail $item
     * @return \StructType\Survey
     */
    public function addToTargetListDetail(\StructType\TargetListDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TargetListDetail) {
            throw new \InvalidArgumentException(sprintf('The TargetListDetail property can only contain items of type \StructType\TargetListDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TargetListDetail[] = $item;
        return $this;
    }
    /**
     * Get AssociatedEvents value
     * @return \StructType\AssociatedEvents[]|null
     */
    public function getAssociatedEvents()
    {
        return $this->AssociatedEvents;
    }
    /**
     * This method is responsible for validating the values passed to the setAssociatedEvents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssociatedEvents method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssociatedEventsForArrayConstraintsFromSetAssociatedEvents(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $surveyAssociatedEventsItem) {
            // validation for constraint: itemType
            if (!$surveyAssociatedEventsItem instanceof \StructType\AssociatedEvents) {
                $invalidValues[] = is_object($surveyAssociatedEventsItem) ? get_class($surveyAssociatedEventsItem) : sprintf('%s(%s)', gettype($surveyAssociatedEventsItem), var_export($surveyAssociatedEventsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AssociatedEvents property can only contain items of type \StructType\AssociatedEvents, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AssociatedEvents value
     * @throws \InvalidArgumentException
     * @param \StructType\AssociatedEvents[] $associatedEvents
     * @return \StructType\Survey
     */
    public function setAssociatedEvents(array $associatedEvents = array())
    {
        // validation for constraint: array
        if ('' !== ($associatedEventsArrayErrorMessage = self::validateAssociatedEventsForArrayConstraintsFromSetAssociatedEvents($associatedEvents))) {
            throw new \InvalidArgumentException($associatedEventsArrayErrorMessage, __LINE__);
        }
        $this->AssociatedEvents = $associatedEvents;
        return $this;
    }
    /**
     * Add item to AssociatedEvents value
     * @throws \InvalidArgumentException
     * @param \StructType\AssociatedEvents $item
     * @return \StructType\Survey
     */
    public function addToAssociatedEvents(\StructType\AssociatedEvents $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssociatedEvents) {
            throw new \InvalidArgumentException(sprintf('The AssociatedEvents property can only contain items of type \StructType\AssociatedEvents, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AssociatedEvents[] = $item;
        return $this;
    }
    /**
     * Get SurveyCode value
     * @return string|null
     */
    public function getSurveyCode()
    {
        return $this->SurveyCode;
    }
    /**
     * Set SurveyCode value
     * @param string $surveyCode
     * @return \StructType\Survey
     */
    public function setSurveyCode($surveyCode = null)
    {
        // validation for constraint: string
        if (!is_null($surveyCode) && !is_string($surveyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyCode, true), gettype($surveyCode)), __LINE__);
        }
        $this->SurveyCode = $surveyCode;
        return $this;
    }
    /**
     * Get SurveyTitle value
     * @return string|null
     */
    public function getSurveyTitle()
    {
        return $this->SurveyTitle;
    }
    /**
     * Set SurveyTitle value
     * @param string $surveyTitle
     * @return \StructType\Survey
     */
    public function setSurveyTitle($surveyTitle = null)
    {
        // validation for constraint: string
        if (!is_null($surveyTitle) && !is_string($surveyTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyTitle, true), gettype($surveyTitle)), __LINE__);
        }
        $this->SurveyTitle = $surveyTitle;
        return $this;
    }
    /**
     * Get SurveyCloseDate value
     * @return string|null
     */
    public function getSurveyCloseDate()
    {
        return $this->SurveyCloseDate;
    }
    /**
     * Set SurveyCloseDate value
     * @param string $surveyCloseDate
     * @return \StructType\Survey
     */
    public function setSurveyCloseDate($surveyCloseDate = null)
    {
        // validation for constraint: string
        if (!is_null($surveyCloseDate) && !is_string($surveyCloseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyCloseDate, true), gettype($surveyCloseDate)), __LINE__);
        }
        $this->SurveyCloseDate = $surveyCloseDate;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Survey
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get SurveyStatus value
     * @return string|null
     */
    public function getSurveyStatus()
    {
        return $this->SurveyStatus;
    }
    /**
     * Set SurveyStatus value
     * @param string $surveyStatus
     * @return \StructType\Survey
     */
    public function setSurveyStatus($surveyStatus = null)
    {
        // validation for constraint: string
        if (!is_null($surveyStatus) && !is_string($surveyStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyStatus, true), gettype($surveyStatus)), __LINE__);
        }
        $this->SurveyStatus = $surveyStatus;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\Survey
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Get PlannerFirstName value
     * @return string|null
     */
    public function getPlannerFirstName()
    {
        return $this->PlannerFirstName;
    }
    /**
     * Set PlannerFirstName value
     * @param string $plannerFirstName
     * @return \StructType\Survey
     */
    public function setPlannerFirstName($plannerFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($plannerFirstName) && !is_string($plannerFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerFirstName, true), gettype($plannerFirstName)), __LINE__);
        }
        $this->PlannerFirstName = $plannerFirstName;
        return $this;
    }
    /**
     * Get PlannerLastName value
     * @return string|null
     */
    public function getPlannerLastName()
    {
        return $this->PlannerLastName;
    }
    /**
     * Set PlannerLastName value
     * @param string $plannerLastName
     * @return \StructType\Survey
     */
    public function setPlannerLastName($plannerLastName = null)
    {
        // validation for constraint: string
        if (!is_null($plannerLastName) && !is_string($plannerLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerLastName, true), gettype($plannerLastName)), __LINE__);
        }
        $this->PlannerLastName = $plannerLastName;
        return $this;
    }
    /**
     * Get SurveyLaunchDate value
     * @return string|null
     */
    public function getSurveyLaunchDate()
    {
        return $this->SurveyLaunchDate;
    }
    /**
     * Set SurveyLaunchDate value
     * @param string $surveyLaunchDate
     * @return \StructType\Survey
     */
    public function setSurveyLaunchDate($surveyLaunchDate = null)
    {
        // validation for constraint: string
        if (!is_null($surveyLaunchDate) && !is_string($surveyLaunchDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyLaunchDate, true), gettype($surveyLaunchDate)), __LINE__);
        }
        $this->SurveyLaunchDate = $surveyLaunchDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Survey
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
