<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierRFPRecipientDetail StructType
 * @subpackage Structs
 */
class SupplierRFPRecipientDetail extends AbstractStructBase
{
    /**
     * The RecipientDate
     * @var string
     */
    public $RecipientDate;
    /**
     * The RecipientEmailAddress
     * @var string
     */
    public $RecipientEmailAddress;
    /**
     * The RecipientType
     * @var string
     */
    public $RecipientType;
    /**
     * Constructor method for SupplierRFPRecipientDetail
     * @uses SupplierRFPRecipientDetail::setRecipientDate()
     * @uses SupplierRFPRecipientDetail::setRecipientEmailAddress()
     * @uses SupplierRFPRecipientDetail::setRecipientType()
     * @param string $recipientDate
     * @param string $recipientEmailAddress
     * @param string $recipientType
     */
    public function __construct($recipientDate = null, $recipientEmailAddress = null, $recipientType = null)
    {
        $this
            ->setRecipientDate($recipientDate)
            ->setRecipientEmailAddress($recipientEmailAddress)
            ->setRecipientType($recipientType);
    }
    /**
     * Get RecipientDate value
     * @return string|null
     */
    public function getRecipientDate()
    {
        return $this->RecipientDate;
    }
    /**
     * Set RecipientDate value
     * @param string $recipientDate
     * @return \StructType\SupplierRFPRecipientDetail
     */
    public function setRecipientDate($recipientDate = null)
    {
        // validation for constraint: string
        if (!is_null($recipientDate) && !is_string($recipientDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientDate, true), gettype($recipientDate)), __LINE__);
        }
        $this->RecipientDate = $recipientDate;
        return $this;
    }
    /**
     * Get RecipientEmailAddress value
     * @return string|null
     */
    public function getRecipientEmailAddress()
    {
        return $this->RecipientEmailAddress;
    }
    /**
     * Set RecipientEmailAddress value
     * @param string $recipientEmailAddress
     * @return \StructType\SupplierRFPRecipientDetail
     */
    public function setRecipientEmailAddress($recipientEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($recipientEmailAddress) && !is_string($recipientEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientEmailAddress, true), gettype($recipientEmailAddress)), __LINE__);
        }
        $this->RecipientEmailAddress = $recipientEmailAddress;
        return $this;
    }
    /**
     * Get RecipientType value
     * @return string|null
     */
    public function getRecipientType()
    {
        return $this->RecipientType;
    }
    /**
     * Set RecipientType value
     * @param string $recipientType
     * @return \StructType\SupplierRFPRecipientDetail
     */
    public function setRecipientType($recipientType = null)
    {
        // validation for constraint: string
        if (!is_null($recipientType) && !is_string($recipientType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientType, true), gettype($recipientType)), __LINE__);
        }
        $this->RecipientType = $recipientType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SupplierRFPRecipientDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
