<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierRFPInfoDetail StructType
 * @subpackage Structs
 */
class SupplierRFPInfoDetail extends SupplierDetail
{
    /**
     * The RFPReceivedDate
     * @var string
     */
    public $RFPReceivedDate;
    /**
     * The BidSentDate
     * @var string
     */
    public $BidSentDate;
    /**
     * The LastResponseDate
     * @var string
     */
    public $LastResponseDate;
    /**
     * The SourceId
     * @var string
     */
    public $SourceId;
    /**
     * The Archived
     * @var bool
     */
    public $Archived;
    /**
     * Constructor method for SupplierRFPInfoDetail
     * @uses SupplierRFPInfoDetail::setRFPReceivedDate()
     * @uses SupplierRFPInfoDetail::setBidSentDate()
     * @uses SupplierRFPInfoDetail::setLastResponseDate()
     * @uses SupplierRFPInfoDetail::setSourceId()
     * @uses SupplierRFPInfoDetail::setArchived()
     * @param string $rFPReceivedDate
     * @param string $bidSentDate
     * @param string $lastResponseDate
     * @param string $sourceId
     * @param bool $archived
     */
    public function __construct($rFPReceivedDate = null, $bidSentDate = null, $lastResponseDate = null, $sourceId = null, $archived = null)
    {
        $this
            ->setRFPReceivedDate($rFPReceivedDate)
            ->setBidSentDate($bidSentDate)
            ->setLastResponseDate($lastResponseDate)
            ->setSourceId($sourceId)
            ->setArchived($archived);
    }
    /**
     * Get RFPReceivedDate value
     * @return string|null
     */
    public function getRFPReceivedDate()
    {
        return $this->RFPReceivedDate;
    }
    /**
     * Set RFPReceivedDate value
     * @param string $rFPReceivedDate
     * @return \StructType\SupplierRFPInfoDetail
     */
    public function setRFPReceivedDate($rFPReceivedDate = null)
    {
        // validation for constraint: string
        if (!is_null($rFPReceivedDate) && !is_string($rFPReceivedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPReceivedDate, true), gettype($rFPReceivedDate)), __LINE__);
        }
        $this->RFPReceivedDate = $rFPReceivedDate;
        return $this;
    }
    /**
     * Get BidSentDate value
     * @return string|null
     */
    public function getBidSentDate()
    {
        return $this->BidSentDate;
    }
    /**
     * Set BidSentDate value
     * @param string $bidSentDate
     * @return \StructType\SupplierRFPInfoDetail
     */
    public function setBidSentDate($bidSentDate = null)
    {
        // validation for constraint: string
        if (!is_null($bidSentDate) && !is_string($bidSentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bidSentDate, true), gettype($bidSentDate)), __LINE__);
        }
        $this->BidSentDate = $bidSentDate;
        return $this;
    }
    /**
     * Get LastResponseDate value
     * @return string|null
     */
    public function getLastResponseDate()
    {
        return $this->LastResponseDate;
    }
    /**
     * Set LastResponseDate value
     * @param string $lastResponseDate
     * @return \StructType\SupplierRFPInfoDetail
     */
    public function setLastResponseDate($lastResponseDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastResponseDate) && !is_string($lastResponseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastResponseDate, true), gettype($lastResponseDate)), __LINE__);
        }
        $this->LastResponseDate = $lastResponseDate;
        return $this;
    }
    /**
     * Get SourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->SourceId;
    }
    /**
     * Set SourceId value
     * @param string $sourceId
     * @return \StructType\SupplierRFPInfoDetail
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        $this->SourceId = $sourceId;
        return $this;
    }
    /**
     * Get Archived value
     * @return bool|null
     */
    public function getArchived()
    {
        return $this->Archived;
    }
    /**
     * Set Archived value
     * @param bool $archived
     * @return \StructType\SupplierRFPInfoDetail
     */
    public function setArchived($archived = null)
    {
        // validation for constraint: boolean
        if (!is_null($archived) && !is_bool($archived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($archived, true), gettype($archived)), __LINE__);
        }
        $this->Archived = $archived;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SupplierRFPInfoDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
