<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierRFPAssignmentHistoryDetail StructType
 * @subpackage Structs
 */
class SupplierRFPAssignmentHistoryDetail extends AbstractStructBase
{
    /**
     * The AssigneeFirstName
     * @var string
     */
    public $AssigneeFirstName;
    /**
     * The AssigneeLastName
     * @var string
     */
    public $AssigneeLastName;
    /**
     * The AssigneeEmailAddress
     * @var string
     */
    public $AssigneeEmailAddress;
    /**
     * The AssignorEmailAddress
     * @var string
     */
    public $AssignorEmailAddress;
    /**
     * The AssignmentStatus
     * @var string
     */
    public $AssignmentStatus;
    /**
     * The AssignmentMessage
     * @var string
     */
    public $AssignmentMessage;
    /**
     * The CurrentAssignee
     * @var bool
     */
    public $CurrentAssignee;
    /**
     * Constructor method for SupplierRFPAssignmentHistoryDetail
     * @uses SupplierRFPAssignmentHistoryDetail::setAssigneeFirstName()
     * @uses SupplierRFPAssignmentHistoryDetail::setAssigneeLastName()
     * @uses SupplierRFPAssignmentHistoryDetail::setAssigneeEmailAddress()
     * @uses SupplierRFPAssignmentHistoryDetail::setAssignorEmailAddress()
     * @uses SupplierRFPAssignmentHistoryDetail::setAssignmentStatus()
     * @uses SupplierRFPAssignmentHistoryDetail::setAssignmentMessage()
     * @uses SupplierRFPAssignmentHistoryDetail::setCurrentAssignee()
     * @param string $assigneeFirstName
     * @param string $assigneeLastName
     * @param string $assigneeEmailAddress
     * @param string $assignorEmailAddress
     * @param string $assignmentStatus
     * @param string $assignmentMessage
     * @param bool $currentAssignee
     */
    public function __construct($assigneeFirstName = null, $assigneeLastName = null, $assigneeEmailAddress = null, $assignorEmailAddress = null, $assignmentStatus = null, $assignmentMessage = null, $currentAssignee = null)
    {
        $this
            ->setAssigneeFirstName($assigneeFirstName)
            ->setAssigneeLastName($assigneeLastName)
            ->setAssigneeEmailAddress($assigneeEmailAddress)
            ->setAssignorEmailAddress($assignorEmailAddress)
            ->setAssignmentStatus($assignmentStatus)
            ->setAssignmentMessage($assignmentMessage)
            ->setCurrentAssignee($currentAssignee);
    }
    /**
     * Get AssigneeFirstName value
     * @return string|null
     */
    public function getAssigneeFirstName()
    {
        return $this->AssigneeFirstName;
    }
    /**
     * Set AssigneeFirstName value
     * @param string $assigneeFirstName
     * @return \StructType\SupplierRFPAssignmentHistoryDetail
     */
    public function setAssigneeFirstName($assigneeFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($assigneeFirstName) && !is_string($assigneeFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assigneeFirstName, true), gettype($assigneeFirstName)), __LINE__);
        }
        $this->AssigneeFirstName = $assigneeFirstName;
        return $this;
    }
    /**
     * Get AssigneeLastName value
     * @return string|null
     */
    public function getAssigneeLastName()
    {
        return $this->AssigneeLastName;
    }
    /**
     * Set AssigneeLastName value
     * @param string $assigneeLastName
     * @return \StructType\SupplierRFPAssignmentHistoryDetail
     */
    public function setAssigneeLastName($assigneeLastName = null)
    {
        // validation for constraint: string
        if (!is_null($assigneeLastName) && !is_string($assigneeLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assigneeLastName, true), gettype($assigneeLastName)), __LINE__);
        }
        $this->AssigneeLastName = $assigneeLastName;
        return $this;
    }
    /**
     * Get AssigneeEmailAddress value
     * @return string|null
     */
    public function getAssigneeEmailAddress()
    {
        return $this->AssigneeEmailAddress;
    }
    /**
     * Set AssigneeEmailAddress value
     * @param string $assigneeEmailAddress
     * @return \StructType\SupplierRFPAssignmentHistoryDetail
     */
    public function setAssigneeEmailAddress($assigneeEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($assigneeEmailAddress) && !is_string($assigneeEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assigneeEmailAddress, true), gettype($assigneeEmailAddress)), __LINE__);
        }
        $this->AssigneeEmailAddress = $assigneeEmailAddress;
        return $this;
    }
    /**
     * Get AssignorEmailAddress value
     * @return string|null
     */
    public function getAssignorEmailAddress()
    {
        return $this->AssignorEmailAddress;
    }
    /**
     * Set AssignorEmailAddress value
     * @param string $assignorEmailAddress
     * @return \StructType\SupplierRFPAssignmentHistoryDetail
     */
    public function setAssignorEmailAddress($assignorEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($assignorEmailAddress) && !is_string($assignorEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignorEmailAddress, true), gettype($assignorEmailAddress)), __LINE__);
        }
        $this->AssignorEmailAddress = $assignorEmailAddress;
        return $this;
    }
    /**
     * Get AssignmentStatus value
     * @return string|null
     */
    public function getAssignmentStatus()
    {
        return $this->AssignmentStatus;
    }
    /**
     * Set AssignmentStatus value
     * @param string $assignmentStatus
     * @return \StructType\SupplierRFPAssignmentHistoryDetail
     */
    public function setAssignmentStatus($assignmentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($assignmentStatus) && !is_string($assignmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignmentStatus, true), gettype($assignmentStatus)), __LINE__);
        }
        $this->AssignmentStatus = $assignmentStatus;
        return $this;
    }
    /**
     * Get AssignmentMessage value
     * @return string|null
     */
    public function getAssignmentMessage()
    {
        return $this->AssignmentMessage;
    }
    /**
     * Set AssignmentMessage value
     * @param string $assignmentMessage
     * @return \StructType\SupplierRFPAssignmentHistoryDetail
     */
    public function setAssignmentMessage($assignmentMessage = null)
    {
        // validation for constraint: string
        if (!is_null($assignmentMessage) && !is_string($assignmentMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignmentMessage, true), gettype($assignmentMessage)), __LINE__);
        }
        $this->AssignmentMessage = $assignmentMessage;
        return $this;
    }
    /**
     * Get CurrentAssignee value
     * @return bool|null
     */
    public function getCurrentAssignee()
    {
        return $this->CurrentAssignee;
    }
    /**
     * Set CurrentAssignee value
     * @param bool $currentAssignee
     * @return \StructType\SupplierRFPAssignmentHistoryDetail
     */
    public function setCurrentAssignee($currentAssignee = null)
    {
        // validation for constraint: boolean
        if (!is_null($currentAssignee) && !is_bool($currentAssignee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($currentAssignee, true), gettype($currentAssignee)), __LINE__);
        }
        $this->CurrentAssignee = $currentAssignee;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SupplierRFPAssignmentHistoryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
