<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierRFP StructType
 * @subpackage Structs
 */
class SupplierRFP extends CvObject
{
    /**
     * The EventInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SupplierRFPEventInfo
     */
    public $EventInfo;
    /**
     * The AlternateDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFPAlternateDate[]
     */
    public $AlternateDates;
    /**
     * The OrganizationInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RFPOrganizationInfo
     */
    public $OrganizationInfo;
    /**
     * The KeyContactInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RFPKeyContactInfo
     */
    public $KeyContactInfo;
    /**
     * The EventRequirementInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RFPEventRequirementInfo
     */
    public $EventRequirementInfo;
    /**
     * The SleepRoomInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RFPSleepRoomInfo
     */
    public $SleepRoomInfo;
    /**
     * The AttachmentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFPAttachmentDetail[]
     */
    public $AttachmentDetail;
    /**
     * The QuestionDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFPQuestionDetail[]
     */
    public $QuestionDetail;
    /**
     * The DinnerInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RFPDinnerInfo
     */
    public $DinnerInfo;
    /**
     * The SupplierDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierRFPInfoDetail[]
     */
    public $SupplierDetail;
    /**
     * The RecipientDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierRFPRecipientDetail[]
     */
    public $RecipientDetail;
    /**
     * The ForwardHistoryDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierRFPForwardHistoryDetail[]
     */
    public $ForwardHistoryDetail;
    /**
     * The AssignmentHistoryDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierRFPAssignmentHistoryDetail[]
     */
    public $AssignmentHistoryDetail;
    /**
     * The RFPType
     * @var string
     */
    public $RFPType;
    /**
     * The RFPStatus
     * @var string
     */
    public $RFPStatus;
    /**
     * The RFPCode
     * @var string
     */
    public $RFPCode;
    /**
     * The RFPName
     * @var string
     */
    public $RFPName;
    /**
     * The QuickRFP
     * @var bool
     */
    public $QuickRFP;
    /**
     * The EventId
     * @var string
     */
    public $EventId;
    /**
     * The EventCode
     * @var string
     */
    public $EventCode;
    /**
     * The EventTitle
     * @var string
     */
    public $EventTitle;
    /**
     * The ResponseDueDate
     * @var string
     */
    public $ResponseDueDate;
    /**
     * The DecisionDate
     * @var string
     */
    public $DecisionDate;
    /**
     * The CancelledDate
     * @var string
     */
    public $CancelledDate;
    /**
     * The CancelReason
     * @var string
     */
    public $CancelReason;
    /**
     * The CancelReasonComments
     * @var string
     */
    public $CancelReasonComments;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The RFPDescription
     * @var string
     */
    public $RFPDescription;
    /**
     * The DecisionFactors
     * @var string
     */
    public $DecisionFactors;
    /**
     * The Commissionable
     * @var bool
     */
    public $Commissionable;
    /**
     * The CommissionRate
     * @var int
     */
    public $CommissionRate;
    /**
     * The ReceivePackageRatesResponse
     * @var bool
     */
    public $ReceivePackageRatesResponse;
    /**
     * The RFPRating
     * @var float
     */
    public $RFPRating;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The CityWideFlag
     * @var bool
     */
    public $CityWideFlag;
    /**
     * The AcceptRebates
     * @var bool
     */
    public $AcceptRebates;
    /**
     * The Rebate
     * @var float
     */
    public $Rebate;
    /**
     * The RebateType
     * @var string
     */
    public $RebateType;
    /**
     * Constructor method for SupplierRFP
     * @uses SupplierRFP::setEventInfo()
     * @uses SupplierRFP::setAlternateDates()
     * @uses SupplierRFP::setOrganizationInfo()
     * @uses SupplierRFP::setKeyContactInfo()
     * @uses SupplierRFP::setEventRequirementInfo()
     * @uses SupplierRFP::setSleepRoomInfo()
     * @uses SupplierRFP::setAttachmentDetail()
     * @uses SupplierRFP::setQuestionDetail()
     * @uses SupplierRFP::setDinnerInfo()
     * @uses SupplierRFP::setSupplierDetail()
     * @uses SupplierRFP::setRecipientDetail()
     * @uses SupplierRFP::setForwardHistoryDetail()
     * @uses SupplierRFP::setAssignmentHistoryDetail()
     * @uses SupplierRFP::setRFPType()
     * @uses SupplierRFP::setRFPStatus()
     * @uses SupplierRFP::setRFPCode()
     * @uses SupplierRFP::setRFPName()
     * @uses SupplierRFP::setQuickRFP()
     * @uses SupplierRFP::setEventId()
     * @uses SupplierRFP::setEventCode()
     * @uses SupplierRFP::setEventTitle()
     * @uses SupplierRFP::setResponseDueDate()
     * @uses SupplierRFP::setDecisionDate()
     * @uses SupplierRFP::setCancelledDate()
     * @uses SupplierRFP::setCancelReason()
     * @uses SupplierRFP::setCancelReasonComments()
     * @uses SupplierRFP::setCurrency()
     * @uses SupplierRFP::setRFPDescription()
     * @uses SupplierRFP::setDecisionFactors()
     * @uses SupplierRFP::setCommissionable()
     * @uses SupplierRFP::setCommissionRate()
     * @uses SupplierRFP::setReceivePackageRatesResponse()
     * @uses SupplierRFP::setRFPRating()
     * @uses SupplierRFP::setLastModifiedDate()
     * @uses SupplierRFP::setCityWideFlag()
     * @uses SupplierRFP::setAcceptRebates()
     * @uses SupplierRFP::setRebate()
     * @uses SupplierRFP::setRebateType()
     * @param \StructType\SupplierRFPEventInfo $eventInfo
     * @param \StructType\RFPAlternateDate[] $alternateDates
     * @param \StructType\RFPOrganizationInfo $organizationInfo
     * @param \StructType\RFPKeyContactInfo $keyContactInfo
     * @param \StructType\RFPEventRequirementInfo $eventRequirementInfo
     * @param \StructType\RFPSleepRoomInfo $sleepRoomInfo
     * @param \StructType\RFPAttachmentDetail[] $attachmentDetail
     * @param \StructType\RFPQuestionDetail[] $questionDetail
     * @param \StructType\RFPDinnerInfo $dinnerInfo
     * @param \StructType\SupplierRFPInfoDetail[] $supplierDetail
     * @param \StructType\SupplierRFPRecipientDetail[] $recipientDetail
     * @param \StructType\SupplierRFPForwardHistoryDetail[] $forwardHistoryDetail
     * @param \StructType\SupplierRFPAssignmentHistoryDetail[] $assignmentHistoryDetail
     * @param string $rFPType
     * @param string $rFPStatus
     * @param string $rFPCode
     * @param string $rFPName
     * @param bool $quickRFP
     * @param string $eventId
     * @param string $eventCode
     * @param string $eventTitle
     * @param string $responseDueDate
     * @param string $decisionDate
     * @param string $cancelledDate
     * @param string $cancelReason
     * @param string $cancelReasonComments
     * @param string $currency
     * @param string $rFPDescription
     * @param string $decisionFactors
     * @param bool $commissionable
     * @param int $commissionRate
     * @param bool $receivePackageRatesResponse
     * @param float $rFPRating
     * @param string $lastModifiedDate
     * @param bool $cityWideFlag
     * @param bool $acceptRebates
     * @param float $rebate
     * @param string $rebateType
     */
    public function __construct(\StructType\SupplierRFPEventInfo $eventInfo = null, array $alternateDates = array(), \StructType\RFPOrganizationInfo $organizationInfo = null, \StructType\RFPKeyContactInfo $keyContactInfo = null, \StructType\RFPEventRequirementInfo $eventRequirementInfo = null, \StructType\RFPSleepRoomInfo $sleepRoomInfo = null, array $attachmentDetail = array(), array $questionDetail = array(), \StructType\RFPDinnerInfo $dinnerInfo = null, array $supplierDetail = array(), array $recipientDetail = array(), array $forwardHistoryDetail = array(), array $assignmentHistoryDetail = array(), $rFPType = null, $rFPStatus = null, $rFPCode = null, $rFPName = null, $quickRFP = null, $eventId = null, $eventCode = null, $eventTitle = null, $responseDueDate = null, $decisionDate = null, $cancelledDate = null, $cancelReason = null, $cancelReasonComments = null, $currency = null, $rFPDescription = null, $decisionFactors = null, $commissionable = null, $commissionRate = null, $receivePackageRatesResponse = null, $rFPRating = null, $lastModifiedDate = null, $cityWideFlag = null, $acceptRebates = null, $rebate = null, $rebateType = null)
    {
        $this
            ->setEventInfo($eventInfo)
            ->setAlternateDates($alternateDates)
            ->setOrganizationInfo($organizationInfo)
            ->setKeyContactInfo($keyContactInfo)
            ->setEventRequirementInfo($eventRequirementInfo)
            ->setSleepRoomInfo($sleepRoomInfo)
            ->setAttachmentDetail($attachmentDetail)
            ->setQuestionDetail($questionDetail)
            ->setDinnerInfo($dinnerInfo)
            ->setSupplierDetail($supplierDetail)
            ->setRecipientDetail($recipientDetail)
            ->setForwardHistoryDetail($forwardHistoryDetail)
            ->setAssignmentHistoryDetail($assignmentHistoryDetail)
            ->setRFPType($rFPType)
            ->setRFPStatus($rFPStatus)
            ->setRFPCode($rFPCode)
            ->setRFPName($rFPName)
            ->setQuickRFP($quickRFP)
            ->setEventId($eventId)
            ->setEventCode($eventCode)
            ->setEventTitle($eventTitle)
            ->setResponseDueDate($responseDueDate)
            ->setDecisionDate($decisionDate)
            ->setCancelledDate($cancelledDate)
            ->setCancelReason($cancelReason)
            ->setCancelReasonComments($cancelReasonComments)
            ->setCurrency($currency)
            ->setRFPDescription($rFPDescription)
            ->setDecisionFactors($decisionFactors)
            ->setCommissionable($commissionable)
            ->setCommissionRate($commissionRate)
            ->setReceivePackageRatesResponse($receivePackageRatesResponse)
            ->setRFPRating($rFPRating)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCityWideFlag($cityWideFlag)
            ->setAcceptRebates($acceptRebates)
            ->setRebate($rebate)
            ->setRebateType($rebateType);
    }
    /**
     * Get EventInfo value
     * @return \StructType\SupplierRFPEventInfo|null
     */
    public function getEventInfo()
    {
        return $this->EventInfo;
    }
    /**
     * Set EventInfo value
     * @param \StructType\SupplierRFPEventInfo $eventInfo
     * @return \StructType\SupplierRFP
     */
    public function setEventInfo(\StructType\SupplierRFPEventInfo $eventInfo = null)
    {
        $this->EventInfo = $eventInfo;
        return $this;
    }
    /**
     * Get AlternateDates value
     * @return \StructType\RFPAlternateDate[]|null
     */
    public function getAlternateDates()
    {
        return $this->AlternateDates;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternateDates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternateDates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternateDatesForArrayConstraintsFromSetAlternateDates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierRFPAlternateDatesItem) {
            // validation for constraint: itemType
            if (!$supplierRFPAlternateDatesItem instanceof \StructType\RFPAlternateDate) {
                $invalidValues[] = is_object($supplierRFPAlternateDatesItem) ? get_class($supplierRFPAlternateDatesItem) : sprintf('%s(%s)', gettype($supplierRFPAlternateDatesItem), var_export($supplierRFPAlternateDatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlternateDates property can only contain items of type \StructType\RFPAlternateDate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlternateDates value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPAlternateDate[] $alternateDates
     * @return \StructType\SupplierRFP
     */
    public function setAlternateDates(array $alternateDates = array())
    {
        // validation for constraint: array
        if ('' !== ($alternateDatesArrayErrorMessage = self::validateAlternateDatesForArrayConstraintsFromSetAlternateDates($alternateDates))) {
            throw new \InvalidArgumentException($alternateDatesArrayErrorMessage, __LINE__);
        }
        $this->AlternateDates = $alternateDates;
        return $this;
    }
    /**
     * Add item to AlternateDates value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPAlternateDate $item
     * @return \StructType\SupplierRFP
     */
    public function addToAlternateDates(\StructType\RFPAlternateDate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFPAlternateDate) {
            throw new \InvalidArgumentException(sprintf('The AlternateDates property can only contain items of type \StructType\RFPAlternateDate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AlternateDates[] = $item;
        return $this;
    }
    /**
     * Get OrganizationInfo value
     * @return \StructType\RFPOrganizationInfo|null
     */
    public function getOrganizationInfo()
    {
        return $this->OrganizationInfo;
    }
    /**
     * Set OrganizationInfo value
     * @param \StructType\RFPOrganizationInfo $organizationInfo
     * @return \StructType\SupplierRFP
     */
    public function setOrganizationInfo(\StructType\RFPOrganizationInfo $organizationInfo = null)
    {
        $this->OrganizationInfo = $organizationInfo;
        return $this;
    }
    /**
     * Get KeyContactInfo value
     * @return \StructType\RFPKeyContactInfo|null
     */
    public function getKeyContactInfo()
    {
        return $this->KeyContactInfo;
    }
    /**
     * Set KeyContactInfo value
     * @param \StructType\RFPKeyContactInfo $keyContactInfo
     * @return \StructType\SupplierRFP
     */
    public function setKeyContactInfo(\StructType\RFPKeyContactInfo $keyContactInfo = null)
    {
        $this->KeyContactInfo = $keyContactInfo;
        return $this;
    }
    /**
     * Get EventRequirementInfo value
     * @return \StructType\RFPEventRequirementInfo|null
     */
    public function getEventRequirementInfo()
    {
        return $this->EventRequirementInfo;
    }
    /**
     * Set EventRequirementInfo value
     * @param \StructType\RFPEventRequirementInfo $eventRequirementInfo
     * @return \StructType\SupplierRFP
     */
    public function setEventRequirementInfo(\StructType\RFPEventRequirementInfo $eventRequirementInfo = null)
    {
        $this->EventRequirementInfo = $eventRequirementInfo;
        return $this;
    }
    /**
     * Get SleepRoomInfo value
     * @return \StructType\RFPSleepRoomInfo|null
     */
    public function getSleepRoomInfo()
    {
        return $this->SleepRoomInfo;
    }
    /**
     * Set SleepRoomInfo value
     * @param \StructType\RFPSleepRoomInfo $sleepRoomInfo
     * @return \StructType\SupplierRFP
     */
    public function setSleepRoomInfo(\StructType\RFPSleepRoomInfo $sleepRoomInfo = null)
    {
        $this->SleepRoomInfo = $sleepRoomInfo;
        return $this;
    }
    /**
     * Get AttachmentDetail value
     * @return \StructType\RFPAttachmentDetail[]|null
     */
    public function getAttachmentDetail()
    {
        return $this->AttachmentDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachmentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachmentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentDetailForArrayConstraintsFromSetAttachmentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierRFPAttachmentDetailItem) {
            // validation for constraint: itemType
            if (!$supplierRFPAttachmentDetailItem instanceof \StructType\RFPAttachmentDetail) {
                $invalidValues[] = is_object($supplierRFPAttachmentDetailItem) ? get_class($supplierRFPAttachmentDetailItem) : sprintf('%s(%s)', gettype($supplierRFPAttachmentDetailItem), var_export($supplierRFPAttachmentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AttachmentDetail property can only contain items of type \StructType\RFPAttachmentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AttachmentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPAttachmentDetail[] $attachmentDetail
     * @return \StructType\SupplierRFP
     */
    public function setAttachmentDetail(array $attachmentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentDetailArrayErrorMessage = self::validateAttachmentDetailForArrayConstraintsFromSetAttachmentDetail($attachmentDetail))) {
            throw new \InvalidArgumentException($attachmentDetailArrayErrorMessage, __LINE__);
        }
        $this->AttachmentDetail = $attachmentDetail;
        return $this;
    }
    /**
     * Add item to AttachmentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPAttachmentDetail $item
     * @return \StructType\SupplierRFP
     */
    public function addToAttachmentDetail(\StructType\RFPAttachmentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFPAttachmentDetail) {
            throw new \InvalidArgumentException(sprintf('The AttachmentDetail property can only contain items of type \StructType\RFPAttachmentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AttachmentDetail[] = $item;
        return $this;
    }
    /**
     * Get QuestionDetail value
     * @return \StructType\RFPQuestionDetail[]|null
     */
    public function getQuestionDetail()
    {
        return $this->QuestionDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setQuestionDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuestionDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuestionDetailForArrayConstraintsFromSetQuestionDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierRFPQuestionDetailItem) {
            // validation for constraint: itemType
            if (!$supplierRFPQuestionDetailItem instanceof \StructType\RFPQuestionDetail) {
                $invalidValues[] = is_object($supplierRFPQuestionDetailItem) ? get_class($supplierRFPQuestionDetailItem) : sprintf('%s(%s)', gettype($supplierRFPQuestionDetailItem), var_export($supplierRFPQuestionDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The QuestionDetail property can only contain items of type \StructType\RFPQuestionDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set QuestionDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPQuestionDetail[] $questionDetail
     * @return \StructType\SupplierRFP
     */
    public function setQuestionDetail(array $questionDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($questionDetailArrayErrorMessage = self::validateQuestionDetailForArrayConstraintsFromSetQuestionDetail($questionDetail))) {
            throw new \InvalidArgumentException($questionDetailArrayErrorMessage, __LINE__);
        }
        $this->QuestionDetail = $questionDetail;
        return $this;
    }
    /**
     * Add item to QuestionDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPQuestionDetail $item
     * @return \StructType\SupplierRFP
     */
    public function addToQuestionDetail(\StructType\RFPQuestionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFPQuestionDetail) {
            throw new \InvalidArgumentException(sprintf('The QuestionDetail property can only contain items of type \StructType\RFPQuestionDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->QuestionDetail[] = $item;
        return $this;
    }
    /**
     * Get DinnerInfo value
     * @return \StructType\RFPDinnerInfo|null
     */
    public function getDinnerInfo()
    {
        return $this->DinnerInfo;
    }
    /**
     * Set DinnerInfo value
     * @param \StructType\RFPDinnerInfo $dinnerInfo
     * @return \StructType\SupplierRFP
     */
    public function setDinnerInfo(\StructType\RFPDinnerInfo $dinnerInfo = null)
    {
        $this->DinnerInfo = $dinnerInfo;
        return $this;
    }
    /**
     * Get SupplierDetail value
     * @return \StructType\SupplierRFPInfoDetail[]|null
     */
    public function getSupplierDetail()
    {
        return $this->SupplierDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplierDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplierDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplierDetailForArrayConstraintsFromSetSupplierDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierRFPSupplierDetailItem) {
            // validation for constraint: itemType
            if (!$supplierRFPSupplierDetailItem instanceof \StructType\SupplierRFPInfoDetail) {
                $invalidValues[] = is_object($supplierRFPSupplierDetailItem) ? get_class($supplierRFPSupplierDetailItem) : sprintf('%s(%s)', gettype($supplierRFPSupplierDetailItem), var_export($supplierRFPSupplierDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SupplierDetail property can only contain items of type \StructType\SupplierRFPInfoDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SupplierDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierRFPInfoDetail[] $supplierDetail
     * @return \StructType\SupplierRFP
     */
    public function setSupplierDetail(array $supplierDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($supplierDetailArrayErrorMessage = self::validateSupplierDetailForArrayConstraintsFromSetSupplierDetail($supplierDetail))) {
            throw new \InvalidArgumentException($supplierDetailArrayErrorMessage, __LINE__);
        }
        $this->SupplierDetail = $supplierDetail;
        return $this;
    }
    /**
     * Add item to SupplierDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierRFPInfoDetail $item
     * @return \StructType\SupplierRFP
     */
    public function addToSupplierDetail(\StructType\SupplierRFPInfoDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierRFPInfoDetail) {
            throw new \InvalidArgumentException(sprintf('The SupplierDetail property can only contain items of type \StructType\SupplierRFPInfoDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SupplierDetail[] = $item;
        return $this;
    }
    /**
     * Get RecipientDetail value
     * @return \StructType\SupplierRFPRecipientDetail[]|null
     */
    public function getRecipientDetail()
    {
        return $this->RecipientDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipientDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipientDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipientDetailForArrayConstraintsFromSetRecipientDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierRFPRecipientDetailItem) {
            // validation for constraint: itemType
            if (!$supplierRFPRecipientDetailItem instanceof \StructType\SupplierRFPRecipientDetail) {
                $invalidValues[] = is_object($supplierRFPRecipientDetailItem) ? get_class($supplierRFPRecipientDetailItem) : sprintf('%s(%s)', gettype($supplierRFPRecipientDetailItem), var_export($supplierRFPRecipientDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RecipientDetail property can only contain items of type \StructType\SupplierRFPRecipientDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RecipientDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierRFPRecipientDetail[] $recipientDetail
     * @return \StructType\SupplierRFP
     */
    public function setRecipientDetail(array $recipientDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($recipientDetailArrayErrorMessage = self::validateRecipientDetailForArrayConstraintsFromSetRecipientDetail($recipientDetail))) {
            throw new \InvalidArgumentException($recipientDetailArrayErrorMessage, __LINE__);
        }
        $this->RecipientDetail = $recipientDetail;
        return $this;
    }
    /**
     * Add item to RecipientDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierRFPRecipientDetail $item
     * @return \StructType\SupplierRFP
     */
    public function addToRecipientDetail(\StructType\SupplierRFPRecipientDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierRFPRecipientDetail) {
            throw new \InvalidArgumentException(sprintf('The RecipientDetail property can only contain items of type \StructType\SupplierRFPRecipientDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RecipientDetail[] = $item;
        return $this;
    }
    /**
     * Get ForwardHistoryDetail value
     * @return \StructType\SupplierRFPForwardHistoryDetail[]|null
     */
    public function getForwardHistoryDetail()
    {
        return $this->ForwardHistoryDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setForwardHistoryDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setForwardHistoryDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateForwardHistoryDetailForArrayConstraintsFromSetForwardHistoryDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierRFPForwardHistoryDetailItem) {
            // validation for constraint: itemType
            if (!$supplierRFPForwardHistoryDetailItem instanceof \StructType\SupplierRFPForwardHistoryDetail) {
                $invalidValues[] = is_object($supplierRFPForwardHistoryDetailItem) ? get_class($supplierRFPForwardHistoryDetailItem) : sprintf('%s(%s)', gettype($supplierRFPForwardHistoryDetailItem), var_export($supplierRFPForwardHistoryDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ForwardHistoryDetail property can only contain items of type \StructType\SupplierRFPForwardHistoryDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ForwardHistoryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierRFPForwardHistoryDetail[] $forwardHistoryDetail
     * @return \StructType\SupplierRFP
     */
    public function setForwardHistoryDetail(array $forwardHistoryDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($forwardHistoryDetailArrayErrorMessage = self::validateForwardHistoryDetailForArrayConstraintsFromSetForwardHistoryDetail($forwardHistoryDetail))) {
            throw new \InvalidArgumentException($forwardHistoryDetailArrayErrorMessage, __LINE__);
        }
        $this->ForwardHistoryDetail = $forwardHistoryDetail;
        return $this;
    }
    /**
     * Add item to ForwardHistoryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierRFPForwardHistoryDetail $item
     * @return \StructType\SupplierRFP
     */
    public function addToForwardHistoryDetail(\StructType\SupplierRFPForwardHistoryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierRFPForwardHistoryDetail) {
            throw new \InvalidArgumentException(sprintf('The ForwardHistoryDetail property can only contain items of type \StructType\SupplierRFPForwardHistoryDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ForwardHistoryDetail[] = $item;
        return $this;
    }
    /**
     * Get AssignmentHistoryDetail value
     * @return \StructType\SupplierRFPAssignmentHistoryDetail[]|null
     */
    public function getAssignmentHistoryDetail()
    {
        return $this->AssignmentHistoryDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAssignmentHistoryDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssignmentHistoryDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssignmentHistoryDetailForArrayConstraintsFromSetAssignmentHistoryDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierRFPAssignmentHistoryDetailItem) {
            // validation for constraint: itemType
            if (!$supplierRFPAssignmentHistoryDetailItem instanceof \StructType\SupplierRFPAssignmentHistoryDetail) {
                $invalidValues[] = is_object($supplierRFPAssignmentHistoryDetailItem) ? get_class($supplierRFPAssignmentHistoryDetailItem) : sprintf('%s(%s)', gettype($supplierRFPAssignmentHistoryDetailItem), var_export($supplierRFPAssignmentHistoryDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AssignmentHistoryDetail property can only contain items of type \StructType\SupplierRFPAssignmentHistoryDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AssignmentHistoryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierRFPAssignmentHistoryDetail[] $assignmentHistoryDetail
     * @return \StructType\SupplierRFP
     */
    public function setAssignmentHistoryDetail(array $assignmentHistoryDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($assignmentHistoryDetailArrayErrorMessage = self::validateAssignmentHistoryDetailForArrayConstraintsFromSetAssignmentHistoryDetail($assignmentHistoryDetail))) {
            throw new \InvalidArgumentException($assignmentHistoryDetailArrayErrorMessage, __LINE__);
        }
        $this->AssignmentHistoryDetail = $assignmentHistoryDetail;
        return $this;
    }
    /**
     * Add item to AssignmentHistoryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierRFPAssignmentHistoryDetail $item
     * @return \StructType\SupplierRFP
     */
    public function addToAssignmentHistoryDetail(\StructType\SupplierRFPAssignmentHistoryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierRFPAssignmentHistoryDetail) {
            throw new \InvalidArgumentException(sprintf('The AssignmentHistoryDetail property can only contain items of type \StructType\SupplierRFPAssignmentHistoryDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AssignmentHistoryDetail[] = $item;
        return $this;
    }
    /**
     * Get RFPType value
     * @return string|null
     */
    public function getRFPType()
    {
        return $this->RFPType;
    }
    /**
     * Set RFPType value
     * @param string $rFPType
     * @return \StructType\SupplierRFP
     */
    public function setRFPType($rFPType = null)
    {
        // validation for constraint: string
        if (!is_null($rFPType) && !is_string($rFPType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPType, true), gettype($rFPType)), __LINE__);
        }
        $this->RFPType = $rFPType;
        return $this;
    }
    /**
     * Get RFPStatus value
     * @return string|null
     */
    public function getRFPStatus()
    {
        return $this->RFPStatus;
    }
    /**
     * Set RFPStatus value
     * @param string $rFPStatus
     * @return \StructType\SupplierRFP
     */
    public function setRFPStatus($rFPStatus = null)
    {
        // validation for constraint: string
        if (!is_null($rFPStatus) && !is_string($rFPStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPStatus, true), gettype($rFPStatus)), __LINE__);
        }
        $this->RFPStatus = $rFPStatus;
        return $this;
    }
    /**
     * Get RFPCode value
     * @return string|null
     */
    public function getRFPCode()
    {
        return $this->RFPCode;
    }
    /**
     * Set RFPCode value
     * @param string $rFPCode
     * @return \StructType\SupplierRFP
     */
    public function setRFPCode($rFPCode = null)
    {
        // validation for constraint: string
        if (!is_null($rFPCode) && !is_string($rFPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPCode, true), gettype($rFPCode)), __LINE__);
        }
        $this->RFPCode = $rFPCode;
        return $this;
    }
    /**
     * Get RFPName value
     * @return string|null
     */
    public function getRFPName()
    {
        return $this->RFPName;
    }
    /**
     * Set RFPName value
     * @param string $rFPName
     * @return \StructType\SupplierRFP
     */
    public function setRFPName($rFPName = null)
    {
        // validation for constraint: string
        if (!is_null($rFPName) && !is_string($rFPName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPName, true), gettype($rFPName)), __LINE__);
        }
        $this->RFPName = $rFPName;
        return $this;
    }
    /**
     * Get QuickRFP value
     * @return bool|null
     */
    public function getQuickRFP()
    {
        return $this->QuickRFP;
    }
    /**
     * Set QuickRFP value
     * @param bool $quickRFP
     * @return \StructType\SupplierRFP
     */
    public function setQuickRFP($quickRFP = null)
    {
        // validation for constraint: boolean
        if (!is_null($quickRFP) && !is_bool($quickRFP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($quickRFP, true), gettype($quickRFP)), __LINE__);
        }
        $this->QuickRFP = $quickRFP;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\SupplierRFP
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\SupplierRFP
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get EventTitle value
     * @return string|null
     */
    public function getEventTitle()
    {
        return $this->EventTitle;
    }
    /**
     * Set EventTitle value
     * @param string $eventTitle
     * @return \StructType\SupplierRFP
     */
    public function setEventTitle($eventTitle = null)
    {
        // validation for constraint: string
        if (!is_null($eventTitle) && !is_string($eventTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTitle, true), gettype($eventTitle)), __LINE__);
        }
        $this->EventTitle = $eventTitle;
        return $this;
    }
    /**
     * Get ResponseDueDate value
     * @return string|null
     */
    public function getResponseDueDate()
    {
        return $this->ResponseDueDate;
    }
    /**
     * Set ResponseDueDate value
     * @param string $responseDueDate
     * @return \StructType\SupplierRFP
     */
    public function setResponseDueDate($responseDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($responseDueDate) && !is_string($responseDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseDueDate, true), gettype($responseDueDate)), __LINE__);
        }
        $this->ResponseDueDate = $responseDueDate;
        return $this;
    }
    /**
     * Get DecisionDate value
     * @return string|null
     */
    public function getDecisionDate()
    {
        return $this->DecisionDate;
    }
    /**
     * Set DecisionDate value
     * @param string $decisionDate
     * @return \StructType\SupplierRFP
     */
    public function setDecisionDate($decisionDate = null)
    {
        // validation for constraint: string
        if (!is_null($decisionDate) && !is_string($decisionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decisionDate, true), gettype($decisionDate)), __LINE__);
        }
        $this->DecisionDate = $decisionDate;
        return $this;
    }
    /**
     * Get CancelledDate value
     * @return string|null
     */
    public function getCancelledDate()
    {
        return $this->CancelledDate;
    }
    /**
     * Set CancelledDate value
     * @param string $cancelledDate
     * @return \StructType\SupplierRFP
     */
    public function setCancelledDate($cancelledDate = null)
    {
        // validation for constraint: string
        if (!is_null($cancelledDate) && !is_string($cancelledDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelledDate, true), gettype($cancelledDate)), __LINE__);
        }
        $this->CancelledDate = $cancelledDate;
        return $this;
    }
    /**
     * Get CancelReason value
     * @return string|null
     */
    public function getCancelReason()
    {
        return $this->CancelReason;
    }
    /**
     * Set CancelReason value
     * @param string $cancelReason
     * @return \StructType\SupplierRFP
     */
    public function setCancelReason($cancelReason = null)
    {
        // validation for constraint: string
        if (!is_null($cancelReason) && !is_string($cancelReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelReason, true), gettype($cancelReason)), __LINE__);
        }
        $this->CancelReason = $cancelReason;
        return $this;
    }
    /**
     * Get CancelReasonComments value
     * @return string|null
     */
    public function getCancelReasonComments()
    {
        return $this->CancelReasonComments;
    }
    /**
     * Set CancelReasonComments value
     * @param string $cancelReasonComments
     * @return \StructType\SupplierRFP
     */
    public function setCancelReasonComments($cancelReasonComments = null)
    {
        // validation for constraint: string
        if (!is_null($cancelReasonComments) && !is_string($cancelReasonComments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelReasonComments, true), gettype($cancelReasonComments)), __LINE__);
        }
        $this->CancelReasonComments = $cancelReasonComments;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\SupplierRFP
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get RFPDescription value
     * @return string|null
     */
    public function getRFPDescription()
    {
        return $this->RFPDescription;
    }
    /**
     * Set RFPDescription value
     * @param string $rFPDescription
     * @return \StructType\SupplierRFP
     */
    public function setRFPDescription($rFPDescription = null)
    {
        // validation for constraint: string
        if (!is_null($rFPDescription) && !is_string($rFPDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPDescription, true), gettype($rFPDescription)), __LINE__);
        }
        $this->RFPDescription = $rFPDescription;
        return $this;
    }
    /**
     * Get DecisionFactors value
     * @return string|null
     */
    public function getDecisionFactors()
    {
        return $this->DecisionFactors;
    }
    /**
     * Set DecisionFactors value
     * @param string $decisionFactors
     * @return \StructType\SupplierRFP
     */
    public function setDecisionFactors($decisionFactors = null)
    {
        // validation for constraint: string
        if (!is_null($decisionFactors) && !is_string($decisionFactors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decisionFactors, true), gettype($decisionFactors)), __LINE__);
        }
        $this->DecisionFactors = $decisionFactors;
        return $this;
    }
    /**
     * Get Commissionable value
     * @return bool|null
     */
    public function getCommissionable()
    {
        return $this->Commissionable;
    }
    /**
     * Set Commissionable value
     * @param bool $commissionable
     * @return \StructType\SupplierRFP
     */
    public function setCommissionable($commissionable = null)
    {
        // validation for constraint: boolean
        if (!is_null($commissionable) && !is_bool($commissionable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($commissionable, true), gettype($commissionable)), __LINE__);
        }
        $this->Commissionable = $commissionable;
        return $this;
    }
    /**
     * Get CommissionRate value
     * @return int|null
     */
    public function getCommissionRate()
    {
        return $this->CommissionRate;
    }
    /**
     * Set CommissionRate value
     * @param int $commissionRate
     * @return \StructType\SupplierRFP
     */
    public function setCommissionRate($commissionRate = null)
    {
        // validation for constraint: int
        if (!is_null($commissionRate) && !(is_int($commissionRate) || ctype_digit($commissionRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commissionRate, true), gettype($commissionRate)), __LINE__);
        }
        $this->CommissionRate = $commissionRate;
        return $this;
    }
    /**
     * Get ReceivePackageRatesResponse value
     * @return bool|null
     */
    public function getReceivePackageRatesResponse()
    {
        return $this->ReceivePackageRatesResponse;
    }
    /**
     * Set ReceivePackageRatesResponse value
     * @param bool $receivePackageRatesResponse
     * @return \StructType\SupplierRFP
     */
    public function setReceivePackageRatesResponse($receivePackageRatesResponse = null)
    {
        // validation for constraint: boolean
        if (!is_null($receivePackageRatesResponse) && !is_bool($receivePackageRatesResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($receivePackageRatesResponse, true), gettype($receivePackageRatesResponse)), __LINE__);
        }
        $this->ReceivePackageRatesResponse = $receivePackageRatesResponse;
        return $this;
    }
    /**
     * Get RFPRating value
     * @return float|null
     */
    public function getRFPRating()
    {
        return $this->RFPRating;
    }
    /**
     * Set RFPRating value
     * @param float $rFPRating
     * @return \StructType\SupplierRFP
     */
    public function setRFPRating($rFPRating = null)
    {
        // validation for constraint: float
        if (!is_null($rFPRating) && !(is_float($rFPRating) || is_numeric($rFPRating))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rFPRating, true), gettype($rFPRating)), __LINE__);
        }
        $this->RFPRating = $rFPRating;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\SupplierRFP
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get CityWideFlag value
     * @return bool|null
     */
    public function getCityWideFlag()
    {
        return $this->CityWideFlag;
    }
    /**
     * Set CityWideFlag value
     * @param bool $cityWideFlag
     * @return \StructType\SupplierRFP
     */
    public function setCityWideFlag($cityWideFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($cityWideFlag) && !is_bool($cityWideFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cityWideFlag, true), gettype($cityWideFlag)), __LINE__);
        }
        $this->CityWideFlag = $cityWideFlag;
        return $this;
    }
    /**
     * Get AcceptRebates value
     * @return bool|null
     */
    public function getAcceptRebates()
    {
        return $this->AcceptRebates;
    }
    /**
     * Set AcceptRebates value
     * @param bool $acceptRebates
     * @return \StructType\SupplierRFP
     */
    public function setAcceptRebates($acceptRebates = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptRebates) && !is_bool($acceptRebates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($acceptRebates, true), gettype($acceptRebates)), __LINE__);
        }
        $this->AcceptRebates = $acceptRebates;
        return $this;
    }
    /**
     * Get Rebate value
     * @return float|null
     */
    public function getRebate()
    {
        return $this->Rebate;
    }
    /**
     * Set Rebate value
     * @param float $rebate
     * @return \StructType\SupplierRFP
     */
    public function setRebate($rebate = null)
    {
        // validation for constraint: float
        if (!is_null($rebate) && !(is_float($rebate) || is_numeric($rebate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rebate, true), gettype($rebate)), __LINE__);
        }
        $this->Rebate = $rebate;
        return $this;
    }
    /**
     * Get RebateType value
     * @return string|null
     */
    public function getRebateType()
    {
        return $this->RebateType;
    }
    /**
     * Set RebateType value
     * @param string $rebateType
     * @return \StructType\SupplierRFP
     */
    public function setRebateType($rebateType = null)
    {
        // validation for constraint: string
        if (!is_null($rebateType) && !is_string($rebateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rebateType, true), gettype($rebateType)), __LINE__);
        }
        $this->RebateType = $rebateType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SupplierRFP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
