<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierProposalVenueInfo StructType
 * @subpackage Structs
 */
class SupplierProposalVenueInfo extends AbstractStructBase
{
    /**
     * The VenueName
     * @var string
     */
    public $VenueName;
    /**
     * The VenueType
     * @var string
     */
    public $VenueType;
    /**
     * The VenueCode
     * @var string
     */
    public $VenueCode;
    /**
     * The SourceId
     * @var string
     */
    public $SourceId;
    /**
     * Constructor method for SupplierProposalVenueInfo
     * @uses SupplierProposalVenueInfo::setVenueName()
     * @uses SupplierProposalVenueInfo::setVenueType()
     * @uses SupplierProposalVenueInfo::setVenueCode()
     * @uses SupplierProposalVenueInfo::setSourceId()
     * @param string $venueName
     * @param string $venueType
     * @param string $venueCode
     * @param string $sourceId
     */
    public function __construct($venueName = null, $venueType = null, $venueCode = null, $sourceId = null)
    {
        $this
            ->setVenueName($venueName)
            ->setVenueType($venueType)
            ->setVenueCode($venueCode)
            ->setSourceId($sourceId);
    }
    /**
     * Get VenueName value
     * @return string|null
     */
    public function getVenueName()
    {
        return $this->VenueName;
    }
    /**
     * Set VenueName value
     * @param string $venueName
     * @return \StructType\SupplierProposalVenueInfo
     */
    public function setVenueName($venueName = null)
    {
        // validation for constraint: string
        if (!is_null($venueName) && !is_string($venueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueName, true), gettype($venueName)), __LINE__);
        }
        $this->VenueName = $venueName;
        return $this;
    }
    /**
     * Get VenueType value
     * @return string|null
     */
    public function getVenueType()
    {
        return $this->VenueType;
    }
    /**
     * Set VenueType value
     * @param string $venueType
     * @return \StructType\SupplierProposalVenueInfo
     */
    public function setVenueType($venueType = null)
    {
        // validation for constraint: string
        if (!is_null($venueType) && !is_string($venueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueType, true), gettype($venueType)), __LINE__);
        }
        $this->VenueType = $venueType;
        return $this;
    }
    /**
     * Get VenueCode value
     * @return string|null
     */
    public function getVenueCode()
    {
        return $this->VenueCode;
    }
    /**
     * Set VenueCode value
     * @param string $venueCode
     * @return \StructType\SupplierProposalVenueInfo
     */
    public function setVenueCode($venueCode = null)
    {
        // validation for constraint: string
        if (!is_null($venueCode) && !is_string($venueCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueCode, true), gettype($venueCode)), __LINE__);
        }
        $this->VenueCode = $venueCode;
        return $this;
    }
    /**
     * Get SourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->SourceId;
    }
    /**
     * Set SourceId value
     * @param string $sourceId
     * @return \StructType\SupplierProposalVenueInfo
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        $this->SourceId = $sourceId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SupplierProposalVenueInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
