<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierProposal StructType
 * @subpackage Structs
 */
class SupplierProposal extends CvObject
{
    /**
     * The VenueInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SupplierProposalVenueInfo
     */
    public $VenueInfo;
    /**
     * The EventInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProposalEventInfo
     */
    public $EventInfo;
    /**
     * The KeyContactInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProposalKeyContactInfo
     */
    public $KeyContactInfo;
    /**
     * The SleepRoomInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProposalSleepRoomInfo
     */
    public $SleepRoomInfo;
    /**
     * The EventRequirementsInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProposalEventRequirementsInfo
     */
    public $EventRequirementsInfo;
    /**
     * The AttachmentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProposalAttachmentDetail[]
     */
    public $AttachmentDetail;
    /**
     * The PackagePricingDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProposalPackagePricingDetail[]
     */
    public $PackagePricingDetail;
    /**
     * The SurveyDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProposalSurveyDetail[]
     */
    public $SurveyDetail;
    /**
     * The ConventionCenterInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConventionCenterInformation
     */
    public $ConventionCenterInfo;
    /**
     * The EventSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProposalEventSpaceInfo[]
     */
    public $EventSpace;
    /**
     * The AlternateSleepRoomAvailabilityDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProposalAlternateDateInfo[]
     */
    public $AlternateSleepRoomAvailabilityDetails;
    /**
     * The RFPId
     * @var string
     */
    public $RFPId;
    /**
     * The RFPType
     * @var string
     */
    public $RFPType;
    /**
     * The RFPStatus
     * @var string
     */
    public $RFPStatus;
    /**
     * The RFPCode
     * @var string
     */
    public $RFPCode;
    /**
     * The RFPName
     * @var string
     */
    public $RFPName;
    /**
     * The ProposalStatus
     * @var string
     */
    public $ProposalStatus;
    /**
     * The ProposalSentDate
     * @var string
     */
    public $ProposalSentDate;
    /**
     * The Commissionable
     * @var bool
     */
    public $Commissionable;
    /**
     * The CommissionRate
     * @var int
     */
    public $CommissionRate;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The CreatedBy
     * @var string
     */
    public $CreatedBy;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * The RoomSizeUnitOfMeasure
     * @var string
     */
    public $RoomSizeUnitOfMeasure;
    /**
     * The CeilingHeightUnitOfMeasure
     * @var string
     */
    public $CeilingHeightUnitOfMeasure;
    /**
     * Constructor method for SupplierProposal
     * @uses SupplierProposal::setVenueInfo()
     * @uses SupplierProposal::setEventInfo()
     * @uses SupplierProposal::setKeyContactInfo()
     * @uses SupplierProposal::setSleepRoomInfo()
     * @uses SupplierProposal::setEventRequirementsInfo()
     * @uses SupplierProposal::setAttachmentDetail()
     * @uses SupplierProposal::setPackagePricingDetail()
     * @uses SupplierProposal::setSurveyDetail()
     * @uses SupplierProposal::setConventionCenterInfo()
     * @uses SupplierProposal::setEventSpace()
     * @uses SupplierProposal::setAlternateSleepRoomAvailabilityDetails()
     * @uses SupplierProposal::setRFPId()
     * @uses SupplierProposal::setRFPType()
     * @uses SupplierProposal::setRFPStatus()
     * @uses SupplierProposal::setRFPCode()
     * @uses SupplierProposal::setRFPName()
     * @uses SupplierProposal::setProposalStatus()
     * @uses SupplierProposal::setProposalSentDate()
     * @uses SupplierProposal::setCommissionable()
     * @uses SupplierProposal::setCommissionRate()
     * @uses SupplierProposal::setCreatedDate()
     * @uses SupplierProposal::setCreatedBy()
     * @uses SupplierProposal::setLastModifiedDate()
     * @uses SupplierProposal::setLastModifiedBy()
     * @uses SupplierProposal::setRoomSizeUnitOfMeasure()
     * @uses SupplierProposal::setCeilingHeightUnitOfMeasure()
     * @param \StructType\SupplierProposalVenueInfo $venueInfo
     * @param \StructType\ProposalEventInfo $eventInfo
     * @param \StructType\ProposalKeyContactInfo $keyContactInfo
     * @param \StructType\ProposalSleepRoomInfo $sleepRoomInfo
     * @param \StructType\ProposalEventRequirementsInfo $eventRequirementsInfo
     * @param \StructType\ProposalAttachmentDetail[] $attachmentDetail
     * @param \StructType\ProposalPackagePricingDetail[] $packagePricingDetail
     * @param \StructType\ProposalSurveyDetail[] $surveyDetail
     * @param \StructType\ConventionCenterInformation $conventionCenterInfo
     * @param \StructType\ProposalEventSpaceInfo[] $eventSpace
     * @param \StructType\ProposalAlternateDateInfo[] $alternateSleepRoomAvailabilityDetails
     * @param string $rFPId
     * @param string $rFPType
     * @param string $rFPStatus
     * @param string $rFPCode
     * @param string $rFPName
     * @param string $proposalStatus
     * @param string $proposalSentDate
     * @param bool $commissionable
     * @param int $commissionRate
     * @param string $createdDate
     * @param string $createdBy
     * @param string $lastModifiedDate
     * @param string $lastModifiedBy
     * @param string $roomSizeUnitOfMeasure
     * @param string $ceilingHeightUnitOfMeasure
     */
    public function __construct(\StructType\SupplierProposalVenueInfo $venueInfo = null, \StructType\ProposalEventInfo $eventInfo = null, \StructType\ProposalKeyContactInfo $keyContactInfo = null, \StructType\ProposalSleepRoomInfo $sleepRoomInfo = null, \StructType\ProposalEventRequirementsInfo $eventRequirementsInfo = null, array $attachmentDetail = array(), array $packagePricingDetail = array(), array $surveyDetail = array(), \StructType\ConventionCenterInformation $conventionCenterInfo = null, array $eventSpace = array(), array $alternateSleepRoomAvailabilityDetails = array(), $rFPId = null, $rFPType = null, $rFPStatus = null, $rFPCode = null, $rFPName = null, $proposalStatus = null, $proposalSentDate = null, $commissionable = null, $commissionRate = null, $createdDate = null, $createdBy = null, $lastModifiedDate = null, $lastModifiedBy = null, $roomSizeUnitOfMeasure = null, $ceilingHeightUnitOfMeasure = null)
    {
        $this
            ->setVenueInfo($venueInfo)
            ->setEventInfo($eventInfo)
            ->setKeyContactInfo($keyContactInfo)
            ->setSleepRoomInfo($sleepRoomInfo)
            ->setEventRequirementsInfo($eventRequirementsInfo)
            ->setAttachmentDetail($attachmentDetail)
            ->setPackagePricingDetail($packagePricingDetail)
            ->setSurveyDetail($surveyDetail)
            ->setConventionCenterInfo($conventionCenterInfo)
            ->setEventSpace($eventSpace)
            ->setAlternateSleepRoomAvailabilityDetails($alternateSleepRoomAvailabilityDetails)
            ->setRFPId($rFPId)
            ->setRFPType($rFPType)
            ->setRFPStatus($rFPStatus)
            ->setRFPCode($rFPCode)
            ->setRFPName($rFPName)
            ->setProposalStatus($proposalStatus)
            ->setProposalSentDate($proposalSentDate)
            ->setCommissionable($commissionable)
            ->setCommissionRate($commissionRate)
            ->setCreatedDate($createdDate)
            ->setCreatedBy($createdBy)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastModifiedBy($lastModifiedBy)
            ->setRoomSizeUnitOfMeasure($roomSizeUnitOfMeasure)
            ->setCeilingHeightUnitOfMeasure($ceilingHeightUnitOfMeasure);
    }
    /**
     * Get VenueInfo value
     * @return \StructType\SupplierProposalVenueInfo|null
     */
    public function getVenueInfo()
    {
        return $this->VenueInfo;
    }
    /**
     * Set VenueInfo value
     * @param \StructType\SupplierProposalVenueInfo $venueInfo
     * @return \StructType\SupplierProposal
     */
    public function setVenueInfo(\StructType\SupplierProposalVenueInfo $venueInfo = null)
    {
        $this->VenueInfo = $venueInfo;
        return $this;
    }
    /**
     * Get EventInfo value
     * @return \StructType\ProposalEventInfo|null
     */
    public function getEventInfo()
    {
        return $this->EventInfo;
    }
    /**
     * Set EventInfo value
     * @param \StructType\ProposalEventInfo $eventInfo
     * @return \StructType\SupplierProposal
     */
    public function setEventInfo(\StructType\ProposalEventInfo $eventInfo = null)
    {
        $this->EventInfo = $eventInfo;
        return $this;
    }
    /**
     * Get KeyContactInfo value
     * @return \StructType\ProposalKeyContactInfo|null
     */
    public function getKeyContactInfo()
    {
        return $this->KeyContactInfo;
    }
    /**
     * Set KeyContactInfo value
     * @param \StructType\ProposalKeyContactInfo $keyContactInfo
     * @return \StructType\SupplierProposal
     */
    public function setKeyContactInfo(\StructType\ProposalKeyContactInfo $keyContactInfo = null)
    {
        $this->KeyContactInfo = $keyContactInfo;
        return $this;
    }
    /**
     * Get SleepRoomInfo value
     * @return \StructType\ProposalSleepRoomInfo|null
     */
    public function getSleepRoomInfo()
    {
        return $this->SleepRoomInfo;
    }
    /**
     * Set SleepRoomInfo value
     * @param \StructType\ProposalSleepRoomInfo $sleepRoomInfo
     * @return \StructType\SupplierProposal
     */
    public function setSleepRoomInfo(\StructType\ProposalSleepRoomInfo $sleepRoomInfo = null)
    {
        $this->SleepRoomInfo = $sleepRoomInfo;
        return $this;
    }
    /**
     * Get EventRequirementsInfo value
     * @return \StructType\ProposalEventRequirementsInfo|null
     */
    public function getEventRequirementsInfo()
    {
        return $this->EventRequirementsInfo;
    }
    /**
     * Set EventRequirementsInfo value
     * @param \StructType\ProposalEventRequirementsInfo $eventRequirementsInfo
     * @return \StructType\SupplierProposal
     */
    public function setEventRequirementsInfo(\StructType\ProposalEventRequirementsInfo $eventRequirementsInfo = null)
    {
        $this->EventRequirementsInfo = $eventRequirementsInfo;
        return $this;
    }
    /**
     * Get AttachmentDetail value
     * @return \StructType\ProposalAttachmentDetail[]|null
     */
    public function getAttachmentDetail()
    {
        return $this->AttachmentDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachmentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachmentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentDetailForArrayConstraintsFromSetAttachmentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierProposalAttachmentDetailItem) {
            // validation for constraint: itemType
            if (!$supplierProposalAttachmentDetailItem instanceof \StructType\ProposalAttachmentDetail) {
                $invalidValues[] = is_object($supplierProposalAttachmentDetailItem) ? get_class($supplierProposalAttachmentDetailItem) : sprintf('%s(%s)', gettype($supplierProposalAttachmentDetailItem), var_export($supplierProposalAttachmentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AttachmentDetail property can only contain items of type \StructType\ProposalAttachmentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AttachmentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalAttachmentDetail[] $attachmentDetail
     * @return \StructType\SupplierProposal
     */
    public function setAttachmentDetail(array $attachmentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentDetailArrayErrorMessage = self::validateAttachmentDetailForArrayConstraintsFromSetAttachmentDetail($attachmentDetail))) {
            throw new \InvalidArgumentException($attachmentDetailArrayErrorMessage, __LINE__);
        }
        $this->AttachmentDetail = $attachmentDetail;
        return $this;
    }
    /**
     * Add item to AttachmentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalAttachmentDetail $item
     * @return \StructType\SupplierProposal
     */
    public function addToAttachmentDetail(\StructType\ProposalAttachmentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProposalAttachmentDetail) {
            throw new \InvalidArgumentException(sprintf('The AttachmentDetail property can only contain items of type \StructType\ProposalAttachmentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AttachmentDetail[] = $item;
        return $this;
    }
    /**
     * Get PackagePricingDetail value
     * @return \StructType\ProposalPackagePricingDetail[]|null
     */
    public function getPackagePricingDetail()
    {
        return $this->PackagePricingDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setPackagePricingDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackagePricingDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackagePricingDetailForArrayConstraintsFromSetPackagePricingDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierProposalPackagePricingDetailItem) {
            // validation for constraint: itemType
            if (!$supplierProposalPackagePricingDetailItem instanceof \StructType\ProposalPackagePricingDetail) {
                $invalidValues[] = is_object($supplierProposalPackagePricingDetailItem) ? get_class($supplierProposalPackagePricingDetailItem) : sprintf('%s(%s)', gettype($supplierProposalPackagePricingDetailItem), var_export($supplierProposalPackagePricingDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackagePricingDetail property can only contain items of type \StructType\ProposalPackagePricingDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackagePricingDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalPackagePricingDetail[] $packagePricingDetail
     * @return \StructType\SupplierProposal
     */
    public function setPackagePricingDetail(array $packagePricingDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($packagePricingDetailArrayErrorMessage = self::validatePackagePricingDetailForArrayConstraintsFromSetPackagePricingDetail($packagePricingDetail))) {
            throw new \InvalidArgumentException($packagePricingDetailArrayErrorMessage, __LINE__);
        }
        $this->PackagePricingDetail = $packagePricingDetail;
        return $this;
    }
    /**
     * Add item to PackagePricingDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalPackagePricingDetail $item
     * @return \StructType\SupplierProposal
     */
    public function addToPackagePricingDetail(\StructType\ProposalPackagePricingDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProposalPackagePricingDetail) {
            throw new \InvalidArgumentException(sprintf('The PackagePricingDetail property can only contain items of type \StructType\ProposalPackagePricingDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackagePricingDetail[] = $item;
        return $this;
    }
    /**
     * Get SurveyDetail value
     * @return \StructType\ProposalSurveyDetail[]|null
     */
    public function getSurveyDetail()
    {
        return $this->SurveyDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setSurveyDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSurveyDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSurveyDetailForArrayConstraintsFromSetSurveyDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierProposalSurveyDetailItem) {
            // validation for constraint: itemType
            if (!$supplierProposalSurveyDetailItem instanceof \StructType\ProposalSurveyDetail) {
                $invalidValues[] = is_object($supplierProposalSurveyDetailItem) ? get_class($supplierProposalSurveyDetailItem) : sprintf('%s(%s)', gettype($supplierProposalSurveyDetailItem), var_export($supplierProposalSurveyDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SurveyDetail property can only contain items of type \StructType\ProposalSurveyDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalSurveyDetail[] $surveyDetail
     * @return \StructType\SupplierProposal
     */
    public function setSurveyDetail(array $surveyDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($surveyDetailArrayErrorMessage = self::validateSurveyDetailForArrayConstraintsFromSetSurveyDetail($surveyDetail))) {
            throw new \InvalidArgumentException($surveyDetailArrayErrorMessage, __LINE__);
        }
        $this->SurveyDetail = $surveyDetail;
        return $this;
    }
    /**
     * Add item to SurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalSurveyDetail $item
     * @return \StructType\SupplierProposal
     */
    public function addToSurveyDetail(\StructType\ProposalSurveyDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProposalSurveyDetail) {
            throw new \InvalidArgumentException(sprintf('The SurveyDetail property can only contain items of type \StructType\ProposalSurveyDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SurveyDetail[] = $item;
        return $this;
    }
    /**
     * Get ConventionCenterInfo value
     * @return \StructType\ConventionCenterInformation|null
     */
    public function getConventionCenterInfo()
    {
        return $this->ConventionCenterInfo;
    }
    /**
     * Set ConventionCenterInfo value
     * @param \StructType\ConventionCenterInformation $conventionCenterInfo
     * @return \StructType\SupplierProposal
     */
    public function setConventionCenterInfo(\StructType\ConventionCenterInformation $conventionCenterInfo = null)
    {
        $this->ConventionCenterInfo = $conventionCenterInfo;
        return $this;
    }
    /**
     * Get EventSpace value
     * @return \StructType\ProposalEventSpaceInfo[]|null
     */
    public function getEventSpace()
    {
        return $this->EventSpace;
    }
    /**
     * This method is responsible for validating the values passed to the setEventSpace method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventSpace method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventSpaceForArrayConstraintsFromSetEventSpace(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierProposalEventSpaceItem) {
            // validation for constraint: itemType
            if (!$supplierProposalEventSpaceItem instanceof \StructType\ProposalEventSpaceInfo) {
                $invalidValues[] = is_object($supplierProposalEventSpaceItem) ? get_class($supplierProposalEventSpaceItem) : sprintf('%s(%s)', gettype($supplierProposalEventSpaceItem), var_export($supplierProposalEventSpaceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventSpace property can only contain items of type \StructType\ProposalEventSpaceInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventSpace value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalEventSpaceInfo[] $eventSpace
     * @return \StructType\SupplierProposal
     */
    public function setEventSpace(array $eventSpace = array())
    {
        // validation for constraint: array
        if ('' !== ($eventSpaceArrayErrorMessage = self::validateEventSpaceForArrayConstraintsFromSetEventSpace($eventSpace))) {
            throw new \InvalidArgumentException($eventSpaceArrayErrorMessage, __LINE__);
        }
        $this->EventSpace = $eventSpace;
        return $this;
    }
    /**
     * Add item to EventSpace value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalEventSpaceInfo $item
     * @return \StructType\SupplierProposal
     */
    public function addToEventSpace(\StructType\ProposalEventSpaceInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProposalEventSpaceInfo) {
            throw new \InvalidArgumentException(sprintf('The EventSpace property can only contain items of type \StructType\ProposalEventSpaceInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventSpace[] = $item;
        return $this;
    }
    /**
     * Get AlternateSleepRoomAvailabilityDetails value
     * @return \StructType\ProposalAlternateDateInfo[]|null
     */
    public function getAlternateSleepRoomAvailabilityDetails()
    {
        return $this->AlternateSleepRoomAvailabilityDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternateSleepRoomAvailabilityDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternateSleepRoomAvailabilityDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternateSleepRoomAvailabilityDetailsForArrayConstraintsFromSetAlternateSleepRoomAvailabilityDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierProposalAlternateSleepRoomAvailabilityDetailsItem) {
            // validation for constraint: itemType
            if (!$supplierProposalAlternateSleepRoomAvailabilityDetailsItem instanceof \StructType\ProposalAlternateDateInfo) {
                $invalidValues[] = is_object($supplierProposalAlternateSleepRoomAvailabilityDetailsItem) ? get_class($supplierProposalAlternateSleepRoomAvailabilityDetailsItem) : sprintf('%s(%s)', gettype($supplierProposalAlternateSleepRoomAvailabilityDetailsItem), var_export($supplierProposalAlternateSleepRoomAvailabilityDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlternateSleepRoomAvailabilityDetails property can only contain items of type \StructType\ProposalAlternateDateInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlternateSleepRoomAvailabilityDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalAlternateDateInfo[] $alternateSleepRoomAvailabilityDetails
     * @return \StructType\SupplierProposal
     */
    public function setAlternateSleepRoomAvailabilityDetails(array $alternateSleepRoomAvailabilityDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($alternateSleepRoomAvailabilityDetailsArrayErrorMessage = self::validateAlternateSleepRoomAvailabilityDetailsForArrayConstraintsFromSetAlternateSleepRoomAvailabilityDetails($alternateSleepRoomAvailabilityDetails))) {
            throw new \InvalidArgumentException($alternateSleepRoomAvailabilityDetailsArrayErrorMessage, __LINE__);
        }
        $this->AlternateSleepRoomAvailabilityDetails = $alternateSleepRoomAvailabilityDetails;
        return $this;
    }
    /**
     * Add item to AlternateSleepRoomAvailabilityDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalAlternateDateInfo $item
     * @return \StructType\SupplierProposal
     */
    public function addToAlternateSleepRoomAvailabilityDetails(\StructType\ProposalAlternateDateInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProposalAlternateDateInfo) {
            throw new \InvalidArgumentException(sprintf('The AlternateSleepRoomAvailabilityDetails property can only contain items of type \StructType\ProposalAlternateDateInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AlternateSleepRoomAvailabilityDetails[] = $item;
        return $this;
    }
    /**
     * Get RFPId value
     * @return string|null
     */
    public function getRFPId()
    {
        return $this->RFPId;
    }
    /**
     * Set RFPId value
     * @param string $rFPId
     * @return \StructType\SupplierProposal
     */
    public function setRFPId($rFPId = null)
    {
        // validation for constraint: string
        if (!is_null($rFPId) && !is_string($rFPId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPId, true), gettype($rFPId)), __LINE__);
        }
        $this->RFPId = $rFPId;
        return $this;
    }
    /**
     * Get RFPType value
     * @return string|null
     */
    public function getRFPType()
    {
        return $this->RFPType;
    }
    /**
     * Set RFPType value
     * @param string $rFPType
     * @return \StructType\SupplierProposal
     */
    public function setRFPType($rFPType = null)
    {
        // validation for constraint: string
        if (!is_null($rFPType) && !is_string($rFPType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPType, true), gettype($rFPType)), __LINE__);
        }
        $this->RFPType = $rFPType;
        return $this;
    }
    /**
     * Get RFPStatus value
     * @return string|null
     */
    public function getRFPStatus()
    {
        return $this->RFPStatus;
    }
    /**
     * Set RFPStatus value
     * @param string $rFPStatus
     * @return \StructType\SupplierProposal
     */
    public function setRFPStatus($rFPStatus = null)
    {
        // validation for constraint: string
        if (!is_null($rFPStatus) && !is_string($rFPStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPStatus, true), gettype($rFPStatus)), __LINE__);
        }
        $this->RFPStatus = $rFPStatus;
        return $this;
    }
    /**
     * Get RFPCode value
     * @return string|null
     */
    public function getRFPCode()
    {
        return $this->RFPCode;
    }
    /**
     * Set RFPCode value
     * @param string $rFPCode
     * @return \StructType\SupplierProposal
     */
    public function setRFPCode($rFPCode = null)
    {
        // validation for constraint: string
        if (!is_null($rFPCode) && !is_string($rFPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPCode, true), gettype($rFPCode)), __LINE__);
        }
        $this->RFPCode = $rFPCode;
        return $this;
    }
    /**
     * Get RFPName value
     * @return string|null
     */
    public function getRFPName()
    {
        return $this->RFPName;
    }
    /**
     * Set RFPName value
     * @param string $rFPName
     * @return \StructType\SupplierProposal
     */
    public function setRFPName($rFPName = null)
    {
        // validation for constraint: string
        if (!is_null($rFPName) && !is_string($rFPName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPName, true), gettype($rFPName)), __LINE__);
        }
        $this->RFPName = $rFPName;
        return $this;
    }
    /**
     * Get ProposalStatus value
     * @return string|null
     */
    public function getProposalStatus()
    {
        return $this->ProposalStatus;
    }
    /**
     * Set ProposalStatus value
     * @param string $proposalStatus
     * @return \StructType\SupplierProposal
     */
    public function setProposalStatus($proposalStatus = null)
    {
        // validation for constraint: string
        if (!is_null($proposalStatus) && !is_string($proposalStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proposalStatus, true), gettype($proposalStatus)), __LINE__);
        }
        $this->ProposalStatus = $proposalStatus;
        return $this;
    }
    /**
     * Get ProposalSentDate value
     * @return string|null
     */
    public function getProposalSentDate()
    {
        return $this->ProposalSentDate;
    }
    /**
     * Set ProposalSentDate value
     * @param string $proposalSentDate
     * @return \StructType\SupplierProposal
     */
    public function setProposalSentDate($proposalSentDate = null)
    {
        // validation for constraint: string
        if (!is_null($proposalSentDate) && !is_string($proposalSentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proposalSentDate, true), gettype($proposalSentDate)), __LINE__);
        }
        $this->ProposalSentDate = $proposalSentDate;
        return $this;
    }
    /**
     * Get Commissionable value
     * @return bool|null
     */
    public function getCommissionable()
    {
        return $this->Commissionable;
    }
    /**
     * Set Commissionable value
     * @param bool $commissionable
     * @return \StructType\SupplierProposal
     */
    public function setCommissionable($commissionable = null)
    {
        // validation for constraint: boolean
        if (!is_null($commissionable) && !is_bool($commissionable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($commissionable, true), gettype($commissionable)), __LINE__);
        }
        $this->Commissionable = $commissionable;
        return $this;
    }
    /**
     * Get CommissionRate value
     * @return int|null
     */
    public function getCommissionRate()
    {
        return $this->CommissionRate;
    }
    /**
     * Set CommissionRate value
     * @param int $commissionRate
     * @return \StructType\SupplierProposal
     */
    public function setCommissionRate($commissionRate = null)
    {
        // validation for constraint: int
        if (!is_null($commissionRate) && !(is_int($commissionRate) || ctype_digit($commissionRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commissionRate, true), gettype($commissionRate)), __LINE__);
        }
        $this->CommissionRate = $commissionRate;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\SupplierProposal
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param string $createdBy
     * @return \StructType\SupplierProposal
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\SupplierProposal
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\SupplierProposal
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Get RoomSizeUnitOfMeasure value
     * @return string|null
     */
    public function getRoomSizeUnitOfMeasure()
    {
        return $this->RoomSizeUnitOfMeasure;
    }
    /**
     * Set RoomSizeUnitOfMeasure value
     * @param string $roomSizeUnitOfMeasure
     * @return \StructType\SupplierProposal
     */
    public function setRoomSizeUnitOfMeasure($roomSizeUnitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($roomSizeUnitOfMeasure) && !is_string($roomSizeUnitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomSizeUnitOfMeasure, true), gettype($roomSizeUnitOfMeasure)), __LINE__);
        }
        $this->RoomSizeUnitOfMeasure = $roomSizeUnitOfMeasure;
        return $this;
    }
    /**
     * Get CeilingHeightUnitOfMeasure value
     * @return string|null
     */
    public function getCeilingHeightUnitOfMeasure()
    {
        return $this->CeilingHeightUnitOfMeasure;
    }
    /**
     * Set CeilingHeightUnitOfMeasure value
     * @param string $ceilingHeightUnitOfMeasure
     * @return \StructType\SupplierProposal
     */
    public function setCeilingHeightUnitOfMeasure($ceilingHeightUnitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($ceilingHeightUnitOfMeasure) && !is_string($ceilingHeightUnitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ceilingHeightUnitOfMeasure, true), gettype($ceilingHeightUnitOfMeasure)), __LINE__);
        }
        $this->CeilingHeightUnitOfMeasure = $ceilingHeightUnitOfMeasure;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SupplierProposal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
